/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.launch.components;

import java.util.Collection;
import java.util.Set;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.testng.eclipse.launch.components.ITestContent;
import org.testng.eclipse.ui.util.Utils;
import org.testng.eclipse.util.signature.ASTMethodDescriptor;
import org.testng.eclipse.util.signature.IMethodDescriptor;
import org.testng.eclipse.util.signature.MethodDescriptor;
import org.testng.internal.annotations.Sets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseVisitor
extends ASTVisitor
implements ITestContent {
    private Set<IMethodDescriptor> m_testMethods = Sets.newHashSet();
    private Set<IMethodDescriptor> m_factoryMethods = Sets.newHashSet();
    private Set<String> m_groups = Sets.newHashSet();
    protected boolean m_typeIsTest;
    protected String m_annotationType;

    public BaseVisitor(boolean f) {
        super(f);
    }

    public BaseVisitor() {
    }

    @Override
    public boolean isTestNGClass() {
        return this.m_testMethods.size() > 0 || this.m_factoryMethods.size() > 0;
    }

    @Override
    public String getAnnotationType() {
        if (this.m_annotationType != null) {
            return this.m_annotationType;
        }
        return this.m_testMethods.iterator().next().getAnnotationType();
    }

    @Override
    public Set<IMethodDescriptor> getTestMethods() {
        return this.m_testMethods;
    }

    @Override
    public boolean hasTestMethods() {
        return this.m_typeIsTest || this.m_testMethods.size() > 0 || this.m_factoryMethods.size() > 0;
    }

    @Override
    public Collection<String> getGroups() {
        return this.m_groups;
    }

    protected void addGroup(String groupNames) {
        groupNames = Utils.stripDoubleQuotes(groupNames);
        String[] names = Utils.split(groupNames, ",");
        int i = 0;
        while (i < names.length) {
            this.m_groups.add(names[i]);
            ++i;
        }
    }

    protected void addTestMethod(MethodDeclaration md, String annotationType) {
        if (md.isConstructor()) {
            return;
        }
        ASTMethodDescriptor imd = new ASTMethodDescriptor(md, annotationType);
        this.m_testMethods.add(imd);
    }

    protected void addFactoryMethod(MethodDeclaration md, String annotationType) {
        ASTMethodDescriptor imd = new ASTMethodDescriptor(md, annotationType);
        this.m_factoryMethods.add(imd);
    }

    public static void ppp(String s) {
        System.out.println("[BaseVisitor] " + s);
    }

    @Override
    public boolean isTestMethod(IMethod imethod) {
        if (this.m_typeIsTest) {
            return true;
        }
        return this.m_testMethods.contains(new MethodDescriptor(imethod));
    }
}

