/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.launch;

import java.util.List;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.testng.eclipse.launch.TestNGLaunchConfigurationConstants;
import org.testng.eclipse.launch.TestNGMainTab;
import org.testng.eclipse.launch.TestngTestSelector;
import org.testng.eclipse.ui.util.ConfigurationHelper;
import org.testng.eclipse.util.ResourceUtil;
import org.testng.eclipse.util.StringUtils;

public class SuiteSelector
extends TestngTestSelector {
    private Button m_suiteBrowseButton;

    SuiteSelector(TestNGMainTab callback, TestngTestSelector.ButtonHandler handler, Composite comp) {
        super(callback, handler, TestNGLaunchConfigurationConstants.LaunchType.SUITE, comp, "TestNGMainTab.label.suiteTest");
        Composite fill = new Composite(comp, 0);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.verticalIndent = 0;
        gd.heightHint = 1;
        fill.setLayoutData((Object)gd);
        this.m_suiteBrowseButton = new Button(comp, 8);
        this.m_suiteBrowseButton.setText(ResourceUtil.getString("TestNGMainTab.label.browsefs"));
        TestngTestSelector.ButtonHandler buttonHandler = new TestngTestSelector.ButtonHandler(){

            public void handleButton() {
                FileDialog fileDialog = new FileDialog(SuiteSelector.this.m_suiteBrowseButton.getShell(), 4096);
                SuiteSelector.this.setText(fileDialog.open());
            }
        };
        TestngTestSelector.ButtonAdapter adapter = new TestngTestSelector.ButtonAdapter(this, this.getTestngType(), buttonHandler);
        this.m_suiteBrowseButton.addSelectionListener((SelectionListener)adapter);
        gd = new GridData();
        gd.verticalIndent = 0;
        this.m_suiteBrowseButton.setLayoutData((Object)gd);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        List<String> suites = ConfigurationHelper.getSuites(configuration);
        this.setText(StringUtils.listToString(suites));
    }
}

