/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.launch;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.testng.eclipse.launch.TestNGLaunchConfigurationConstants;
import org.testng.eclipse.launch.TestNGMainTab;
import org.testng.eclipse.launch.TestngTestSelector;
import org.testng.eclipse.launch.components.CheckBoxTable;
import org.testng.eclipse.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultiSelector
extends TestngTestSelector {
    private Map<String, List<String>> m_valueMap = Maps.newHashMap();
    private ILaunchConfiguration m_configuration;

    protected MultiSelector(TestNGMainTab callback, Composite comp, TestNGLaunchConfigurationConstants.LaunchType type, String labelKey, String titleId) {
        this.init(callback, this.createButtonHandler(titleId), comp, type, labelKey);
    }

    public Map<String, List<String>> getValueMap() {
        return this.m_valueMap;
    }

    protected TestngTestSelector.ButtonHandler createButtonHandler(final String titleId) {
        return new TestngTestSelector.ButtonHandler(){

            public void handleButton() {
                IJavaProject selectedProject = MultiSelector.this.getCallback().getSelectedProject();
                if (selectedProject == null) {
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"No project", (String)"Please select a project");
                } else {
                    MultiSelector.this.handleMultiSearchButtonSelected(titleId);
                }
            }
        };
    }

    @Override
    public abstract void initializeFrom(ILaunchConfiguration var1);

    protected abstract Collection<String> getValues(ILaunchConfiguration var1);

    protected abstract Map<String, List<String>> onSelect(String[] var1);

    public void handleMultiSearchButtonSelected(String titleId) {
        Collection<String> values = this.getValues(this.m_configuration);
        if (values.size() > 0) {
            Object[] uniqueValues = values.toArray(new String[values.size()]);
            Arrays.sort(uniqueValues);
            CheckBoxTable cbt = this.getCheckBoxTable(this.getCallback().getShell(), (String[])uniqueValues, titleId);
            String content = this.getText();
            if (!StringUtils.isEmptyString(content)) {
                List<String> s = StringUtils.stringToList(content);
                String[] existingValues = s.toArray(new String[s.size()]);
                cbt.checkElements(existingValues);
            }
            if (1 != cbt.open()) {
                String[] selectedValues = cbt.getSelectedElements();
                this.m_valueMap = this.onSelect(selectedValues);
                this.setText(StringUtils.listToString(Arrays.asList(selectedValues)));
            }
            this.getCallback().updateDialog();
        }
    }

    protected CheckBoxTable getCheckBoxTable(Shell shell, String[] values, String titleId) {
        return new CheckBoxTable(this.getCallback().getShell(), values, titleId);
    }
}

