/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractSet;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.testng.eclipse.ui.TestRunnerViewPart;
import org.testng.eclipse.ui.util.ConfigurationHelper;
import org.testng.eclipse.util.JDTUtil;
import org.testng.eclipse.util.PreferenceStoreUtil;
import org.testng.eclipse.util.SWTUtil;
import org.testng.remote.RemoteTestNG;

public class TestNGPlugin
extends AbstractUIPlugin
implements ILaunchListener {
    private static TestNGPlugin m_pluginInstance = null;
    public static final String PLUGIN_ID = "org.testng.eclipse";
    private static URL m_fgIconBaseURL;
    private static boolean m_isStopped;
    private AbstractSet n_trackedLaunches = new HashSet(20);
    private BundleContext m_context;
    private PreferenceStoreUtil m_preferenceUtil;
    public static Font BOLD_FONT;
    public static Font REGULAR_FONT;

    static {
        m_isStopped = false;
        BOLD_FONT = null;
        REGULAR_FONT = null;
    }

    public TestNGPlugin() {
        m_pluginInstance = this;
        try {
            m_fgIconBaseURL = new URL(Platform.getBundle((String)PLUGIN_ID).getEntry("/"), "icons/full/");
        }
        catch (MalformedURLException malformedURLException) {}
    }

    public static TestNGPlugin getDefault() {
        return m_pluginInstance;
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    public static PreferenceStoreUtil getPluginPreferenceStore() {
        return TestNGPlugin.m_pluginInstance.m_preferenceUtil;
    }

    public static void log(String s) {
        TestNGPlugin.log((IStatus)new Status(1, TestNGPlugin.getPluginId(), 0, s, null));
    }

    public static void log(Throwable e) {
        TestNGPlugin.log((IStatus)new Status(4, TestNGPlugin.getPluginId(), 4, "Error", e));
    }

    public static void log(IStatus status) {
        TestNGPlugin.getDefault().getLog().log(status);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.m_context = context;
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        launchManager.addLaunchListener((ILaunchListener)this);
        m_isStopped = false;
        this.m_preferenceUtil = new PreferenceStoreUtil(this.getPreferenceStore());
    }

    public void stop(BundleContext context) throws Exception {
        try {
            if (BOLD_FONT != null) {
                BOLD_FONT.dispose();
            }
            m_isStopped = true;
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            launchManager.removeLaunchListener((ILaunchListener)this);
        }
        finally {
            super.stop(context);
            this.m_context = null;
        }
    }

    public static boolean isStopped() {
        return m_isStopped;
    }

    public void launchRemoved(final ILaunch launch) {
        this.n_trackedLaunches.remove(launch);
        TestNGPlugin.asyncExec(new Runnable(){

            public void run() {
                TestRunnerViewPart testRunnerViewPart = TestNGPlugin.this.findTestRunnerViewPartInActivePage();
                if (testRunnerViewPart != null && testRunnerViewPart.isCreated() && launch.equals(testRunnerViewPart.getLastLaunch())) {
                    testRunnerViewPart.reset();
                }
            }
        });
    }

    public static void asyncExec(Runnable runnable) {
        SWTUtil.getDisplay().asyncExec(runnable);
    }

    public void launchAdded(ILaunch launch) {
        this.n_trackedLaunches.add(launch);
    }

    public void launchChanged(final ILaunch launch) {
        if (!this.n_trackedLaunches.contains(launch)) {
            return;
        }
        int port = -1;
        String projectName = "";
        String subName = "";
        try {
            port = ConfigurationHelper.getPort(launch);
            projectName = ConfigurationHelper.getProjectName(launch);
            subName = ConfigurationHelper.getSubName(launch);
        }
        catch (Exception ex) {
            TestNGPlugin.log(ex);
            return;
        }
        if (projectName == null) {
            return;
        }
        final int finalPort = TestNGPlugin.isDebug() ? Integer.parseInt("12345") : port;
        final IJavaProject ijp = JDTUtil.getJavaProject(projectName);
        final String name = subName;
        this.n_trackedLaunches.remove(launch);
        TestNGPlugin.asyncExec(new Runnable(){

            public void run() {
                TestNGPlugin.this.connectTestRunner(launch, ijp, name, finalPort);
            }
        });
    }

    public void connectTestRunner(ILaunch launch, IJavaProject launchedProject, String subName, int port) {
        IViewPart viewPart = this.showTestRunnerViewPartInActivePage(this.findTestRunnerViewPartInActivePage());
        if (viewPart instanceof TestRunnerViewPart) {
            ((TestRunnerViewPart)viewPart).startTestRunListening(launchedProject, subName, port, launch);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IViewPart showTestRunnerViewPartInActivePage(TestRunnerViewPart testRunner) {
        IViewPart iViewPart;
        IWorkbenchPage page;
        IWorkbenchPart activePart;
        block12: {
            block11: {
                TestRunnerViewPart testRunnerViewPart;
                block10: {
                    activePart = null;
                    page = null;
                    try {
                        if (testRunner != null && testRunner.isCreated()) {
                            testRunnerViewPart = testRunner;
                            if (page == null) return testRunnerViewPart;
                            if (activePart == null) return testRunnerViewPart;
                            break block10;
                        }
                        page = SWTUtil.getActivePage(this.getWorkbench());
                        if (page == null) {
                            if (page == null) return null;
                            break block11;
                        }
                        activePart = page.getActivePart();
                        iViewPart = page.showView("org.testng.eclipse.ResultView");
                        if (page == null) return iViewPart;
                        break block12;
                    }
                    catch (PartInitException pie) {
                        TestNGPlugin.log(pie);
                        return null;
                    }
                }
                page.activate(activePart);
                return testRunnerViewPart;
            }
            if (activePart == null) return null;
            page.activate(activePart);
            return null;
        }
        if (activePart == null) return iViewPart;
        page.activate(activePart);
        return iViewPart;
        finally {
            if (page != null && activePart != null) {
                page.activate(activePart);
            }
        }
    }

    private TestRunnerViewPart findTestRunnerViewPartInActivePage() {
        IWorkbenchPage page = SWTUtil.getActivePage(this.getWorkbench());
        if (page == null) {
            return null;
        }
        IViewPart view = page.findView("org.testng.eclipse.ResultView");
        if (view instanceof TestRunnerViewPart) {
            return (TestRunnerViewPart)view;
        }
        return null;
    }

    public static URL makeIconFileURL(String name) throws MalformedURLException {
        if (m_fgIconBaseURL == null) {
            throw new MalformedURLException();
        }
        return new URL(m_fgIconBaseURL, name);
    }

    public static ImageDescriptor getImageDescriptor(String relativePath) {
        try {
            return ImageDescriptor.createFromURL((URL)TestNGPlugin.makeIconFileURL(relativePath));
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static void ppp(Object message) {
    }

    public static void bold(Control label, boolean bold) {
        if (BOLD_FONT == null) {
            REGULAR_FONT = label.getFont();
            FontData data = REGULAR_FONT.getFontData()[0];
            data.setStyle(data.getStyle() | 1);
            BOLD_FONT = new Font((Device)label.getDisplay(), data);
        }
        label.setFont(bold ? BOLD_FONT : REGULAR_FONT);
    }

    public Bundle getBundle(String bundleName) {
        Bundle bundle = Platform.getBundle((String)bundleName);
        if (bundle != null) {
            return bundle;
        }
        ServiceReference serviceRef = this.m_context.getServiceReference(PackageAdmin.class.getName());
        PackageAdmin admin = (PackageAdmin)this.m_context.getService(serviceRef);
        Bundle[] bundles = admin.getBundles(bundleName, null);
        if (bundles != null && bundles.length > 0) {
            return bundles[0];
        }
        return null;
    }

    public static boolean isEmtpy(String string) {
        return string == null || "".equals(string.trim());
    }

    public static String getFailedTestsKey() {
        return "failedTests";
    }

    public static boolean isVerbose() {
        return RemoteTestNG.isVerbose();
    }

    public static boolean isDebug() {
        return RemoteTestNG.isDebug();
    }
}

