/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.bamboo.ui.views;

import com.atlassian.connector.eclipse.internal.bamboo.ui.views.TestResultsView;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class OpenEditorAction
extends Action {
    protected String fClassName;
    protected TestResultsView fTestRunner;
    private final boolean fActivate;

    protected OpenEditorAction(TestResultsView testRunner, String testClassName) {
        this(testRunner, testClassName, true);
    }

    public OpenEditorAction(TestResultsView testRunner, String className, boolean activate) {
        super("&Go to File");
        this.fClassName = className;
        this.fTestRunner = testRunner;
        this.fActivate = activate;
    }

    public void run() {
        ITextEditor textEditor = null;
        try {
            IJavaElement element = this.findElement(this.fClassName);
            if (element == null) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Cannot Open Editor", (String)"Test class not found in selected project");
                return;
            }
            textEditor = (ITextEditor)JavaUI.openInEditor((IJavaElement)element, (boolean)this.fActivate, (boolean)false);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Cannot open editor", (IStatus)e.getStatus());
            return;
        }
        if (textEditor == null) {
            this.fTestRunner.registerInfoMessage("Cannot open editor");
            return;
        }
        this.reveal(textEditor);
    }

    protected Shell getShell() {
        return this.fTestRunner.getSite().getShell();
    }

    protected String getClassName() {
        return this.fClassName;
    }

    protected abstract IJavaElement findElement(String var1) throws CoreException;

    protected abstract void reveal(ITextEditor var1);

    protected IType findType(String fullyQualifiedName) throws JavaModelException {
        IJavaProject[] projects;
        IJavaProject[] iJavaProjectArray = projects = JavaModelManager.getJavaModelManager().getJavaModel().getJavaProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject project = iJavaProjectArray[n2];
            IType itype = project.findType(fullyQualifiedName);
            if (itype != null && itype.getResource().getProject().equals((Object)project.getProject())) {
                return itype;
            }
            ++n2;
        }
        return null;
    }

    private IType internalFindType(IJavaProject project, String className, Set visitedProjects, IProgressMonitor monitor) throws JavaModelException {
        try {
            if (visitedProjects.contains(project)) {
                return null;
            }
            monitor.beginTask("", 2);
            IType type = project.findType(className, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (type != null) {
                IType iType = type;
                return iType;
            }
            visitedProjects.add(project);
            IJavaModel javaModel = project.getJavaModel();
            String[] requiredProjectNames = project.getRequiredProjectNames();
            SubProgressMonitor reqMonitor = new SubProgressMonitor(monitor, 1);
            reqMonitor.beginTask("", requiredProjectNames.length);
            String[] stringArray = requiredProjectNames;
            int n = requiredProjectNames.length;
            int n2 = 0;
            while (n2 < n) {
                String requiredProjectName = stringArray[n2];
                IJavaProject requiredProject = javaModel.getJavaProject(requiredProjectName);
                if (requiredProject.exists() && (type = this.internalFindType(requiredProject, className, visitedProjects, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)reqMonitor, 1))) != null) {
                    IType iType = type;
                    return iType;
                }
                ++n2;
            }
            return null;
        }
        finally {
            monitor.done();
        }
    }
}

