/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.bamboo.ui;

import com.atlassian.theplugin.commons.bamboo.BambooBuild;
import com.atlassian.theplugin.commons.bamboo.BuildStatus;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

public class BambooBuildViewerComparator
extends ViewerComparator {
    private SortOrder sortOrder = SortOrder.UNSORTED;

    public SortOrder toggleSortOrder() {
        this.sortOrder = SortOrder.next(this.sortOrder);
        return this.sortOrder;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public boolean isSorterProperty(Object element, String property) {
        return true;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        if (e1 instanceof BambooBuild && e2 instanceof BambooBuild) {
            BuildStatus state1 = ((BambooBuild)e1).getStatus();
            BuildStatus state2 = ((BambooBuild)e2).getStatus();
            switch (this.sortOrder) {
                case UNSORTED: {
                    return this.sortByName((BambooBuild)e1, (BambooBuild)e2);
                }
                case STATE_PASSED_FAILED: {
                    if (state1 == state2) {
                        return this.sortByName((BambooBuild)e1, (BambooBuild)e2);
                    }
                    if (state1 == BuildStatus.SUCCESS) {
                        return -1;
                    }
                    if (state2 == BuildStatus.SUCCESS) {
                        return 1;
                    }
                    if (state1 == BuildStatus.FAILURE) {
                        return -1;
                    }
                    if (state2 == BuildStatus.FAILURE) {
                        return 1;
                    }
                    return this.sortByName((BambooBuild)e1, (BambooBuild)e2);
                }
                case STATE_FAILED_PASSED: {
                    if (state1 == state2) {
                        return this.sortByName((BambooBuild)e1, (BambooBuild)e2);
                    }
                    if (state1 == BuildStatus.FAILURE) {
                        return -1;
                    }
                    if (state2 == BuildStatus.FAILURE) {
                        return 1;
                    }
                    if (state1 == BuildStatus.SUCCESS) {
                        return -1;
                    }
                    if (state2 == BuildStatus.SUCCESS) {
                        return 1;
                    }
                    return this.sortByName((BambooBuild)e1, (BambooBuild)e2);
                }
            }
        }
        return 0;
    }

    private int sortByName(BambooBuild bb1, BambooBuild bb2) {
        if (bb1 == null || bb2 == null || bb1.getPlanName() == null || bb2.getPlanName() == null) {
            return 0;
        }
        return bb1.getPlanName().compareTo(bb2.getPlanName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SortOrder {
        UNSORTED(0),
        STATE_PASSED_FAILED(128),
        STATE_FAILED_PASSED(1024);

        private final int direction;

        private SortOrder(int direction) {
            this.direction = direction;
        }

        public int getDirection() {
            return this.direction;
        }

        public static SortOrder next(SortOrder current) {
            switch (current) {
                case UNSORTED: {
                    return STATE_PASSED_FAILED;
                }
                case STATE_PASSED_FAILED: {
                    return STATE_FAILED_PASSED;
                }
            }
            return UNSORTED;
        }
    }
}

