/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.data.jdt.core;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.core.GenericTypeResolver;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.data.repository.Repository;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.model.ISourceModelElement;
import org.springframework.ide.eclipse.core.model.ModelUtils;
import org.springframework.ide.eclipse.data.SpringDataUtils;
import org.springframework.ide.eclipse.data.jdt.core.DefaultTypePredicates;
import org.springframework.ide.eclipse.data.jdt.core.JpaKeywordProvider;
import org.springframework.ide.eclipse.data.jdt.core.KeywordProvider;
import org.springframework.ide.eclipse.data.jdt.core.KeywordProviderSupport;
import org.springframework.ide.eclipse.data.jdt.core.MongoDbKeywordProvider;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryInformation {
    private static Set<String> METHOD_NAMES = new HashSet<String>();
    private final IType type;
    private final Class<?> repositoryInterface;
    private final Class<?> repositoryBaseInterface;

    static {
        Method[] methodArray = PagingAndSortingRepository.class.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            METHOD_NAMES.add(method.getName());
            ++n2;
        }
    }

    public RepositoryInformation(IType type) {
        try {
            this.type = type;
            ClassLoader classLoader = JdtUtils.getClassLoader((IProject)type.getJavaProject().getProject(), null);
            this.repositoryInterface = classLoader.loadClass(type.getFullyQualifiedName());
            this.repositoryBaseInterface = classLoader.loadClass(Repository.class.getName());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not load class " + type.getFullyQualifiedName(), e);
        }
    }

    public static RepositoryInformation create(IMethod element) {
        Assert.notNull((Object)element);
        IType type = element.getDeclaringType();
        return RepositoryInformation.create(type);
    }

    public static RepositoryInformation create(IType type) {
        Assert.notNull((Object)type);
        try {
            return type.isInterface() && type.exists() ? new RepositoryInformation(type) : null;
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isSpringDataRepository(IType type) {
        if (type == null) {
            return false;
        }
        try {
            IAnnotation[] annotations;
            IAnnotation[] iAnnotationArray = annotations = type.getAnnotations();
            int n = annotations.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return RepositoryInformation.isSpringDataRepositoryInterfaces(type);
                }
                IAnnotation annotation = iAnnotationArray[n2];
                if (annotation.getElementName().equals("org.springframework.data.repository.NoRepositoryBean") || annotation.getElementName().equals("NoRepositoryBean")) {
                    return false;
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isSpringDataRepositoryInterfaces(IType type) {
        if (type == null) {
            return false;
        }
        String fullyQualifiedName = type.getFullyQualifiedName();
        if ("org.springframework.data.repository.Repository".equals(fullyQualifiedName)) {
            return true;
        }
        try {
            String[] interfaceNames;
            IAnnotation[] annotations;
            IAnnotation[] iAnnotationArray = annotations = type.getAnnotations();
            int n = annotations.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    interfaceNames = null;
                    interfaceNames = type.isBinary() ? type.getSuperInterfaceNames() : SpringCore.getTypeHierarchyEngine().getInterfaces(type.getJavaProject().getProject(), type.getFullyQualifiedName(), true);
                }
                IAnnotation annotation = iAnnotationArray[n2];
                if (annotation.getElementName().equals("org.springframework.data.repository.RepositoryDefinition")) return true;
                if (annotation.getElementName().equals("RepositoryDefinition")) {
                    return true;
                }
                ++n2;
            }
            if (interfaceNames == null) return false;
            String[] stringArray = interfaceNames;
            int n3 = interfaceNames.length;
            n = 0;
            while (true) {
                if (n >= n3) {
                    return false;
                }
                String superInterface = stringArray[n];
                IType interfaceType = type.getJavaProject().findType(superInterface);
                if (RepositoryInformation.isSpringDataRepositoryInterfaces(interfaceType)) {
                    return true;
                }
                ++n;
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    public KeywordProvider getKeywordProvider(IJavaProject project) {
        DefaultTypePredicates predicates = new DefaultTypePredicates(project);
        IBean repositoryBean = SpringDataUtils.getRepositoryBean(project.getProject(), this.repositoryInterface.getName());
        Module module = Module.getModuleOf(repositoryBean);
        switch (module) {
            case JPA: {
                return new JpaKeywordProvider(predicates);
            }
            case MONGO: {
                return new MongoDbKeywordProvider(predicates);
            }
        }
        return new KeywordProviderSupport(predicates);
    }

    public Class<?> getManagedDomainClass() {
        try {
            Class[] resolvedTypeArguments = GenericTypeResolver.resolveTypeArguments(this.repositoryInterface, this.repositoryBaseInterface);
            if (resolvedTypeArguments != null && resolvedTypeArguments.length > 0) {
                return resolvedTypeArguments[0];
            }
        }
        catch (TypeNotPresentException typeNotPresentException) {}
        return null;
    }

    public Iterable<IMethod> getMethodsToValidate() {
        HashSet<IMethod> result = new HashSet<IMethod>();
        try {
            IMethod[] iMethodArray = this.type.getMethods();
            int n = iMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                if (!this.isCrudMethod(method) && !this.hasQueryAnnotation(method)) {
                    result.add(method);
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            SpringCore.log((Throwable)e);
        }
        return result;
    }

    private boolean isCrudMethod(IMethod method) {
        return METHOD_NAMES.contains(method.getElementName());
    }

    private boolean hasQueryAnnotation(IMethod method) throws JavaModelException {
        IAnnotation[] iAnnotationArray = method.getAnnotations();
        int n = iAnnotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation annotation = iAnnotationArray[n2];
            if (annotation.getElementName().equals("Query")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Module {
        JPA("jpa"),
        MONGO("mongo"),
        GENERIC;

        public static final String BASE = "http://www.springframework.org/schema/data/";
        private String namespace;

        private Module(String namespace) {
            this.namespace = StringUtils.hasText((String)namespace) ? BASE + namespace : "";
        }

        private Module() {
            this(null);
        }

        public static Module getModuleOf(IBean bean) {
            Module[] moduleArray = Module.values();
            int n = moduleArray.length;
            int n2 = 0;
            while (n2 < n) {
                Module candidate = moduleArray[n2];
                String uri = ModelUtils.getNameSpaceURI((ISourceModelElement)bean);
                if (uri != null && uri.equals(candidate.namespace)) {
                    return candidate;
                }
                ++n2;
            }
            return GENERIC;
        }
    }
}

