/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.data.jdt.core;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.springframework.ide.eclipse.core.StringUtils;
import org.springsource.ide.eclipse.commons.core.StatusHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindByMethodCompletionProposal
implements IJavaCompletionProposal,
ICompletionProposalExtension2 {
    private final String propertyName;
    private final Class<?> propertyClass;
    private final Class<?> domainClass;
    private final int startOffset;
    private final int endOffset;
    private IRegion selectedRegion;
    private final ICompilationUnit cu;

    public FindByMethodCompletionProposal(String propertyName, Class<?> propertyClass, Class<?> domainClass, int startOffset, int endOffset, JavaContentAssistInvocationContext javaContext) {
        this.propertyName = propertyName;
        this.propertyClass = propertyClass;
        this.domainClass = domainClass;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.selectedRegion = new Region(startOffset, endOffset);
        this.cu = javaContext.getCompilationUnit();
    }

    public static String getMethodName(String propertyName) {
        return "findBy" + StringUtils.capitalize((String)propertyName);
    }

    private String getMethodString() {
        StringBuilder str = new StringBuilder();
        str.append(FindByMethodCompletionProposal.getMethodName(this.propertyName));
        str.append("(");
        str.append(this.propertyClass.getSimpleName());
        str.append(" ");
        str.append(this.propertyName.toLowerCase());
        str.append(") : ");
        str.append("List<");
        str.append(this.domainClass.getSimpleName());
        str.append(">");
        return str.toString();
    }

    public Point getSelection(IDocument document) {
        return new Point(this.selectedRegion.getOffset(), this.selectedRegion.getLength());
    }

    public String getAdditionalProposalInfo() {
        return null;
    }

    public String getDisplayString() {
        return this.getMethodString();
    }

    public Image getImage() {
        return JavaPluginImages.get((String)"org.eclipse.jdt.ui.methpub_obj.gif");
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public int getRelevance() {
        return 0;
    }

    private void beginCompoundChange(ITextViewer viewer) {
        if (viewer instanceof ITextViewerExtension) {
            ITextViewerExtension extension = (ITextViewerExtension)viewer;
            IRewriteTarget rewriteTarget = extension.getRewriteTarget();
            rewriteTarget.beginCompoundChange();
        }
    }

    private void endCompoundChange(ITextViewer viewer) {
        if (viewer instanceof ITextViewerExtension) {
            ITextViewerExtension extension = (ITextViewerExtension)viewer;
            IRewriteTarget rewriteTarget = extension.getRewriteTarget();
            rewriteTarget.beginCompoundChange();
        }
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        IDocument document = viewer.getDocument();
        try {
            try {
                this.beginCompoundChange(viewer);
                int oldImportPos = this.getLastImportEndPosition();
                if (this.cu.getImport(this.propertyClass.getCanonicalName()) != null) {
                    this.cu.createImport(this.propertyClass.getCanonicalName(), null, null);
                }
                if (this.cu.getImport(this.domainClass.getCanonicalName()) != null) {
                    this.cu.createImport(this.domainClass.getCanonicalName(), null, null);
                }
                if (this.cu.getImport("java.util.List") != null) {
                    this.cu.createImport("java.util.List", null, null);
                }
                int importOffset = this.getLastImportEndPosition() - oldImportPos;
                LinkedModeModel model = new LinkedModeModel();
                StringBuilder methodStr = new StringBuilder();
                ArrayList<LinkedPositionGroup> groups = new ArrayList<LinkedPositionGroup>();
                LinkedPositionGroup group = new LinkedPositionGroup();
                int startPos = this.startOffset + importOffset + methodStr.length();
                methodStr.append("List<");
                methodStr.append(this.domainClass.getSimpleName());
                methodStr.append(">");
                int length = methodStr.length();
                group.addPosition(new LinkedPosition(document, startPos, length));
                groups.add(group);
                methodStr.append(" ");
                group = new LinkedPositionGroup();
                startPos = this.startOffset + importOffset + methodStr.length();
                String methodName = FindByMethodCompletionProposal.getMethodName(this.propertyName);
                methodStr.append(methodName);
                length = methodName.length();
                group.addPosition(new LinkedPosition(document, startPos, length));
                groups.add(group);
                methodStr.append("(");
                group = new LinkedPositionGroup();
                startPos = this.startOffset + importOffset + methodStr.length();
                String paramTypeName = this.propertyClass.getSimpleName();
                length = paramTypeName.length();
                methodStr.append(paramTypeName);
                group.addPosition(new LinkedPosition(document, startPos, length));
                groups.add(group);
                methodStr.append(" ");
                group = new LinkedPositionGroup();
                startPos = this.startOffset + importOffset + methodStr.length();
                String paramName = this.propertyName.toLowerCase();
                length = paramName.length();
                methodStr.append(paramName);
                group.addPosition(new LinkedPosition(document, startPos, length));
                groups.add(group);
                methodStr.append(");");
                document.replace(this.startOffset + importOffset, this.endOffset - this.startOffset, methodStr.toString());
                for (LinkedPositionGroup currGroup : groups) {
                    model.addGroup(currGroup);
                }
                model.forceInstall();
                LinkedModeUI ui = new LinkedModeUI(model, viewer);
                ui.setExitPosition(viewer, this.startOffset + importOffset + methodStr.length(), 0, Integer.MAX_VALUE);
                ui.enter();
                this.selectedRegion = ui.getSelectedRegion();
            }
            catch (BadLocationException e) {
                StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.data.core", e.getMessage(), (Throwable)e));
                this.endCompoundChange(viewer);
            }
            catch (JavaModelException e) {
                StatusHandler.log((IStatus)new Status(4, "org.springframework.ide.eclipse.data.core", e.getMessage(), (Throwable)e));
                this.endCompoundChange(viewer);
            }
        }
        finally {
            this.endCompoundChange(viewer);
        }
    }

    private int getLastImportEndPosition() {
        try {
            IImportDeclaration[] imports = this.cu.getImports();
            int lastPos = -1;
            IImportDeclaration[] iImportDeclarationArray = imports;
            int n = imports.length;
            int n2 = 0;
            while (n2 < n) {
                int currPos;
                IImportDeclaration currImport = iImportDeclarationArray[n2];
                ISourceRange sourceRange = currImport.getSourceRange();
                if (sourceRange != null && (currPos = sourceRange.getOffset() + sourceRange.getLength()) > lastPos) {
                    lastPos = currPos;
                }
                ++n2;
            }
            return lastPos;
        }
        catch (JavaModelException javaModelException) {
            return -1;
        }
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
    }

    public void unselected(ITextViewer viewer) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        return true;
    }

    @Deprecated
    public void apply(IDocument document) {
    }
}

