/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.commands;

import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.Policy;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.client.OperationManager;
import org.tigris.subversion.subclipse.core.client.OperationProgressNotifyListener;
import org.tigris.subversion.subclipse.core.client.OperationResourceCollector;
import org.tigris.subversion.subclipse.core.commands.ISVNCommand;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class AddResourcesCommand
implements ISVNCommand {
    private IResource[] resources;
    private int depth;
    private SVNWorkspaceRoot root;
    private OperationResourceCollector operationResourceCollector = new OperationResourceCollector();

    public AddResourcesCommand(SVNWorkspaceRoot root, IResource[] resources, int depth) {
        this.resources = resources;
        this.depth = depth;
        this.root = root;
    }

    public void run(IProgressMonitor monitor) throws SVNException {
        monitor = Policy.monitorFor(monitor);
        final TreeSet<ISVNLocalResource> folders = new TreeSet<ISVNLocalResource>();
        final HashSet files = new HashSet();
        int i = 0;
        while (i < this.resources.length) {
            final IResource currentResource = this.resources[i];
            try {
                IContainer parent = currentResource.getParent();
                ISVNLocalResource svnParentResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)parent);
                while (parent.getType() != 8 && parent.getType() != 4 && !svnParentResource.isManaged()) {
                    folders.add(svnParentResource);
                    parent = parent.getParent();
                    svnParentResource = svnParentResource.getParent();
                }
                final SVNException[] exception = new SVNException[1];
                currentResource.accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) {
                        try {
                            ISVNLocalResource mResource = SVNWorkspaceRoot.getSVNResourceFor(resource);
                            if (!(mResource.isManaged() || !currentResource.equals((Object)resource) && mResource.isIgnored())) {
                                if (resource.getType() == 1) {
                                    files.add(mResource);
                                } else {
                                    folders.add(mResource);
                                }
                            }
                            return true;
                        }
                        catch (SVNException e) {
                            exception[0] = e;
                            return false;
                        }
                    }
                }, this.depth, false);
                if (exception[0] != null) {
                    throw exception[0];
                }
            }
            catch (CoreException e) {
                throw new SVNException((IStatus)new Status(4, "org.tigris.subversion.subclipse.core", -6, Policy.bind("SVNTeamProvider.visitError", new Object[]{this.resources[i].getFullPath()}), (Throwable)e));
            }
            ++i;
        }
        ISVNClientAdapter svnClient = this.root.getRepository().getSVNClient();
        monitor.beginTask(null, files.size() + folders.size());
        monitor.setTaskName("Adding...");
        svnClient.addNotifyListener((ISVNNotifyListener)this.operationResourceCollector);
        OperationManager.getInstance().beginOperation(svnClient, new OperationProgressNotifyListener(monitor, svnClient));
        try {
            for (ISVNLocalResource localResource : folders) {
                try {
                    svnClient.addDirectory(localResource.getIResource().getLocation().toFile(), false);
                    localResource.refreshStatus();
                }
                catch (SVNClientException e) {
                    throw SVNException.wrapException((Exception)((Object)e));
                }
            }
            for (ISVNLocalResource localResource : files) {
                try {
                    svnClient.addFile(localResource.getIResource().getLocation().toFile());
                    ResourceAttributes attrs = localResource.getIResource().getResourceAttributes();
                    if (localResource.getIResource().getType() != 1 || !attrs.isReadOnly()) continue;
                    attrs.setReadOnly(false);
                    try {
                        localResource.getIResource().setResourceAttributes(attrs);
                    }
                    catch (CoreException coreException) {}
                }
                catch (SVNClientException e) {
                    throw SVNException.wrapException((Exception)((Object)e));
                }
            }
        }
        finally {
            Set<IResource> operationResources = this.operationResourceCollector.getOperationResources();
            OperationManager.getInstance().endOperation(true, operationResources);
            monitor.done();
            if (svnClient != null) {
                svnClient.removeNotifyListener((ISVNNotifyListener)this.operationResourceCollector);
                this.root.getRepository().returnSVNClient(svnClient);
            }
        }
    }
}

