/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.client;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.client.OperationProgressNotifyListener;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.core.util.FilteringContainerList;
import org.tigris.subversion.subclipse.core.util.ReentrantLock;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.ISVNProgressListener;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationManager
implements ISVNNotifyListener {
    private ReentrantLock lock = new ReentrantLock();
    private Set<IResource> localRefreshList = new LinkedHashSet<IResource>();
    private ISVNClientAdapter svnClient = null;
    private OperationProgressNotifyListener operationNotifyListener = null;
    private static OperationManager instance;

    private OperationManager() {
    }

    public static OperationManager getInstance() {
        if (instance == null) {
            instance = new OperationManager();
        }
        return instance;
    }

    public void beginOperation(ISVNClientAdapter aSvnClient) {
        this.lock.acquire();
        this.svnClient = aSvnClient;
        aSvnClient.addNotifyListener((ISVNNotifyListener)this);
        if (this.operationNotifyListener != null) {
            aSvnClient.setProgressListener((ISVNProgressListener)this.operationNotifyListener);
        }
    }

    public void beginOperation(ISVNClientAdapter aSvnClient, OperationProgressNotifyListener anOperationNotifyListener) {
        this.operationNotifyListener = anOperationNotifyListener;
        this.beginOperation(aSvnClient);
    }

    public void endOperation(boolean refresh) throws SVNException {
        this.endOperation(refresh, null);
    }

    public void endOperation() throws SVNException {
        this.endOperation(true, null);
    }

    public void endOperation(boolean refresh, Set<IResource> refreshResourceList) throws SVNException {
        this.endOperation(refresh, refreshResourceList, true);
    }

    public void endOperation(boolean refresh, Set<IResource> refreshResourceList, boolean refreshLocal) throws SVNException {
        try {
            if (this.lock.getNestingCount() == 1) {
                this.svnClient.removeNotifyListener((ISVNNotifyListener)this);
                if (this.operationNotifyListener != null) {
                    this.operationNotifyListener.clear();
                    this.svnClient.setProgressListener(null);
                }
                if (refreshResourceList != null) {
                    FilteringContainerList folderList = new FilteringContainerList(refreshResourceList);
                    for (IContainer resource : folderList) {
                        SVNProviderPlugin.getPlugin().getStatusCacheManager().refreshStatus((IResource)resource, true);
                    }
                    IResource[] resources = new IResource[refreshResourceList.size()];
                    refreshResourceList.toArray(resources);
                    SVNProviderPlugin.broadcastModificationStateChanges(resources);
                }
                if (refreshLocal) {
                    FilteringContainerList foldersToRefresh = new FilteringContainerList(this.localRefreshList);
                    for (IContainer folder : foldersToRefresh) {
                        try {
                            folder.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (CoreException coreException) {}
                    }
                }
            }
        }
        finally {
            this.lock.release();
            this.operationNotifyListener = null;
            this.localRefreshList = new LinkedHashSet<IResource>();
        }
    }

    public void onNotify(File path, SVNNodeKind kind) {
        IResource[] resources;
        Path pathEclipse = new Path(path.getAbsolutePath());
        IResource[] iResourceArray = resources = SVNWorkspaceRoot.getResourcesFor((IPath)pathEclipse, false);
        int n = 0;
        int n2 = iResourceArray.length;
        while (n < n2) {
            IResource resource = iResourceArray[n];
            this.localRefreshList.add(resource);
            ++n;
        }
        if (this.operationNotifyListener != null) {
            this.operationNotifyListener.onNotify(path, kind);
            if (this.operationNotifyListener.getMonitor() != null && this.operationNotifyListener.getMonitor().isCanceled()) {
                try {
                    this.svnClient.cancelOperation();
                }
                catch (SVNClientException e) {
                    SVNProviderPlugin.log(SVNException.wrapException((Exception)((Object)e)));
                }
            }
        }
    }

    public void logCommandLine(String commandLine) {
    }

    public void logRevision(long revision, String path) {
    }

    public void logCompleted(String message) {
        if (this.operationNotifyListener != null) {
            this.operationNotifyListener.logMessage(message);
        }
    }

    public void logError(String message) {
    }

    public void logMessage(String message) {
        if (this.operationNotifyListener != null) {
            this.operationNotifyListener.logMessage(message);
        }
    }

    public void setCommand(int command) {
    }
}

