/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.editor.hyperlink.webflow;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.ClassHyperlinkCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.IHyperlinkCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.NamespaceHyperlinkDetectorSupport;
import org.springframework.ide.eclipse.webflow.ui.editor.hyperlink.webflow.StateReferenceHyperlinkCalculator;
import org.springframework.ide.eclipse.webflow.ui.editor.hyperlink.webflow.SubflowReferenceHyperlinkCalculator;
import org.springframework.ide.eclipse.webflow.ui.editor.hyperlink.webflow.WebflowActionMethodHyperlinkCalculator;
import org.springframework.ide.eclipse.webflow.ui.editor.hyperlink.webflow.WebflowBeanReferenceHyperlinkCalculator;
import org.w3c.dom.Attr;

public class WebflowHyperlinkDetector
extends NamespaceHyperlinkDetectorSupport
implements IHyperlinkDetector {
    private static final Set<String> VALID_ATTRIBUTES = new LinkedHashSet<String>();

    static {
        VALID_ATTRIBUTES.add("bean");
        VALID_ATTRIBUTES.add("method");
        VALID_ATTRIBUTES.add("to");
        VALID_ATTRIBUTES.add("on-exception");
        VALID_ATTRIBUTES.add("from");
        VALID_ATTRIBUTES.add("to");
        VALID_ATTRIBUTES.add("idref");
        VALID_ATTRIBUTES.add("class");
        VALID_ATTRIBUTES.add("then");
        VALID_ATTRIBUTES.add("else");
        VALID_ATTRIBUTES.add("type");
        VALID_ATTRIBUTES.add("name");
        VALID_ATTRIBUTES.add("flow");
        VALID_ATTRIBUTES.add("type");
        VALID_ATTRIBUTES.add("class");
        VALID_ATTRIBUTES.add("result-type");
        VALID_ATTRIBUTES.add("bean");
        VALID_ATTRIBUTES.add("subflow-attribute-mapper");
        VALID_ATTRIBUTES.add("to");
        VALID_ATTRIBUTES.add("start-state");
        VALID_ATTRIBUTES.add("then");
        VALID_ATTRIBUTES.add("else");
        VALID_ATTRIBUTES.add("subflow");
        VALID_ATTRIBUTES.add("parent");
    }

    public void init() {
        WebflowBeanReferenceHyperlinkCalculator beanRef = new WebflowBeanReferenceHyperlinkCalculator();
        this.registerHyperlinkCalculator("bean", beanRef);
        this.registerHyperlinkCalculator("name", beanRef);
        this.registerHyperlinkCalculator("subflow-attribute-mapper", beanRef);
        StateReferenceHyperlinkCalculator stateRef = new StateReferenceHyperlinkCalculator();
        this.registerHyperlinkCalculator("transition", "to", stateRef);
        this.registerHyperlinkCalculator("then", stateRef);
        this.registerHyperlinkCalculator("else", stateRef);
        this.registerHyperlinkCalculator("idref", stateRef);
        this.registerHyperlinkCalculator("start-state", stateRef);
        ClassHyperlinkCalculator javaElement = new ClassHyperlinkCalculator();
        this.registerHyperlinkCalculator("to", (IHyperlinkCalculator)javaElement);
        this.registerHyperlinkCalculator("on-exception", (IHyperlinkCalculator)javaElement);
        this.registerHyperlinkCalculator("type", (IHyperlinkCalculator)javaElement);
        this.registerHyperlinkCalculator("class", (IHyperlinkCalculator)javaElement);
        this.registerHyperlinkCalculator("result-type", (IHyperlinkCalculator)javaElement);
        this.registerHyperlinkCalculator("method", new WebflowActionMethodHyperlinkCalculator());
        SubflowReferenceHyperlinkCalculator flowRef = new SubflowReferenceHyperlinkCalculator();
        this.registerHyperlinkCalculator("flow", flowRef);
        this.registerHyperlinkCalculator("subflow", flowRef);
        this.registerHyperlinkCalculator("parent", flowRef);
    }

    public boolean isLinkableAttr(Attr attr) {
        return VALID_ATTRIBUTES.contains(attr.getLocalName());
    }
}

