/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.editor.contentassist.webflow;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistContext;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistProposalRecorder;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.springframework.ide.eclipse.webflow.ui.editor.WebflowNamespaceUtils;
import org.springframework.ide.eclipse.webflow.ui.editor.outline.webflow.WebflowOutlineLabelProvider;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StateReferenceContentAssistCalculator
implements IContentAssistCalculator {
    public static final int RELEVANCE = 10;
    private static final Set<String> VALID_NODE_NAMES;
    private static final ILabelProvider labelProvider;

    static {
        labelProvider = new WebflowOutlineLabelProvider();
        VALID_NODE_NAMES = new LinkedHashSet<String>();
        VALID_NODE_NAMES.add("action-state");
        VALID_NODE_NAMES.add("decision-state");
        VALID_NODE_NAMES.add("subflow-state");
        VALID_NODE_NAMES.add("end-state");
        VALID_NODE_NAMES.add("view-state");
        VALID_NODE_NAMES.add("inline-flow");
    }

    public void acceptSearchMatch(IContentAssistProposalRecorder recorder, Node node, String id, IFile file, String prefix) {
        String fileName = file.getProjectRelativePath().toString();
        String displayText = String.valueOf(id) + " - " + fileName;
        Image image = labelProvider.getImage((Object)node);
        recorder.recordProposal(image, 10, displayText, id, (Object)node);
    }

    public void computeProposals(IContentAssistContext context, IContentAssistProposalRecorder recorder) {
        Node flowNode = WebflowNamespaceUtils.locateFlowRootNode(context.getNode());
        NodeList nodes = flowNode.getChildNodes();
        if (nodes.getLength() > 0) {
            IFile file = context.getFile();
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                String id = BeansEditorUtils.getAttribute((Node)node, (String)"id");
                if (node != null && id != null && id.toLowerCase().startsWith(context.getMatchString().toLowerCase()) && VALID_NODE_NAMES.contains(node.getLocalName())) {
                    this.acceptSearchMatch(recorder, nodes.item(i), id, file, context.getMatchString());
                }
                ++i;
            }
        }
    }
}

