/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17.db;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetTransactionMode;
import org.tmatesoft.sqljet.core.table.ISqlJetCursor;
import org.tmatesoft.sqljet.core.table.ISqlJetTable;
import org.tmatesoft.sqljet.core.table.SqlJetDb;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetSelectStatement;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetStatement;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbShared;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbStatementUtil;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbStatements;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnWcDbReader
extends SvnWcDbShared {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<File> getServerExcludedNodes(SVNWCDb db, File path) throws SVNException {
        SVNWCDb.DirParsedInfo dirInfo = db.obtainWcRoot(path);
        SVNSqlJetDb sdb = dirInfo.wcDbDir.getWCRoot().getSDb();
        long wcId = dirInfo.wcDbDir.getWCRoot().getWcId();
        File localRelPath = dirInfo.localRelPath;
        ArrayList<File> result = new ArrayList<File>();
        SVNSqlJetStatement stmt = sdb.getStatement(SVNWCDbStatements.SELECT_ALL_SERVER_EXCLUDED_NODES);
        try {
            stmt.bindf("isi", wcId, localRelPath, 0);
            while (stmt.next()) {
                File localPath = SvnWcDbStatementUtil.getColumnPath(stmt, SVNWCDbSchema.NODES__Fields.local_relpath);
                File absPath = dirInfo.wcDbDir.getWCRoot().getAbsPath(localPath);
                result.add(absPath);
            }
        }
        finally {
            SvnWcDbStatementUtil.reset(stmt);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<File> getNotPresentDescendants(SVNWCDb db, File parentPath) throws SVNException {
        SVNWCDb.DirParsedInfo dirInfo = db.obtainWcRoot(parentPath);
        SVNSqlJetDb sdb = dirInfo.wcDbDir.getWCRoot().getSDb();
        long wcId = dirInfo.wcDbDir.getWCRoot().getWcId();
        File localRelPath = dirInfo.localRelPath;
        ArrayList<File> result = new ArrayList<File>();
        SVNSqlJetStatement stmt = sdb.getStatement(SVNWCDbStatements.SELECT_NOT_PRESENT_DESCENDANTS);
        try {
            stmt.bindf("isi", wcId, localRelPath, SVNWCUtils.relpathDepth(localRelPath));
            while (stmt.next()) {
                result.add(new File(SVNWCUtils.getPathAsChild(localRelPath, SvnWcDbStatementUtil.getColumnPath(stmt, SVNWCDbSchema.NODES__Fields.local_relpath))));
            }
        }
        finally {
            SvnWcDbStatementUtil.reset(stmt);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Structure<ReplaceInfo> readNodeReplaceInfo(SVNWCDb db, File localAbspath, ReplaceInfo ... fields) throws SVNException {
        Object result = Structure.obtain(ReplaceInfo.class, fields);
        ((Structure)result).set((ReplaceInfo)ReplaceInfo.replaced, false);
        if (((Structure)result).hasField(ReplaceInfo.baseReplace)) {
            ((Structure)result).set((ReplaceInfo)ReplaceInfo.baseReplace, false);
        }
        if (((Structure)result).hasField(ReplaceInfo.replaceRoot)) {
            ((Structure)result).set((ReplaceInfo)ReplaceInfo.replaceRoot, false);
        }
        SVNWCDb.DirParsedInfo dirInfo = db.obtainWcRoot(localAbspath);
        SVNSqlJetDb sdb = dirInfo.wcDbDir.getWCRoot().getSDb();
        long wcId = dirInfo.wcDbDir.getWCRoot().getWcId();
        File localRelPath = dirInfo.localRelPath;
        SVNSqlJetStatement stmt = null;
        SvnWcDbReader.begingReadTransaction(dirInfo.wcDbDir.getWCRoot());
        try {
            boolean haveRow2;
            stmt = sdb.getStatement(SVNWCDbStatements.SELECT_NODE_INFO);
            stmt.bindf("is", wcId, localRelPath);
            if (!stmt.next()) {
                SvnWcDbReader.nodeNotFound(localAbspath);
            }
            if (SvnWcDbStatementUtil.getColumnPresence(stmt) != ISVNWCDb.SVNWCDbStatus.Normal) {
                Object x = result;
                return x;
            }
            if (!stmt.next()) {
                Object x = result;
                return x;
            }
            ISVNWCDb.SVNWCDbStatus replacedStatus = SvnWcDbStatementUtil.getColumnPresence(stmt);
            if (replacedStatus != ISVNWCDb.SVNWCDbStatus.NotPresent && replacedStatus != ISVNWCDb.SVNWCDbStatus.Excluded && replacedStatus != ISVNWCDb.SVNWCDbStatus.ServerExcluded && replacedStatus != ISVNWCDb.SVNWCDbStatus.BaseDeleted) {
                ((Structure)result).set((ReplaceInfo)ReplaceInfo.replaced, true);
            }
            long replacedOpDepth = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.op_depth);
            if (((Structure)result).hasField(ReplaceInfo.baseReplace)) {
                long opDepth = replacedOpDepth;
                haveRow2 = true;
                while (opDepth != 0L && haveRow2) {
                    haveRow2 = stmt.next();
                    if (!haveRow2) continue;
                    opDepth = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.op_depth);
                }
                if (haveRow2 && opDepth == 0L) {
                    ISVNWCDb.SVNWCDbStatus baseStatus = SvnWcDbStatementUtil.getColumnPresence(stmt);
                    ((Structure)result).set((ReplaceInfo)ReplaceInfo.baseReplace, baseStatus != ISVNWCDb.SVNWCDbStatus.NotPresent);
                }
            }
            SvnWcDbStatementUtil.reset(stmt);
            if (!((Structure)result).is((ReplaceInfo)ReplaceInfo.replaced) || !((Structure)result).hasField(ReplaceInfo.replaceRoot)) {
                Object opDepth = result;
                return opDepth;
            }
            if (replacedStatus != ISVNWCDb.SVNWCDbStatus.BaseDeleted) {
                stmt.bindf("is", wcId, SVNFileUtil.getFileDir(localRelPath));
                if (stmt.next()) {
                    long parentOpDepth = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.op_depth);
                    if (parentOpDepth >= replacedOpDepth) {
                        ((Structure)result).set((ReplaceInfo)ReplaceInfo.replaceRoot, parentOpDepth == replacedOpDepth);
                        Object haveRow2 = result;
                        return haveRow2;
                    }
                    haveRow2 = stmt.next();
                    if (haveRow2) {
                        parentOpDepth = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.op_depth);
                    }
                    if (!haveRow2) {
                        ((Structure)result).set((ReplaceInfo)ReplaceInfo.replaceRoot, true);
                    } else if (parentOpDepth < replacedOpDepth) {
                        ((Structure)result).set((ReplaceInfo)ReplaceInfo.replaceRoot, true);
                    }
                    SvnWcDbStatementUtil.reset(stmt);
                }
            }
        }
        finally {
            SvnWcDbStatementUtil.reset(stmt);
            SvnWcDbReader.commitTransaction(dirInfo.wcDbDir.getWCRoot());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Structure<InstallInfo> readNodeInstallInfo(SVNWCDb db, File localAbspath, InstallInfo ... fields) throws SVNException {
        Object result = Structure.obtain(InstallInfo.class, fields);
        SVNWCDb.DirParsedInfo dirInfo = db.obtainWcRoot(localAbspath);
        SVNSqlJetDb sdb = dirInfo.wcDbDir.getWCRoot().getSDb();
        long wcId = dirInfo.wcDbDir.getWCRoot().getWcId();
        File localRelPath = dirInfo.localRelPath;
        if (((Structure)result).hasField(InstallInfo.wcRootAbsPath)) {
            ((Structure)result).set((InstallInfo)InstallInfo.wcRootAbsPath, dirInfo.wcDbDir.getWCRoot().getAbsPath());
        }
        SvnWcDbReader.begingReadTransaction(dirInfo.wcDbDir.getWCRoot());
        SVNSqlJetStatement stmt = null;
        try {
            stmt = sdb.getStatement(SVNWCDbStatements.SELECT_NODE_INFO);
            stmt.bindf("is", wcId, localRelPath);
            if (!stmt.next()) {
                SvnWcDbReader.nodeIsNotInstallable(localAbspath);
            } else {
                if (((Structure)result).hasField(InstallInfo.changedDate)) {
                    ((Structure)result).set((InstallInfo)InstallInfo.changedDate, SvnWcDbStatementUtil.getColumnDate(stmt, SVNWCDbSchema.NODES__Fields.changed_date));
                }
                if (((Structure)result).hasField(InstallInfo.sha1Checksum)) {
                    ((Structure)result).set((InstallInfo)InstallInfo.sha1Checksum, SvnWcDbStatementUtil.getColumnChecksum(stmt, SVNWCDbSchema.NODES__Fields.checksum));
                }
                if (((Structure)result).hasField(InstallInfo.pristineProps)) {
                    ((Structure)result).set((InstallInfo)InstallInfo.pristineProps, SvnWcDbStatementUtil.getColumnProperties(stmt, SVNWCDbSchema.NODES__Fields.properties));
                }
            }
            SvnWcDbStatementUtil.reset(stmt);
        }
        finally {
            SvnWcDbStatementUtil.reset(stmt);
            SvnWcDbReader.commitTransaction(dirInfo.wcDbDir.getWCRoot());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long[] getMinAndMaxRevisions(SVNWCDb db, File localAbsPath) throws SVNException {
        SVNWCDb.DirParsedInfo dirInfo = db.obtainWcRoot(localAbsPath);
        SVNSqlJetDb sdb = dirInfo.wcDbDir.getWCRoot().getSDb();
        final long wcId = dirInfo.wcDbDir.getWCRoot().getWcId();
        final File localRelpath = dirInfo.localRelPath;
        final long[] revs = new long[]{-1L, -1L, -1L, -1L};
        SVNSqlJetSelectStatement stmt = new SVNSqlJetSelectStatement(sdb, SVNWCDbSchema.NODES){

            protected Object[] getWhere() throws SVNException {
                return new Object[]{wcId};
            }

            protected boolean isFilterPassed() throws SVNException {
                String path = this.getColumnString(SVNWCDbSchema.NODES__Fields.local_relpath);
                if ("".equals(localRelpath.getPath()) || path.equals(localRelpath.getPath()) || path.startsWith(localRelpath.getPath() + "/")) {
                    long depth = this.getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth);
                    if (depth != 0L) {
                        return false;
                    }
                    String presence = this.getColumnString(SVNWCDbSchema.NODES__Fields.presence);
                    if (!"normal".equals(presence) && !"incomplete".equals(presence)) {
                        return false;
                    }
                    long rev = this.getColumnLong(SVNWCDbSchema.NODES__Fields.revision);
                    long changedRev = this.getColumnLong(SVNWCDbSchema.NODES__Fields.revision);
                    if (this.getColumnBoolean(SVNWCDbSchema.NODES__Fields.file_external)) {
                        return false;
                    }
                    if (revs[0] < 0L || revs[0] > rev) {
                        revs[0] = rev;
                    }
                    if (revs[1] < 0L || revs[1] < rev) {
                        revs[1] = rev;
                    }
                    if (revs[2] < 0L || revs[2] > changedRev) {
                        revs[2] = changedRev;
                    }
                    if (revs[3] < 0L || revs[3] < changedRev) {
                        revs[3] = changedRev;
                    }
                }
                return false;
            }
        };
        try {
            while (stmt.next()) {
            }
        }
        finally {
            SvnWcDbStatementUtil.reset(stmt);
        }
        return revs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Structure<StructureFields.WalkerChildInfo>> readWalkerChildrenInfo(SVNWCDb db, File localAbspath, Map<String, Structure<StructureFields.WalkerChildInfo>> children) throws SVNException {
        SVNWCDb.DirParsedInfo dirInfo = db.obtainWcRoot(localAbspath);
        SVNSqlJetDb sdb = dirInfo.wcDbDir.getWCRoot().getSDb();
        long wcId = dirInfo.wcDbDir.getWCRoot().getWcId();
        SVNSqlJetStatement stmt = sdb.getStatement(SVNWCDbStatements.SELECT_NODE_CHILDREN_WALKER_INFO);
        if (children == null) {
            children = new HashMap<String, Structure<StructureFields.WalkerChildInfo>>();
        }
        try {
            stmt.bindf("is", wcId, dirInfo.localRelPath);
            while (stmt.next()) {
                long opDepth;
                File childPath = SVNFileUtil.createFilePath(SvnWcDbStatementUtil.getColumnText(stmt, SVNWCDbSchema.NODES__Fields.local_relpath));
                String childName = SVNFileUtil.getFileName(childPath);
                Structure<StructureFields.WalkerChildInfo> childInfo = children.get(childName);
                if (childInfo == null) {
                    childInfo = Structure.obtain(StructureFields.WalkerChildInfo.class);
                    children.put(childName, childInfo);
                }
                if ((opDepth = SvnWcDbStatementUtil.getColumnInt64(stmt, SVNWCDbSchema.NODES__Fields.op_depth)) > 0L) {
                    childInfo.set(StructureFields.WalkerChildInfo.status, (Object)SVNWCDb.getWorkingStatus(SvnWcDbStatementUtil.getColumnPresence(stmt)));
                } else {
                    childInfo.set(StructureFields.WalkerChildInfo.status, (Object)SvnWcDbStatementUtil.getColumnPresence(stmt));
                }
                childInfo.set(StructureFields.WalkerChildInfo.kind, (Object)SvnWcDbStatementUtil.getColumnKind(stmt, SVNWCDbSchema.NODES__Fields.kind));
            }
        }
        finally {
            SvnWcDbStatementUtil.reset(stmt);
        }
        return children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasSwitchedSubtrees(SVNWCDb db, File localAbspath) throws SVNException {
        SVNErrorMessage err;
        SVNWCDb.DirParsedInfo dirInfo = db.obtainWcRoot(localAbspath);
        SVNSqlJetDb sdb = dirInfo.wcDbDir.getWCRoot().getSDb();
        long wcId = dirInfo.wcDbDir.getWCRoot().getWcId();
        String localRelPathStr = dirInfo.localRelPath.getPath().replace(File.separatorChar, '/');
        SqlJetDb sqljetDb = sdb.getDb();
        String parentReposRelpath = "";
        ISqlJetCursor cursor = null;
        try {
            sqljetDb.beginTransaction(SqlJetTransactionMode.READ_ONLY);
            ISqlJetTable nodesTable = sqljetDb.getTable(SVNWCDbSchema.NODES.toString());
            String parentRelPath = null;
            HashMap<String, String> parents = new HashMap<String, String>();
            cursor = nodesTable.scope(null, new Object[]{wcId, localRelPathStr}, null);
            if ("".equals(localRelPathStr)) {
                if (!cursor.eof()) {
                    parentReposRelpath = cursor.getString(SVNWCDbSchema.NODES__Fields.repos_path.toString());
                    parents.put("", parentReposRelpath);
                    cursor.next();
                }
            } else if (!"".equals(localRelPathStr)) {
                parentRelPath = localRelPathStr;
            }
            boolean matched = false;
            while (!cursor.eof()) {
                String rowRelPath = cursor.getString(SVNWCDbSchema.NODES__Fields.local_relpath.toString());
                boolean fileExternal = cursor.getBoolean(SVNWCDbSchema.NODES__Fields.file_external.toString());
                if (!fileExternal) {
                    long opDepth;
                    if (rowRelPath.equals(parentRelPath)) {
                        opDepth = cursor.getInteger(SVNWCDbSchema.NODES__Fields.op_depth.toString());
                        if (opDepth == 0L) {
                            parents.put(rowRelPath, cursor.getString(SVNWCDbSchema.NODES__Fields.repos_path.toString()));
                        }
                    } else if ("".equals(localRelPathStr) || rowRelPath.startsWith(localRelPathStr + "/")) {
                        matched = true;
                        opDepth = cursor.getInteger(SVNWCDbSchema.NODES__Fields.op_depth.toString());
                        if (opDepth == 0L) {
                            String expectedReposRelpath;
                            String rowReposRelpath = cursor.getString(SVNWCDbSchema.NODES__Fields.repos_path.toString());
                            String rowParentRelpath = cursor.getString(SVNWCDbSchema.NODES__Fields.parent_relpath.toString());
                            if ("dir".equals(cursor.getString(SVNWCDbSchema.NODES__Fields.kind.toString()))) {
                                parents.put(rowRelPath, rowReposRelpath);
                            }
                            if (!rowReposRelpath.equals(expectedReposRelpath = SVNPathUtil.append(parentReposRelpath = (String)parents.get(rowParentRelpath), SVNPathUtil.tail(rowRelPath)))) {
                                boolean bl = true;
                                return bl;
                            }
                        }
                    } else if (matched) {
                        matched = false;
                        break;
                    }
                }
                cursor.next();
            }
        }
        catch (SqlJetException e) {
            err = SVNErrorMessage.create(SVNErrorCode.SQLITE_ERROR, e);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (SqlJetException e) {
                    err = SVNErrorMessage.create(SVNErrorCode.SQLITE_ERROR, e);
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
            }
            try {
                sqljetDb.commit();
            }
            catch (SqlJetException e) {
                err = SVNErrorMessage.create(SVNErrorCode.SQLITE_ERROR, e);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasLocalModifications(SVNWCContext context, File localAbspath) throws SVNException {
        SVNErrorMessage err;
        SVNWCDb db = (SVNWCDb)context.getDb();
        SVNWCDb.DirParsedInfo dirInfo = db.obtainWcRoot(localAbspath);
        SVNSqlJetDb sdb = dirInfo.wcDbDir.getWCRoot().getSDb();
        long wcId = dirInfo.wcDbDir.getWCRoot().getWcId();
        String localRelPathStr = dirInfo.localRelPath.getPath().replace(File.separatorChar, '/');
        SqlJetDb sqljetDb = sdb.getDb();
        ISqlJetCursor cursor = null;
        boolean matched = false;
        try {
            sqljetDb.beginTransaction(SqlJetTransactionMode.READ_ONLY);
            ISqlJetTable nodesTable = sqljetDb.getTable(SVNWCDbSchema.NODES.toString());
            cursor = nodesTable.scope(null, new Object[]{wcId, localRelPathStr}, null);
            while (!cursor.eof()) {
                String rowRelPath = cursor.getString(SVNWCDbSchema.NODES__Fields.local_relpath.toString());
                if ("".equals(localRelPathStr) || rowRelPath.equals(localRelPathStr) || rowRelPath.startsWith(localRelPathStr + "/")) {
                    matched = true;
                    long opDepth = cursor.getInteger(SVNWCDbSchema.NODES__Fields.op_depth.toString());
                    if (opDepth > 0L) {
                        boolean bl = true;
                        return bl;
                    }
                } else if (matched) {
                    matched = false;
                    break;
                }
                cursor.next();
            }
            cursor.close();
            ISqlJetTable actualNodesTable = sqljetDb.getTable(SVNWCDbSchema.ACTUAL_NODE.toString());
            cursor = actualNodesTable.scope(null, new Object[]{wcId, localRelPathStr}, null);
            while (!cursor.eof()) {
                String rowRelPath = cursor.getString(SVNWCDbSchema.NODES__Fields.local_relpath.toString());
                if ("".equals(localRelPathStr) || rowRelPath.equals(localRelPathStr) || rowRelPath.startsWith(localRelPathStr + "/")) {
                    matched = true;
                    if (cursor.getBlobAsArray(SVNWCDbSchema.ACTUAL_NODE__Fields.properties.toString()) != null) {
                        boolean bl = true;
                        return bl;
                    }
                } else if (matched) {
                    matched = false;
                    break;
                }
                cursor.next();
            }
            cursor.close();
            cursor = nodesTable.scope(null, new Object[]{wcId, localRelPathStr}, null);
            while (!cursor.eof()) {
                String rowRelPath = cursor.getString(SVNWCDbSchema.NODES__Fields.local_relpath.toString());
                if ("".equals(localRelPathStr) || rowRelPath.equals(localRelPathStr) || rowRelPath.startsWith(localRelPathStr + "/")) {
                    String presence;
                    matched = true;
                    String kind = cursor.getString(SVNWCDbSchema.NODES__Fields.kind.toString());
                    if ("file".equals(kind) && "normal".equals(presence = cursor.getString(SVNWCDbSchema.NODES__Fields.presence.toString())) && !cursor.getBoolean(SVNWCDbSchema.NODES__Fields.file_external.toString())) {
                        File localFile = dirInfo.wcDbDir.getWCRoot().getAbsPath(new File(rowRelPath));
                        SVNFileType ft = SVNFileType.getType(localFile);
                        if (ft != SVNFileType.FILE && ft != SVNFileType.SYMLINK) {
                            boolean bl = true;
                            return bl;
                        }
                        long size = cursor.getInteger(SVNWCDbSchema.NODES__Fields.translated_size.toString());
                        long date = cursor.getInteger(SVNWCDbSchema.NODES__Fields.last_mod_time.toString());
                        if (size != -1L && date != 0L) {
                            if (size != SVNFileUtil.getFileLength(localFile)) {
                                boolean bl = true;
                                return bl;
                            }
                            if (date / 1000L == SVNFileUtil.getFileLastModified(localFile)) {
                                cursor.next();
                                continue;
                            }
                        }
                        if (context.isTextModified(localFile, false)) {
                            boolean bl = true;
                            return bl;
                        }
                    }
                } else if (matched) {
                    matched = false;
                    break;
                }
                cursor.next();
            }
            cursor.close();
        }
        catch (SqlJetException e) {
            err = SVNErrorMessage.create(SVNErrorCode.SQLITE_ERROR, e);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (SqlJetException e) {
                    err = SVNErrorMessage.create(SVNErrorCode.SQLITE_ERROR, e);
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
            }
            try {
                sqljetDb.commit();
            }
            catch (SqlJetException e) {
                err = SVNErrorMessage.create(SVNErrorCode.SQLITE_ERROR, e);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isSparseCheckout(SVNWCDb db, File localAbspath) throws SVNException {
        SVNErrorMessage err;
        ISqlJetCursor cursor;
        SqlJetDb sqljetDb;
        block36: {
            SVNWCDb.DirParsedInfo dirInfo = db.obtainWcRoot(localAbspath);
            SVNSqlJetDb sdb = dirInfo.wcDbDir.getWCRoot().getSDb();
            long wcId = dirInfo.wcDbDir.getWCRoot().getWcId();
            String localRelPathStr = dirInfo.localRelPath.getPath().replace(File.separatorChar, '/');
            sqljetDb = sdb.getDb();
            cursor = null;
            try {
                sqljetDb.beginTransaction(SqlJetTransactionMode.READ_ONLY);
                ISqlJetTable nodesTable = sqljetDb.getTable(SVNWCDbSchema.NODES.toString());
                cursor = nodesTable.scope(null, new Object[]{wcId, localRelPathStr}, null);
                boolean matched = false;
                while (!cursor.eof()) {
                    String rowRelPath = cursor.getString(SVNWCDbSchema.NODES__Fields.local_relpath.toString());
                    boolean fileExternal = cursor.getBoolean(SVNWCDbSchema.NODES__Fields.file_external.toString());
                    if (!fileExternal) {
                        if ("".equals(localRelPathStr) || rowRelPath.equals(localRelPathStr) || rowRelPath.startsWith(localRelPathStr + "/")) {
                            matched = true;
                            long opDepth = cursor.getInteger(SVNWCDbSchema.NODES__Fields.op_depth.toString());
                            if (opDepth == 0L) {
                                ISVNWCDb.SVNWCDbStatus presence = SvnWcDbStatementUtil.parsePresence(cursor.getString(SVNWCDbSchema.NODES__Fields.presence.toString()));
                                if (presence == ISVNWCDb.SVNWCDbStatus.Excluded || presence == ISVNWCDb.SVNWCDbStatus.ServerExcluded) {
                                    boolean bl = true;
                                    return bl;
                                }
                                SVNDepth depth = SvnWcDbStatementUtil.parseDepth(cursor.getString(SVNWCDbSchema.NODES__Fields.depth.toString()));
                                if (depth != SVNDepth.UNKNOWN && depth != SVNDepth.INFINITY) {
                                    boolean bl = true;
                                    return bl;
                                }
                            }
                        } else if (matched) {
                            matched = false;
                            break;
                        }
                    }
                    cursor.next();
                }
                if (cursor == null) break block36;
            }
            catch (SqlJetException e) {
                err = SVNErrorMessage.create(SVNErrorCode.SQLITE_ERROR, e);
                SVNErrorManager.error(err, SVNLogType.WC);
                return false;
            }
            try {
                cursor.close();
            }
            catch (SqlJetException e) {
                SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.SQLITE_ERROR, e);
                SVNErrorManager.error(err2, SVNLogType.WC);
            }
        }
        try {
            sqljetDb.commit();
            return false;
        }
        catch (SqlJetException e) {
            SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.SQLITE_ERROR, e);
            SVNErrorManager.error(err3, SVNLogType.WC);
            return false;
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (SqlJetException e) {
                    err = SVNErrorMessage.create(SVNErrorCode.SQLITE_ERROR, e);
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
            }
            try {
                sqljetDb.commit();
            }
            catch (SqlJetException e) {
                err = SVNErrorMessage.create(SVNErrorCode.SQLITE_ERROR, e);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InstallInfo {
        wcRootAbsPath,
        sha1Checksum,
        pristineProps,
        changedDate;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReplaceInfo {
        replaced,
        baseReplace,
        replaceRoot;

    }
}

