/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import de.regnis.q.sequence.line.QSequenceLineRAByteData;
import de.regnis.q.sequence.line.QSequenceLineRAFileData;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import org.tmatesoft.svn.core.internal.wc.AbstractSVNMerger;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNMergerAction;
import org.tmatesoft.svn.core.internal.wc.FSMergerBySequence;
import org.tmatesoft.svn.core.internal.wc.SVNAdminUtil;
import org.tmatesoft.svn.core.internal.wc.SVNDiffConflictChoiceStyle;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNLog;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.wc.ISVNConflictHandler;
import org.tmatesoft.svn.core.wc.ISVNMerger;
import org.tmatesoft.svn.core.wc.SVNConflictAction;
import org.tmatesoft.svn.core.wc.SVNConflictChoice;
import org.tmatesoft.svn.core.wc.SVNConflictReason;
import org.tmatesoft.svn.core.wc.SVNConflictResult;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNMergeFileSet;
import org.tmatesoft.svn.core.wc.SVNMergeResult;
import org.tmatesoft.svn.core.wc.SVNPropertyConflictDescription;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNTextConflictDescription;
import org.tmatesoft.svn.util.SVNLogType;

public class DefaultSVNMerger
extends AbstractSVNMerger
implements ISVNMerger {
    private static List STATUS_ORDERING = new LinkedList();
    private ISVNConflictHandler myConflictCallback;
    private SVNDiffConflictChoiceStyle myDiffConflictStyle;

    public DefaultSVNMerger(byte[] start, byte[] sep, byte[] end) {
        this(start, sep, end, null);
    }

    public DefaultSVNMerger(byte[] start, byte[] sep, byte[] end, ISVNConflictHandler callback) {
        this(start, sep, end, callback, SVNDiffConflictChoiceStyle.CHOOSE_MODIFIED_LATEST);
    }

    public DefaultSVNMerger(byte[] start, byte[] sep, byte[] end, ISVNConflictHandler callback, SVNDiffConflictChoiceStyle style) {
        super(start, sep, end);
        this.myConflictCallback = callback;
        this.myDiffConflictStyle = style;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SVNMergeResult mergeProperties(String localPath, SVNProperties workingProperties, SVNProperties baseProperties, SVNProperties serverBaseProps, SVNProperties propDiff, SVNAdminArea adminArea, SVNLog log, boolean baseMerge, boolean dryRun) throws SVNException {
        SVNProperties sVNProperties = propDiff = propDiff == null ? new SVNProperties() : propDiff;
        if (baseProperties == null) {
            baseProperties = adminArea.getBaseProperties(localPath).asMap();
        }
        if (workingProperties == null) {
            workingProperties = adminArea.getProperties(localPath).asMap();
        }
        if (serverBaseProps == null) {
            serverBaseProps = baseProperties != null ? new SVNProperties(baseProperties) : new SVNProperties();
        }
        boolean isDir = adminArea.getThisDirName().equals(localPath);
        LinkedList conflicts = new LinkedList();
        LinkedList conflict = new LinkedList();
        SVNStatusType status = SVNStatusType.UNCHANGED;
        for (String propName : propDiff.nameSet()) {
            SVNPropertyValue toValue = propDiff.getSVNPropertyValue(propName);
            SVNPropertyValue fromValue = serverBaseProps.getSVNPropertyValue(propName);
            SVNPropertyValue workingValue = workingProperties.getSVNPropertyValue(propName);
            SVNPropertyValue baseValue = baseProperties.getSVNPropertyValue(propName);
            boolean isNormal = SVNProperty.isRegularProperty(propName);
            if (baseMerge) {
                this.changeProperty(baseProperties, propName, toValue);
            }
            if (isNormal) {
                status = DefaultSVNMerger.getPropMergeStatus(status, SVNStatusType.CHANGED);
            }
            SVNStatusType newStatus = null;
            newStatus = fromValue == null ? this.applySinglePropertyAdd(localPath, isDir, isNormal ? status : null, workingProperties, propName, baseValue, toValue, workingValue, adminArea, log, conflict, dryRun) : (toValue == null ? this.applySinglePropertyDelete(localPath, isDir, isNormal ? status : null, workingProperties, propName, baseValue, fromValue, workingValue, adminArea, log, conflict, dryRun) : this.applySinglePropertyChange(localPath, isDir, status, workingProperties, propName, baseValue, fromValue, toValue, workingValue, adminArea, log, conflict, dryRun));
            if (isNormal) {
                status = newStatus;
            }
            if (conflict.isEmpty()) continue;
            if (isNormal) {
                status = DefaultSVNMerger.getPropMergeStatus(status, SVNStatusType.CONFLICTED);
            }
            Object conflictDescription = conflict.remove(0);
            if (dryRun) continue;
            conflicts.add(conflictDescription);
        }
        if (dryRun) {
            return SVNMergeResult.createMergeResult(status, null);
        }
        log = log == null ? adminArea.getLog() : log;
        adminArea.installProperties(localPath, baseProperties, workingProperties, log, baseMerge, true);
        if (!conflicts.isEmpty()) {
            String prejPath;
            String prejTmpPath;
            block16: {
                SVNEntry entry = adminArea.getVersionedEntry(localPath, false);
                prejTmpPath = adminArea.getThisDirName().equals(localPath) ? "tmp/dir_conflicts" : "tmp/props/" + localPath;
                File prejTmpFile = SVNFileUtil.createUniqueFile(adminArea.getAdminDirectory(), prejTmpPath, ".prej", false);
                prejTmpPath = SVNFileUtil.getBasePath(prejTmpFile);
                prejPath = entry.getPropRejectFile();
                if (prejPath == null) {
                    prejPath = adminArea.getThisDirName().equals(localPath) ? "dir_conflicts" : localPath;
                    File prejFile = SVNFileUtil.createUniqueFile(adminArea.getRoot(), prejPath, ".prej", false);
                    prejPath = SVNFileUtil.getBasePath(prejFile);
                }
                File file = adminArea.getFile(prejTmpPath);
                OutputStream os = SVNFileUtil.openFileForWriting(file);
                try {
                    try {
                        for (String line : conflicts) {
                            os.write(SVNEncodingUtil.fuzzyEscape(line).getBytes("UTF-8"));
                        }
                        os.write(SVNEncodingUtil.fuzzyEscape("\n").getBytes("UTF-8"));
                    }
                    catch (IOException e) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot write properties conflict file: {1}", (Object)e.getLocalizedMessage());
                        SVNErrorManager.error(err, e, SVNLogType.WC);
                        Object var24_26 = null;
                        SVNFileUtil.closeFile(os);
                        break block16;
                    }
                    Object var24_25 = null;
                }
                catch (Throwable throwable) {
                    Object var24_27 = null;
                    SVNFileUtil.closeFile(os);
                    throw throwable;
                }
                SVNFileUtil.closeFile(os);
            }
            SVNProperties command = new SVNProperties();
            command.put("name", prejTmpPath);
            command.put("dest", prejPath);
            log.addCommand("append", command, false);
            command.clear();
            command.put("name", prejTmpPath);
            log.addCommand("rm", command, false);
            command.clear();
            command.put("name", localPath);
            command.put(SVNProperty.shortPropertyName("svn:entry:prop-reject-file"), prejPath);
            log.addCommand("modify-entry", command, false);
        }
        return SVNMergeResult.createMergeResult(status, null);
    }

    public SVNDiffConflictChoiceStyle getDiffConflictStyle() {
        return this.myDiffConflictStyle;
    }

    public void setDiffConflictStyle(SVNDiffConflictChoiceStyle diffConflictStyle) {
        this.myDiffConflictStyle = diffConflictStyle;
    }

    protected SVNStatusType mergeBinary(File baseFile, File localFile, File repositoryFile, SVNDiffOptions options, File resultFile) throws SVNException {
        return SVNStatusType.CONFLICTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SVNStatusType mergeText(File baseFile, File localFile, File latestFile, SVNDiffOptions options, File resultFile) throws SVNException {
        int mergeResult;
        block5: {
            FSMergerBySequence merger = new FSMergerBySequence(this.getConflictStartMarker(), this.getConflictSeparatorMarker(), this.getConflictEndMarker());
            mergeResult = 0;
            RandomAccessFile localIS = null;
            RandomAccessFile latestIS = null;
            RandomAccessFile baseIS = null;
            OutputStream result = null;
            try {
                try {
                    result = SVNFileUtil.openFileForWriting(resultFile);
                    localIS = new RandomAccessFile(localFile, "r");
                    latestIS = new RandomAccessFile(latestFile, "r");
                    baseIS = new RandomAccessFile(baseFile, "r");
                    QSequenceLineRAFileData baseData = new QSequenceLineRAFileData(baseIS);
                    QSequenceLineRAFileData localData = new QSequenceLineRAFileData(localIS);
                    QSequenceLineRAFileData latestData = new QSequenceLineRAFileData(latestIS);
                    mergeResult = merger.merge(baseData, localData, latestData, options, result, this.getDiffConflictStyle());
                }
                catch (IOException e) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
                    SVNErrorManager.error(err, e, SVNLogType.WC);
                    Object var16_18 = null;
                    SVNFileUtil.closeFile(result);
                    SVNFileUtil.closeFile(localIS);
                    SVNFileUtil.closeFile(baseIS);
                    SVNFileUtil.closeFile(latestIS);
                    break block5;
                }
                Object var16_17 = null;
            }
            catch (Throwable throwable) {
                Object var16_19 = null;
                SVNFileUtil.closeFile(result);
                SVNFileUtil.closeFile(localIS);
                SVNFileUtil.closeFile(baseIS);
                SVNFileUtil.closeFile(latestIS);
                throw throwable;
            }
            SVNFileUtil.closeFile(result);
            SVNFileUtil.closeFile(localIS);
            SVNFileUtil.closeFile(baseIS);
            SVNFileUtil.closeFile(latestIS);
        }
        SVNStatusType status = SVNStatusType.UNCHANGED;
        if (mergeResult == 2) {
            return SVNStatusType.CONFLICTED;
        }
        if (mergeResult != 4) return status;
        return SVNStatusType.MERGED;
    }

    protected SVNMergeResult processMergedFiles(SVNMergeFileSet files, SVNMergeResult mergeResult) throws SVNException {
        DefaultSVNMergerAction mergeAction = this.getMergeAction(files, mergeResult);
        if (mergeAction == DefaultSVNMergerAction.MARK_CONFLICTED) {
            mergeResult = this.handleMarkConflicted(files);
        } else if (mergeAction == DefaultSVNMergerAction.CHOOSE_BASE) {
            mergeResult = this.handleChooseBase(files);
        } else if (mergeAction == DefaultSVNMergerAction.CHOOSE_REPOSITORY) {
            mergeResult = this.handleChooseRepository(files);
        } else if (mergeAction == DefaultSVNMergerAction.CHOOSE_WORKING) {
            mergeResult = this.handleChooseWorking(files);
        } else if (mergeAction == DefaultSVNMergerAction.CHOOSE_MERGED_FILE) {
            mergeResult = this.handleChooseMerged(files, mergeResult);
        } else if (mergeAction == DefaultSVNMergerAction.MARK_RESOLVED) {
            mergeResult = this.handleMarkResolved(files, mergeResult);
        } else if (mergeAction == DefaultSVNMergerAction.CHOOSE_REPOSITORY_CONFLICTED) {
            mergeResult = this.handleChooseConflicted(false, files);
        } else if (mergeAction == DefaultSVNMergerAction.CHOOSE_WORKING_CONFLICTED) {
            mergeResult = this.handleChooseConflicted(true, files);
        }
        this.postMergeCleanup(files);
        return mergeResult;
    }

    protected DefaultSVNMergerAction getMergeAction(SVNMergeFileSet files, SVNMergeResult mergeResult) throws SVNException {
        if (mergeResult.getMergeStatus() == SVNStatusType.CONFLICTED) {
            if (this.myConflictCallback != null) {
                SVNConflictChoice choice;
                SVNTextConflictDescription descr = new SVNTextConflictDescription(files, SVNNodeKind.FILE, SVNConflictAction.EDIT, SVNConflictReason.EDITED);
                SVNConflictResult result = this.myConflictCallback.handleConflict(descr);
                if (result == null) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CONFLICT_RESOLVER_FAILURE, "Conflict callback violated API: returned no results.");
                    SVNErrorManager.error(err, SVNLogType.DEFAULT);
                }
                if (result.isIsSaveMerged()) {
                    File mergedFile = result.getMergedFile() != null ? result.getMergedFile() : files.getResultFile();
                    File mergeTarget = files.getWCFile();
                    File editedMergedFile = SVNFileUtil.createUniqueFile(mergeTarget.getParentFile(), mergeTarget.getName(), ".edited", false);
                    SVNLog log = files.getLog();
                    SVNProperties command = new SVNProperties();
                    command.put("name", SVNFileUtil.getBasePath(mergedFile));
                    command.put("dest", editedMergedFile.getName());
                    log.addCommand("cp-and-translate", command, false);
                    command.clear();
                }
                if ((choice = result.getConflictChoice()) == SVNConflictChoice.BASE) {
                    return DefaultSVNMergerAction.CHOOSE_BASE;
                }
                if (choice == SVNConflictChoice.MERGED) {
                    return DefaultSVNMergerAction.CHOOSE_MERGED_FILE;
                }
                if (choice == SVNConflictChoice.MINE_FULL) {
                    return DefaultSVNMergerAction.CHOOSE_WORKING;
                }
                if (choice == SVNConflictChoice.THEIRS_FULL) {
                    return DefaultSVNMergerAction.CHOOSE_REPOSITORY;
                }
                if (choice == SVNConflictChoice.MINE_CONFLICT) {
                    return DefaultSVNMergerAction.CHOOSE_WORKING_CONFLICTED;
                }
                if (choice == SVNConflictChoice.THEIRS_CONFLICT) {
                    return DefaultSVNMergerAction.CHOOSE_REPOSITORY_CONFLICTED;
                }
            }
            return DefaultSVNMergerAction.MARK_CONFLICTED;
        }
        return DefaultSVNMergerAction.CHOOSE_MERGED_FILE;
    }

    protected SVNMergeResult handleChooseBase(SVNMergeFileSet files) throws SVNException {
        SVNLog log = files.getLog();
        if (log != null) {
            SVNProperties command = new SVNProperties();
            command.put("name", files.getBasePath());
            command.put("dest", files.getWCPath());
            log.addCommand("cp-and-translate", command, false);
            command.clear();
        }
        return SVNMergeResult.createMergeResult(SVNStatusType.MERGED, null);
    }

    protected SVNMergeResult handleChooseRepository(SVNMergeFileSet files) throws SVNException {
        SVNLog log = files.getLog();
        if (log != null) {
            SVNProperties command = new SVNProperties();
            command.put("name", files.getRepositoryPath());
            command.put("dest", files.getWCPath());
            log.addCommand("cp-and-translate", command, false);
            command.clear();
        }
        return SVNMergeResult.createMergeResult(SVNStatusType.MERGED, null);
    }

    protected SVNMergeResult handleChooseConflicted(boolean chooseMine, SVNMergeFileSet files) throws SVNException {
        File tmpFile = SVNAdminUtil.createTmpFile(files.getAdminArea());
        this.setDiffConflictStyle(chooseMine ? SVNDiffConflictChoiceStyle.CHOOSE_MODIFIED : SVNDiffConflictChoiceStyle.CHOOSE_LATEST);
        File leftFile = files.getBaseFile();
        File rightFile = files.getRepositoryFile();
        File detranslatedTarget = files.getLocalFile();
        this.mergeText(leftFile, detranslatedTarget, rightFile, this.getDiffOptions(), tmpFile);
        SVNLog log = files.getLog();
        if (log != null) {
            SVNProperties command = new SVNProperties();
            String tmpBasePath = SVNFileUtil.getBasePath(tmpFile);
            command.put("name", tmpBasePath);
            command.put("dest", files.getWCPath());
            log.addCommand("cp-and-translate", command, false);
            command.clear();
            command.put("name", tmpBasePath);
            log.addCommand("rm", command, false);
            command.clear();
        }
        return SVNMergeResult.createMergeResult(SVNStatusType.MERGED, null);
    }

    protected SVNMergeResult handleChooseWorking(SVNMergeFileSet files) throws SVNException {
        if (files == null) {
            SVNErrorManager.cancel("", SVNLogType.WC);
        }
        return SVNMergeResult.createMergeResult(SVNStatusType.MERGED, null);
    }

    protected SVNMergeResult handleMarkConflicted(SVNMergeFileSet files) throws SVNException {
        if (files.isBinary()) {
            return this.handleMarkBinaryConflicted(files);
        }
        return this.handleMarkTextConflicted(files);
    }

    protected SVNMergeResult handleMarkBinaryConflicted(SVNMergeFileSet files) throws SVNException {
        SVNProperties command = new SVNProperties();
        File root = files.getAdminArea().getRoot();
        SVNLog log = files.getLog();
        File oldFile = SVNFileUtil.createUniqueFile(root, files.getWCPath(), files.getBaseLabel(), false);
        File newFile = SVNFileUtil.createUniqueFile(root, files.getWCPath(), files.getRepositoryLabel(), false);
        SVNFileUtil.copyFile(files.getBaseFile(), oldFile, false);
        SVNFileUtil.copyFile(files.getRepositoryFile(), newFile, false);
        if (!files.getLocalPath().equals(files.getWCPath())) {
            File mineFile = SVNFileUtil.createUniqueFile(root, files.getWCPath(), files.getLocalLabel(), false);
            String minePath = SVNFileUtil.getBasePath(mineFile);
            if (log != null) {
                command.put("name", files.getLocalPath());
                command.put("dest", minePath);
                log.addCommand("mv", command, false);
                command.clear();
            }
            command.put(SVNProperty.shortPropertyName("svn:entry:conflict-wrk"), minePath);
        } else {
            command.put(SVNProperty.shortPropertyName("svn:entry:conflict-wrk"), "");
        }
        String newPath = SVNFileUtil.getBasePath(newFile);
        String oldPath = SVNFileUtil.getBasePath(oldFile);
        this.makeBinaryConflictEntry(files, newPath, oldPath);
        return SVNMergeResult.createMergeResult(SVNStatusType.CONFLICTED, null);
    }

    protected void makeBinaryConflictEntry(SVNMergeFileSet files, String newFilePath, String oldFilePath) throws SVNException {
        SVNProperties command = new SVNProperties();
        SVNLog log = files.getLog();
        if (log != null) {
            command.put(SVNProperty.shortPropertyName("svn:entry:conflict-new"), newFilePath);
            command.put(SVNProperty.shortPropertyName("svn:entry:conflict-old"), oldFilePath);
            log.logChangedEntryProperties(files.getWCPath(), command);
            command.clear();
        }
        files.getAdminArea().saveEntries(false);
    }

    protected SVNMergeResult handleMarkTextConflicted(SVNMergeFileSet files) throws SVNException {
        SVNProperties command = new SVNProperties();
        File root = files.getAdminArea().getRoot();
        SVNLog log = files.getLog();
        if (files.getCopyFromFile() != null) {
            String copyFromPath = files.getCopyFromPath();
            String detranslatedPath = files.getWCPath();
            if (log != null) {
                command.put("name", copyFromPath);
                command.put("dest", detranslatedPath);
                log.addCommand("cp-and-translate", command, false);
                command.clear();
            }
        }
        File mineFile = SVNFileUtil.createUniqueFile(root, files.getWCPath(), files.getLocalLabel(), false);
        File oldFile = SVNFileUtil.createUniqueFile(root, files.getWCPath(), files.getBaseLabel(), false);
        File newFile = SVNFileUtil.createUniqueFile(root, files.getWCPath(), files.getRepositoryLabel(), false);
        String newPath = SVNFileUtil.getBasePath(newFile);
        String oldPath = SVNFileUtil.getBasePath(oldFile);
        String minePath = SVNFileUtil.getBasePath(mineFile);
        String basePath = files.getBasePath();
        String latestPath = files.getRepositoryPath();
        File tmpTargetCopy = SVNTranslator.getTranslatedFile(files.getAdminArea(), files.getWCPath(), files.getWCFile(), false, false, false, true);
        String tmpTargetCopyPath = SVNFileUtil.getBasePath(tmpTargetCopy);
        if (log != null) {
            command.put("name", basePath);
            command.put("dest", oldPath);
            command.put("arg2", files.getWCPath());
            log.addCommand("cp-and-translate", command, false);
            command.clear();
            command.put("name", latestPath);
            command.put("dest", newPath);
            command.put("arg2", files.getWCPath());
            log.addCommand("cp-and-translate", command, false);
            command.clear();
            command.put("name", tmpTargetCopyPath);
            command.put("dest", minePath);
            command.put("arg2", files.getWCPath());
            log.addCommand("cp-and-translate", command, false);
            command.clear();
            if (!tmpTargetCopy.equals(files.getLocalFile())) {
                command.put("name", tmpTargetCopyPath);
                log.addCommand("rm", command, false);
                command.clear();
            }
            command.put("name", files.getResultPath());
            command.put("dest", files.getWCPath());
            command.put("arg2", files.getWCPath());
            log.addCommand("cp-and-translate", command, false);
            command.clear();
        }
        this.makeTextConflictEntry(files, minePath, newPath, oldPath);
        return SVNMergeResult.createMergeResult(SVNStatusType.CONFLICTED, null);
    }

    protected void makeTextConflictEntry(SVNMergeFileSet files, String mineFilePath, String newFilePath, String oldFilePath) throws SVNException {
        SVNLog log = files.getLog();
        if (log != null) {
            SVNProperties command = new SVNProperties();
            command.put(SVNProperty.shortPropertyName("svn:entry:conflict-wrk"), mineFilePath);
            command.put(SVNProperty.shortPropertyName("svn:entry:conflict-new"), newFilePath);
            command.put(SVNProperty.shortPropertyName("svn:entry:conflict-old"), oldFilePath);
            log.logChangedEntryProperties(files.getWCPath(), command);
            command.clear();
        }
    }

    protected SVNMergeResult handleChooseMerged(SVNMergeFileSet files, SVNMergeResult mergeResult) throws SVNException {
        SVNProperties command = new SVNProperties();
        SVNLog log = files.getLog();
        if (mergeResult.getMergeStatus() != SVNStatusType.CONFLICTED) {
            if (mergeResult.getMergeStatus() != SVNStatusType.UNCHANGED && log != null) {
                command.put("name", files.getResultPath());
                command.put("dest", files.getWCPath());
                log.addCommand("cp-and-translate", command, false);
                command.clear();
            }
            return mergeResult;
        }
        if (files.isBinary()) {
            return this.handleMarkConflicted(files);
        }
        if (log != null) {
            command.put("name", files.getResultPath());
            command.put("dest", files.getWCPath());
            log.addCommand("cp-and-translate", command, false);
            command.clear();
        }
        return SVNMergeResult.createMergeResult(SVNStatusType.MERGED, null);
    }

    protected SVNMergeResult handleMarkResolved(SVNMergeFileSet files, SVNMergeResult mergeResult) throws SVNException {
        if (!files.isBinary()) {
            return this.handleChooseMerged(files, mergeResult);
        }
        return this.handleChooseWorking(files);
    }

    protected void postMergeCleanup(SVNMergeFileSet files) throws SVNException {
        SVNProperties command = new SVNProperties();
        SVNLog log = files.getLog();
        if (!files.getLocalPath().equals(files.getWCPath()) && log != null) {
            command.put("name", files.getLocalPath());
            log.addCommand("rm", command, false);
            command.clear();
        }
        if (log != null) {
            command.put("name", files.getWCPath());
            log.addCommand("maybe-executable", command, false);
            command.clear();
            command.put("name", files.getWCPath());
            log.addCommand("maybe-readonly", command, false);
            command.clear();
            command.put("name", files.getResultPath());
            log.addCommand("rm", command, false);
            command.clear();
        }
    }

    private SVNStatusType applySinglePropertyAdd(String localPath, boolean isDir, SVNStatusType status, SVNProperties workingProps, String propName, SVNPropertyValue baseValue, SVNPropertyValue newValue, SVNPropertyValue workingValue, SVNAdminArea adminArea, SVNLog log, Collection conflicts, boolean dryRun) throws SVNException {
        boolean gotConflict = false;
        if (workingValue != null) {
            if (workingValue.equals(newValue)) {
                status = DefaultSVNMerger.getPropMergeStatus(status, SVNStatusType.MERGED);
                this.changeProperty(workingProps, propName, newValue);
            } else if ("svn:mergeinfo".equals(propName)) {
                newValue = SVNPropertyValue.create(SVNMergeInfoUtil.combineMergeInfoProperties(workingValue.getString(), newValue.getString()));
                this.changeProperty(workingProps, propName, newValue);
                status = DefaultSVNMerger.getPropMergeStatus(status, SVNStatusType.MERGED);
            } else {
                gotConflict = this.maybeGeneratePropConflict(localPath, propName, workingProps, null, newValue, baseValue, workingValue, adminArea, log, isDir, dryRun);
                if (gotConflict) {
                    conflicts.add(MessageFormat.format("Trying to add new property ''{0}'' with value ''{1}'',\nbut property already exists with value ''{2}''.", propName, SVNPropertyValue.getPropertyAsString(newValue), SVNPropertyValue.getPropertyAsString(workingValue)));
                }
            }
        } else if (baseValue != null) {
            gotConflict = this.maybeGeneratePropConflict(localPath, propName, workingProps, null, newValue, baseValue, null, adminArea, log, isDir, dryRun);
            if (gotConflict) {
                conflicts.add(MessageFormat.format("Trying to create property ''{0}'' with value ''{1}'',\nbut it has been locally deleted.", propName, SVNPropertyValue.getPropertyAsString(newValue)));
            }
        } else {
            this.changeProperty(workingProps, propName, newValue);
        }
        return status;
    }

    private void changeProperty(SVNProperties properties, String propName, SVNPropertyValue propValue) {
        if (propValue == null) {
            properties.remove(propName);
        } else {
            properties.put(propName, propValue);
        }
    }

    private SVNStatusType applySinglePropertyChange(String localPath, boolean isDir, SVNStatusType status, SVNProperties workingProps, String propName, SVNPropertyValue baseValue, SVNPropertyValue oldValue, SVNPropertyValue newValue, SVNPropertyValue workingValue, SVNAdminArea adminArea, SVNLog log, Collection conflicts, boolean dryRun) throws SVNException {
        if ("svn:mergeinfo".equals(propName)) {
            return this.applySingleMergeInfoPropertyChange(localPath, isDir, status, workingProps, propName, baseValue, oldValue, newValue, workingValue, adminArea, log, conflicts, dryRun);
        }
        return this.applySingleGenericPropertyChange(localPath, isDir, status, workingProps, propName, baseValue, oldValue, newValue, workingValue, adminArea, log, conflicts, dryRun);
    }

    private SVNStatusType applySingleMergeInfoPropertyChange(String localPath, boolean isDir, SVNStatusType status, SVNProperties workingProps, String propName, SVNPropertyValue baseValue, SVNPropertyValue oldValue, SVNPropertyValue newValue, SVNPropertyValue workingValue, SVNAdminArea adminArea, SVNLog log, Collection conflicts, boolean dryRun) throws SVNException {
        boolean gotConflict = false;
        if (workingValue != null && baseValue == null || workingValue == null && baseValue != null || workingValue != null && baseValue != null && !workingValue.equals(baseValue)) {
            if (workingValue != null) {
                if (workingValue.equals(newValue)) {
                    status = DefaultSVNMerger.getPropMergeStatus(status, SVNStatusType.MERGED);
                } else {
                    newValue = SVNPropertyValue.create(SVNMergeInfoUtil.combineForkedMergeInfoProperties(oldValue.getString(), workingValue.getString(), newValue.getString()));
                    this.changeProperty(workingProps, propName, newValue);
                    status = DefaultSVNMerger.getPropMergeStatus(status, SVNStatusType.MERGED);
                }
            } else {
                gotConflict = this.maybeGeneratePropConflict(localPath, propName, workingProps, oldValue, newValue, baseValue, workingValue, adminArea, log, isDir, dryRun);
                if (gotConflict) {
                    conflicts.add(MessageFormat.format("Trying to change property ''{0}'' from ''{1}'' to ''{2}'',\nbut it has been locally deleted.", propName, SVNPropertyValue.getPropertyAsString(oldValue), SVNPropertyValue.getPropertyAsString(newValue)));
                }
            }
        } else if (workingValue == null) {
            TreeMap addedMergeInfo = new TreeMap();
            SVNMergeInfoUtil.diffMergeInfoProperties(null, addedMergeInfo, oldValue.getString(), null, newValue.getString(), null);
            newValue = SVNPropertyValue.create(SVNMergeInfoUtil.formatMergeInfoToString(addedMergeInfo, null));
            this.changeProperty(workingProps, propName, newValue);
        } else if (baseValue.equals(oldValue)) {
            this.changeProperty(workingProps, propName, newValue);
        } else {
            newValue = SVNPropertyValue.create(SVNMergeInfoUtil.combineForkedMergeInfoProperties(oldValue.getString(), workingValue.getString(), newValue.getString()));
            this.changeProperty(workingProps, propName, newValue);
            status = DefaultSVNMerger.getPropMergeStatus(status, SVNStatusType.MERGED);
        }
        return status;
    }

    private SVNStatusType applySingleGenericPropertyChange(String localPath, boolean isDir, SVNStatusType status, SVNProperties workingProps, String propName, SVNPropertyValue baseValue, SVNPropertyValue oldValue, SVNPropertyValue newValue, SVNPropertyValue workingValue, SVNAdminArea adminArea, SVNLog log, Collection conflicts, boolean dryRun) throws SVNException {
        boolean gotConflict = false;
        if (workingValue == null && oldValue == null || workingValue != null && oldValue != null && workingValue.equals(oldValue)) {
            this.changeProperty(workingProps, propName, newValue);
        } else {
            gotConflict = this.maybeGeneratePropConflict(localPath, propName, workingProps, oldValue, newValue, baseValue, workingValue, adminArea, log, isDir, dryRun);
            if (gotConflict) {
                if (workingValue != null && baseValue != null && workingValue.equals(baseValue)) {
                    conflicts.add(MessageFormat.format("Trying to change property ''{0}'' from ''{1}'' to ''{2}'',\nbut property already exists with value ''{3}''.", propName, SVNPropertyValue.getPropertyAsString(oldValue), SVNPropertyValue.getPropertyAsString(newValue), SVNPropertyValue.getPropertyAsString(workingValue)));
                } else if (workingValue != null && baseValue != null) {
                    conflicts.add(MessageFormat.format("Trying to change property ''{0}'' from ''{1}'' to ''{2}'',\nbut the property has been locally changed from ''{3}'' to ''{4}''.", propName, SVNPropertyValue.getPropertyAsString(oldValue), SVNPropertyValue.getPropertyAsString(newValue), SVNPropertyValue.getPropertyAsString(baseValue), SVNPropertyValue.getPropertyAsString(workingValue)));
                } else if (workingValue != null) {
                    conflicts.add(MessageFormat.format("Trying to change property ''{0}'' from ''{1}'' to ''{2}'',\nbut property has been locally added with value ''{3}''.", propName, SVNPropertyValue.getPropertyAsString(oldValue), SVNPropertyValue.getPropertyAsString(newValue), SVNPropertyValue.getPropertyAsString(workingValue)));
                } else if (baseValue != null) {
                    conflicts.add(MessageFormat.format("Trying to change property ''{0}'' from ''{1}'' to ''{2}'',\nbut it has been locally deleted.", propName, SVNPropertyValue.getPropertyAsString(oldValue), SVNPropertyValue.getPropertyAsString(newValue)));
                } else {
                    conflicts.add(MessageFormat.format("Trying to change property ''{0}'' from ''{1}'' to ''{2}'',\nbut the property does not exist.", propName, SVNPropertyValue.getPropertyAsString(oldValue), SVNPropertyValue.getPropertyAsString(newValue)));
                }
            }
        }
        return status;
    }

    private SVNStatusType applySinglePropertyDelete(String localPath, boolean isDir, SVNStatusType status, SVNProperties workingProps, String propName, SVNPropertyValue baseValue, SVNPropertyValue oldValue, SVNPropertyValue workingValue, SVNAdminArea adminArea, SVNLog log, Collection conflicts, boolean dryRun) throws SVNException {
        boolean gotConflict = false;
        if (baseValue == null) {
            this.changeProperty(workingProps, propName, null);
            if (oldValue != null) {
                status = DefaultSVNMerger.getPropMergeStatus(status, SVNStatusType.MERGED);
            }
        } else if (baseValue.equals(oldValue)) {
            if (workingValue != null) {
                if (workingValue.equals(oldValue)) {
                    this.changeProperty(workingProps, propName, null);
                } else {
                    gotConflict = this.maybeGeneratePropConflict(localPath, propName, workingProps, oldValue, null, baseValue, workingValue, adminArea, log, isDir, dryRun);
                    if (gotConflict) {
                        conflicts.add(MessageFormat.format("Trying to delete property ''{0}'' with value ''{1}''\n but it has been modified from ''{2}'' to ''{3}''.", propName, SVNPropertyValue.getPropertyAsString(oldValue), SVNPropertyValue.getPropertyAsString(baseValue), SVNPropertyValue.getPropertyAsString(workingValue)));
                    }
                }
            } else {
                status = DefaultSVNMerger.getPropMergeStatus(status, SVNStatusType.MERGED);
            }
        } else {
            gotConflict = this.maybeGeneratePropConflict(localPath, propName, workingProps, oldValue, null, baseValue, workingValue, adminArea, log, isDir, dryRun);
            if (gotConflict) {
                conflicts.add(MessageFormat.format("Trying to delete property ''{0}'' with value ''{1}''\n but the local value is ''{2}''.", propName, SVNPropertyValue.getPropertyAsString(baseValue), SVNPropertyValue.getPropertyAsString(workingValue)));
            }
        }
        return status;
    }

    private static SVNStatusType getPropMergeStatus(SVNStatusType status, SVNStatusType newStatus) {
        if (status == null) {
            return null;
        }
        int statusInd = STATUS_ORDERING.indexOf(status);
        int newStatusInd = STATUS_ORDERING.indexOf(newStatus);
        if (newStatusInd <= statusInd) {
            return status;
        }
        return newStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean maybeGeneratePropConflict(String localPath, String propName, SVNProperties workingProps, SVNPropertyValue oldValue, SVNPropertyValue newValue, SVNPropertyValue baseValue, SVNPropertyValue workingValue, SVNAdminArea adminArea, SVNLog log, boolean isDir, boolean dryRun) throws SVNException {
        boolean bl;
        boolean conflictRemains = true;
        if (this.myConflictCallback == null) return conflictRemains;
        if (dryRun) {
            return conflictRemains;
        }
        File path = adminArea.getFile(localPath);
        File workingFile = null;
        File newFile = null;
        File baseFile = null;
        File mergedFile = null;
        try {
            SVNConflictChoice choice;
            block48: {
                SVNErrorMessage err;
                OutputStream os;
                SVNPropertyValue theValue;
                block47: {
                    SVNErrorMessage err2;
                    OutputStream os2;
                    block46: {
                        if (workingValue != null) {
                            workingFile = SVNFileUtil.createUniqueFile(path.getParentFile(), path.getName(), ".tmp", false);
                            os2 = SVNFileUtil.openFileForWriting(workingFile);
                            try {
                                Object var22_19;
                                try {
                                    os2.write(SVNPropertyValue.getPropertyAsBytes(workingValue));
                                }
                                catch (IOException e) {
                                    err2 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot write a working property value file: {1}", (Object)e.getLocalizedMessage());
                                    SVNErrorManager.error(err2, e, SVNLogType.WC);
                                    var22_19 = null;
                                    SVNFileUtil.closeFile(os2);
                                    break block46;
                                }
                                var22_19 = null;
                            }
                            catch (Throwable throwable) {
                                Object var22_20 = null;
                                SVNFileUtil.closeFile(os2);
                                throw throwable;
                            }
                            SVNFileUtil.closeFile(os2);
                        }
                    }
                    if (newValue != null) {
                        newFile = SVNFileUtil.createUniqueFile(path.getParentFile(), path.getName(), ".tmp", false);
                        os2 = SVNFileUtil.openFileForWriting(newFile);
                        try {
                            Object var24_30;
                            try {
                                os2.write(SVNPropertyValue.getPropertyAsBytes(newValue));
                            }
                            catch (IOException e) {
                                err2 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot write a new property value file: {1}", (Object)e.getLocalizedMessage());
                                SVNErrorManager.error(err2, e, SVNLogType.WC);
                                var24_30 = null;
                                SVNFileUtil.closeFile(os2);
                                break block47;
                            }
                            var24_30 = null;
                        }
                        catch (Throwable throwable) {
                            Object var24_31 = null;
                            SVNFileUtil.closeFile(os2);
                            throw throwable;
                        }
                        SVNFileUtil.closeFile(os2);
                    }
                }
                if (baseValue != null && oldValue == null || baseValue == null && oldValue != null) {
                    theValue = baseValue != null ? baseValue : oldValue;
                    baseFile = SVNFileUtil.createUniqueFile(path.getParentFile(), path.getName(), ".tmp", false);
                    os = SVNFileUtil.openFileForWriting(baseFile);
                    try {
                        try {
                            os.write(SVNPropertyValue.getPropertyAsBytes(theValue));
                        }
                        catch (IOException e) {
                            err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot write a base property value file: {1}", (Object)e.getLocalizedMessage());
                            SVNErrorManager.error(err, e, SVNLogType.WC);
                            Object var26_35 = null;
                            SVNFileUtil.closeFile(os);
                            break block48;
                        }
                        Object var26_34 = null;
                    }
                    catch (Throwable throwable) {
                        Object var26_36 = null;
                        SVNFileUtil.closeFile(os);
                        throw throwable;
                    }
                    SVNFileUtil.closeFile(os);
                } else if (baseValue != null && oldValue != null) {
                    block49: {
                        theValue = baseValue;
                        if (!baseValue.equals(oldValue) && workingValue != null && baseValue.equals(workingValue)) {
                            theValue = oldValue;
                        }
                        baseFile = SVNFileUtil.createUniqueFile(path.getParentFile(), path.getName(), ".tmp", false);
                        os = SVNFileUtil.openFileForWriting(baseFile);
                        try {
                            try {
                                os.write(SVNPropertyValue.getPropertyAsBytes(theValue));
                            }
                            catch (IOException e) {
                                err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot write a base property value file: {1}", (Object)e.getLocalizedMessage());
                                SVNErrorManager.error(err, e, SVNLogType.WC);
                                Object var28_41 = null;
                                SVNFileUtil.closeFile(os);
                                break block49;
                            }
                            Object var28_40 = null;
                        }
                        catch (Throwable throwable) {
                            Object var28_42 = null;
                            SVNFileUtil.closeFile(os);
                            throw throwable;
                        }
                        SVNFileUtil.closeFile(os);
                    }
                    if (workingValue != null && newValue != null) {
                        FSMergerBySequence merger = new FSMergerBySequence(this.getConflictStartMarker(), this.getConflictSeparatorMarker(), this.getConflictEndMarker());
                        OutputStream result = null;
                        try {
                            try {
                                mergedFile = SVNFileUtil.createUniqueFile(path.getParentFile(), path.getName(), ".tmp", false);
                                result = SVNFileUtil.openFileForWriting(mergedFile);
                                QSequenceLineRAByteData baseData = new QSequenceLineRAByteData(SVNPropertyValue.getPropertyAsBytes(theValue));
                                QSequenceLineRAByteData localData = new QSequenceLineRAByteData(SVNPropertyValue.getPropertyAsBytes(workingValue));
                                QSequenceLineRAByteData latestData = new QSequenceLineRAByteData(SVNPropertyValue.getPropertyAsBytes(newValue));
                                merger.merge(baseData, localData, latestData, null, result, null);
                            }
                            catch (IOException e) {
                                SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
                                SVNErrorManager.error(err3, e, SVNLogType.WC);
                                Object var30_45 = null;
                                SVNFileUtil.closeFile(result);
                                break block48;
                            }
                            Object var30_44 = null;
                        }
                        catch (Throwable throwable) {
                            Object var30_46 = null;
                            SVNFileUtil.closeFile(result);
                            throw throwable;
                        }
                        SVNFileUtil.closeFile(result);
                    }
                }
            }
            String mimeType = null;
            if (!isDir && workingProps != null) {
                mimeType = workingProps.getStringValue("svn:mime-type");
            }
            SVNMergeFileSet fileSet = new SVNMergeFileSet(adminArea, log, baseFile, workingFile, localPath, newFile, mergedFile, null, mimeType);
            SVNConflictAction action = SVNConflictAction.EDIT;
            if (oldValue == null && newValue != null) {
                action = SVNConflictAction.ADD;
            } else if (oldValue != null && newValue == null) {
                action = SVNConflictAction.DELETE;
            }
            SVNConflictReason reason = SVNConflictReason.EDITED;
            if (baseValue != null && workingValue == null) {
                reason = SVNConflictReason.DELETED;
            } else if (baseValue == null && workingValue != null) {
                reason = SVNConflictReason.OBSTRUCTED;
            }
            SVNPropertyConflictDescription description = new SVNPropertyConflictDescription(fileSet, isDir ? SVNNodeKind.DIR : SVNNodeKind.FILE, propName, action, reason);
            SVNConflictResult result = this.myConflictCallback.handleConflict(description);
            if (result == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CONFLICT_RESOLVER_FAILURE, "Conflict callback violated API: returned no results.");
                SVNErrorManager.error(err, SVNLogType.DEFAULT);
            }
            if ((choice = result.getConflictChoice()) == SVNConflictChoice.MINE_FULL) {
                conflictRemains = false;
            } else if (choice == SVNConflictChoice.THEIRS_FULL) {
                this.changeProperty(workingProps, propName, newValue);
                conflictRemains = false;
            } else if (choice == SVNConflictChoice.BASE) {
                this.changeProperty(workingProps, propName, baseValue);
                conflictRemains = false;
            } else if (choice == SVNConflictChoice.MERGED) {
                if (mergedFile == null && result.getMergedFile() == null) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CONFLICT_RESOLVER_FAILURE, "Conflict callback violated API: returned no merged file.");
                    SVNErrorManager.error(err, SVNLogType.DEFAULT);
                }
                String mergedString = SVNFileUtil.readFile(mergedFile != null ? mergedFile : result.getMergedFile());
                this.changeProperty(workingProps, propName, SVNPropertyValue.create(mergedString));
                conflictRemains = false;
            }
            bl = conflictRemains;
            Object var32_48 = null;
        }
        catch (Throwable throwable) {
            Object var32_49 = null;
            SVNFileUtil.deleteFile(workingFile);
            SVNFileUtil.deleteFile(newFile);
            SVNFileUtil.deleteFile(baseFile);
            SVNFileUtil.deleteFile(mergedFile);
            throw throwable;
        }
        SVNFileUtil.deleteFile(workingFile);
        SVNFileUtil.deleteFile(newFile);
        SVNFileUtil.deleteFile(baseFile);
        SVNFileUtil.deleteFile(mergedFile);
        return bl;
    }

    static {
        STATUS_ORDERING.add(SVNStatusType.UNKNOWN);
        STATUS_ORDERING.add(SVNStatusType.UNCHANGED);
        STATUS_ORDERING.add(SVNStatusType.INAPPLICABLE);
        STATUS_ORDERING.add(SVNStatusType.CHANGED);
        STATUS_ORDERING.add(SVNStatusType.MERGED);
        STATUS_ORDERING.add(SVNStatusType.OBSTRUCTED);
        STATUS_ORDERING.add(SVNStatusType.CONFLICTED);
    }
}

