/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.design;

import antlr.collections.AST;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForbidWildcardAsReturnTypeCheck
extends Check {
    public static final String MSG_KEY = "forbid.wildcard.as.return.type";
    private static final int WILDCARD_EXTENDS_IDENT = 168;
    private static final int WILDCARD_SUPER_IDENT = 169;
    private static final DetailAST[] EMPTY_DETAILAST_ARRAY = new DetailAST[0];
    private boolean mCheckPublicMethods = true;
    private boolean mCheckProtectedMethods = true;
    private boolean mCheckPackageMethods = true;
    private boolean mCheckPrivateMethods;
    private boolean mCheckOverrideMethods;
    private boolean mCheckDeprecatedMethods;
    private boolean mAllowReturnWildcardWithSuper;
    private boolean mAllowReturnWildcardWithExtends;
    private Pattern mReturnTypeClassNamesIgnoreRegex = Pattern.compile("^(Comparator|Comparable)$");

    public void setCheckPublicMethods(boolean aCheckPublicMethods) {
        this.mCheckPublicMethods = aCheckPublicMethods;
    }

    public void setCheckProtectedMethods(boolean aCheckProtectedMethods) {
        this.mCheckProtectedMethods = aCheckProtectedMethods;
    }

    public void setCheckPackageMethods(boolean aCheckPackageMethods) {
        this.mCheckPackageMethods = aCheckPackageMethods;
    }

    public void setCheckPrivateMethods(boolean aCheckPrivateMethods) {
        this.mCheckPrivateMethods = aCheckPrivateMethods;
    }

    public void setCheckOverrideMethods(boolean aCheckOverrideMethods) {
        this.mCheckOverrideMethods = aCheckOverrideMethods;
    }

    public void setCheckDeprecatedMethods(boolean aCheckDeprecatedMethods) {
        this.mCheckDeprecatedMethods = aCheckDeprecatedMethods;
    }

    public void setAllowReturnWildcardWithSuper(boolean aAllowReturnWildcardWithSuper) {
        this.mAllowReturnWildcardWithSuper = aAllowReturnWildcardWithSuper;
    }

    public void setAllowReturnWildcardWithExtends(boolean aAllowReturnWildcardWithExtends) {
        this.mAllowReturnWildcardWithExtends = aAllowReturnWildcardWithExtends;
    }

    public void setReturnTypeClassNamesIgnoreRegex(String aReturnTypeClassNamesIgnoreRegex) {
        this.mReturnTypeClassNamesIgnoreRegex = Pattern.compile(aReturnTypeClassNamesIgnoreRegex);
    }

    public int[] getDefaultTokens() {
        return new int[]{9};
    }

    public void visitToken(DetailAST aMethodDefAst) {
        List<DetailAST> wildcardTypeArguments;
        String methodScope = ForbidWildcardAsReturnTypeCheck.getVisibilityScope(aMethodDefAst);
        if ((this.mCheckPublicMethods && "public".equals(methodScope) || this.mCheckPrivateMethods && "private".equals(methodScope) || this.mCheckProtectedMethods && "protected".equals(methodScope) || this.mCheckPackageMethods && "package".equals(methodScope)) && (this.mCheckOverrideMethods || !ForbidWildcardAsReturnTypeCheck.hasAnnotation(aMethodDefAst, "Override")) && (this.mCheckDeprecatedMethods || !ForbidWildcardAsReturnTypeCheck.hasAnnotation(aMethodDefAst, "Deprecated")) && !(wildcardTypeArguments = ForbidWildcardAsReturnTypeCheck.getWildcardArgumentsAsMethodReturnType(aMethodDefAst)).isEmpty() && !this.isIgnoreCase(aMethodDefAst, wildcardTypeArguments)) {
            this.log(aMethodDefAst.getLineNo(), MSG_KEY, new Object[0]);
        }
    }

    private static String getVisibilityScope(DetailAST aMethodDefAst) {
        String result = "package";
        if (ForbidWildcardAsReturnTypeCheck.isInsideInterfaceDefinition(aMethodDefAst)) {
            result = "public";
        } else {
            String[] visibilityScopeModifiers = new String[]{"public", "private", "protected"};
            Set<String> methodModifiers = ForbidWildcardAsReturnTypeCheck.getModifiers(aMethodDefAst);
            for (String modifier : visibilityScopeModifiers) {
                if (!methodModifiers.contains(modifier)) continue;
                result = modifier;
                break;
            }
        }
        return result;
    }

    private static boolean isInsideInterfaceDefinition(DetailAST aMethodDefAst) {
        boolean result = false;
        DetailAST objBlock = aMethodDefAst.getParent();
        DetailAST interfaceDef = objBlock.getParent();
        if (interfaceDef.getType() == 15) {
            result = true;
        }
        return result;
    }

    private static Set<String> getModifiers(DetailAST aMethodDefAst) {
        DetailAST modifiersAst = aMethodDefAst.getFirstChild();
        HashSet<String> modifiersSet = new HashSet<String>();
        for (AST modifierAst = modifiersAst.getFirstChild(); modifierAst != null; modifierAst = modifierAst.getNextSibling()) {
            modifiersSet.add(modifierAst.getText());
        }
        return modifiersSet;
    }

    private static String getIdentifier(DetailAST aAst) {
        String result = null;
        DetailAST identifier = aAst.findFirstToken(58);
        if (identifier != null) {
            result = identifier.getText();
        }
        return result;
    }

    private static boolean hasAnnotation(DetailAST aMethodDefAst, String aAnnotationTitle) {
        boolean result = false;
        DetailAST modifiersAst = aMethodDefAst.getFirstChild();
        if (ForbidWildcardAsReturnTypeCheck.hasChildToken(modifiersAst, 159)) {
            for (DetailAST modifierAst = modifiersAst.getFirstChild(); modifierAst != null; modifierAst = modifierAst.getNextSibling()) {
                if (modifierAst.getType() != 159 || !aAnnotationTitle.equals(ForbidWildcardAsReturnTypeCheck.getIdentifier(modifierAst))) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private static List<DetailAST> getWildcardArgumentsAsMethodReturnType(DetailAST aMethodDefAst) {
        DetailAST[] methodTypeArgumentTokens;
        LinkedList<DetailAST> result = new LinkedList<DetailAST>();
        DetailAST methodTypeAst = aMethodDefAst.findFirstToken(13);
        for (DetailAST typeArgumentAst : methodTypeArgumentTokens = ForbidWildcardAsReturnTypeCheck.getGenericTypeArguments(methodTypeAst)) {
            if (!ForbidWildcardAsReturnTypeCheck.hasChildToken(typeArgumentAst, 167)) continue;
            result.add(typeArgumentAst);
        }
        return result;
    }

    private static DetailAST[] getGenericTypeArguments(DetailAST aTypeAst) {
        DetailAST[] result = EMPTY_DETAILAST_ARRAY;
        if (ForbidWildcardAsReturnTypeCheck.hasChildToken(aTypeAst, 163)) {
            DetailAST typeArguments = aTypeAst.findFirstToken(163);
            int argumentsCount = typeArguments.getChildCount(164);
            result = new DetailAST[argumentsCount];
            int counter = 0;
            for (DetailAST firstTypeArgument = typeArguments.findFirstToken(164); firstTypeArgument != null; firstTypeArgument = firstTypeArgument.getNextSibling()) {
                if (firstTypeArgument.getType() != 164) continue;
                result[counter] = firstTypeArgument;
                ++counter;
            }
        }
        return result;
    }

    private static boolean hasChildToken(DetailAST aAst, int aTokenType) {
        return aAst.findFirstToken(aTokenType) != null;
    }

    private boolean isIgnoreCase(DetailAST aMethodDefAst, List<DetailAST> aWildcardTypeArguments) {
        boolean result = false;
        if (this.matchesIgnoreClassNames(aMethodDefAst)) {
            result = true;
        } else {
            boolean hasExtendsWildcardAsReturnType = ForbidWildcardAsReturnTypeCheck.hasBoundedWildcardAsReturnType(aWildcardTypeArguments, 168);
            boolean hasSuperWildcardAsReturnType = ForbidWildcardAsReturnTypeCheck.hasBoundedWildcardAsReturnType(aWildcardTypeArguments, 169);
            boolean hasOnlyExtendsWildcardAsReturnType = hasExtendsWildcardAsReturnType && !hasSuperWildcardAsReturnType;
            boolean hasOnlySuperWildcardAsReturnType = hasSuperWildcardAsReturnType && !hasExtendsWildcardAsReturnType;
            boolean hasBoundedWildcardAsReturnType = hasExtendsWildcardAsReturnType || hasSuperWildcardAsReturnType;
            boolean isAllowedBoundedWildcards = this.mAllowReturnWildcardWithExtends && this.mAllowReturnWildcardWithSuper;
            result = isAllowedBoundedWildcards && hasBoundedWildcardAsReturnType || this.mAllowReturnWildcardWithExtends && hasOnlyExtendsWildcardAsReturnType || this.mAllowReturnWildcardWithSuper && hasOnlySuperWildcardAsReturnType;
        }
        return result;
    }

    private boolean matchesIgnoreClassNames(DetailAST aMethodDefAst) {
        DetailAST methodTypeAst = aMethodDefAst.findFirstToken(13);
        String typeIdentifier = ForbidWildcardAsReturnTypeCheck.getIdentifier(methodTypeAst);
        return this.mReturnTypeClassNamesIgnoreRegex.matcher(typeIdentifier).matches();
    }

    private static boolean hasBoundedWildcardAsReturnType(List<DetailAST> aTypeArgumentsList, int aBoundedWildcardType) {
        boolean result = false;
        for (DetailAST typeArgumentAst : aTypeArgumentsList) {
            if (!ForbidWildcardAsReturnTypeCheck.hasChildToken(typeArgumentAst, aBoundedWildcardType)) continue;
            result = true;
            break;
        }
        return result;
    }
}

