/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OverridableMethodInConstructorCheck
extends Check {
    private final String mKey = "overridable.method";
    private final String mKeyCtor = "constructor";
    private final String mKeyClone = "'clone()' method";
    private final String mKeyReadObject = "'readObject()' method";
    private List<DetailAST> mVisitedMethodCalls = new LinkedList<DetailAST>();
    private DetailAST mCurMethodDef;
    private DetailAST mTreeRootAST;
    private boolean mCheckCloneMethod;
    private boolean mCheckReadObjectMethod;
    private boolean mMatchMethodsByArgCount;
    private String mCurOverridableMetName;
    private int mCurMethodDefCount;

    public void setCheckCloneMethod(boolean aValue) {
        this.mCheckCloneMethod = aValue;
    }

    public void setMatchMethodsByArgCount(boolean aValue) {
        this.mMatchMethodsByArgCount = aValue;
    }

    public void setCheckReadObjectMethod(boolean aValue) {
        this.mCheckReadObjectMethod = aValue;
    }

    public int[] getDefaultTokens() {
        return new int[]{8, 9};
    }

    public void beginTree(DetailAST aRootAST) {
        this.mTreeRootAST = aRootAST;
    }

    public void visitToken(DetailAST aDetailAST) {
        DetailAST classDef = OverridableMethodInConstructorCheck.getClassDef(aDetailAST);
        if (classDef != null && !OverridableMethodInConstructorCheck.hasModifier(classDef, 39)) {
            switch (aDetailAST.getType()) {
                case 8: {
                    this.logWarnings(aDetailAST, "constructor");
                    break;
                }
                case 9: {
                    String methodName = aDetailAST.findFirstToken(58).getText();
                    if (this.mCheckCloneMethod && "clone".equals(methodName) && this.realizesAnInterface(classDef, "Cloneable")) {
                        this.logWarnings(aDetailAST, "'clone()' method");
                        break;
                    }
                    if (!this.mCheckReadObjectMethod || !"readObject".equals(methodName) || !this.realizesAnInterface(classDef, "Serializable")) break;
                    this.logWarnings(aDetailAST, "'readObject()' method");
                    break;
                }
            }
        }
    }

    private void logWarnings(DetailAST aDetailAST, String aKey) {
        List<OverridableMetCall> methodCallsToWarnList = this.getOverridables(aDetailAST);
        for (OverridableMetCall om : methodCallsToWarnList) {
            String msgKey = "overridable.method";
            DetailAST methodDef = this.getMethodDef(om.mMetCallAST);
            if (OverridableMethodInConstructorCheck.hasModifier(methodDef, 61) || OverridableMethodInConstructorCheck.hasModifier(methodDef, 39)) {
                msgKey = msgKey + ".leads";
            }
            this.log(om.mMetCallAST, msgKey, new Object[]{this.getMethodName(om.mMetCallAST), aKey, om.mOverridableMetName});
        }
    }

    private List<OverridableMetCall> getOverridables(DetailAST aParentAST) {
        LinkedList<OverridableMetCall> result = new LinkedList<OverridableMetCall>();
        List<DetailAST> methodCallsList = this.getMethodCallsList(aParentAST);
        for (DetailAST curNode : methodCallsList) {
            this.mVisitedMethodCalls.clear();
            DetailAST methodDef = this.getMethodDef(curNode);
            if (methodDef == null || OverridableMethodInConstructorCheck.getMethodParamsCount(curNode) != OverridableMethodInConstructorCheck.getMethodParamsCount(methodDef) || !this.isOverridableMethodCall(curNode)) continue;
            result.add(new OverridableMetCall(curNode, this.mCurOverridableMetName));
        }
        return result;
    }

    private boolean isOverridableMethodCall(DetailAST aMethodCallAST) {
        boolean result = false;
        this.mVisitedMethodCalls.add(aMethodCallAST);
        String methodName = this.getMethodName(aMethodCallAST);
        if (methodName != null) {
            DetailAST methodDef = this.getMethodDef(aMethodCallAST);
            if (methodDef != null && !OverridableMethodInConstructorCheck.hasModifier(methodDef, 64)) {
                if (OverridableMethodInConstructorCheck.hasModifier(methodDef, 61) || OverridableMethodInConstructorCheck.hasModifier(methodDef, 39)) {
                    List<DetailAST> methodCallsList = this.getMethodCallsList(methodDef);
                    for (DetailAST curNode : methodCallsList) {
                        if (this.mVisitedMethodCalls.contains(curNode)) {
                            result = false;
                        } else {
                            if (!this.isOverridableMethodCall(curNode)) continue;
                            result = true;
                        }
                        break;
                    }
                } else {
                    this.mCurOverridableMetName = methodName;
                    result = true;
                }
            }
        } else {
            result = false;
        }
        return result;
    }

    private List<DetailAST> getMethodCallsList(DetailAST aParentAST) {
        LinkedList<DetailAST> result = new LinkedList<DetailAST>();
        for (DetailAST curNode : OverridableMethodInConstructorCheck.getChildren(aParentAST)) {
            if (curNode.getNumberOfChildren() <= 0) continue;
            if (curNode.getType() == 27) {
                result.add(curNode);
                continue;
            }
            result.addAll(this.getMethodCallsList(curNode));
        }
        return result;
    }

    private String getMethodName(DetailAST aMethodCallAST) {
        String result = null;
        DetailAST ident = aMethodCallAST.findFirstToken(58);
        if (ident != null) {
            result = ident.getText();
        } else {
            DetailAST childAST = aMethodCallAST.getFirstChild();
            if (childAST != null && childAST.getType() == 59) {
                DetailAST firstChild = childAST.getFirstChild();
                DetailAST lastChild = childAST.getLastChild();
                if (firstChild.getType() == 78 || firstChild.getType() == 76) {
                    result = lastChild.getText();
                } else if (firstChild.getType() == 58 && lastChild.getType() == 58) {
                    String curClassName = OverridableMethodInConstructorCheck.getClassDef(aMethodCallAST).findFirstToken(58).getText();
                    if (firstChild.getText().equals(curClassName) || OverridableMethodInConstructorCheck.getClassDef(this.mTreeRootAST, firstChild.getText()) != null) {
                        result = lastChild.getText();
                    }
                }
            }
        }
        return result;
    }

    private DetailAST getMethodDef(DetailAST aMethodCallAST) {
        DetailAST result = null;
        this.mCurMethodDef = null;
        this.mCurMethodDefCount = 0;
        String methodName = this.getMethodName(aMethodCallAST);
        if (methodName != null) {
            String variableTypeName;
            DetailAST curClassAST = OverridableMethodInConstructorCheck.getClassDef(aMethodCallAST);
            DetailAST callsChild = aMethodCallAST.getFirstChild();
            if (callsChild.getType() != 59 || (variableTypeName = OverridableMethodInConstructorCheck.getVariableType(aMethodCallAST)) == null || OverridableMethodInConstructorCheck.isItTypeOfCurrentClass(variableTypeName, curClassAST) || "this".equals(variableTypeName)) {
                this.getMethodDef(curClassAST, methodName);
            }
            if (this.mCurMethodDefCount == 0) {
                List<DetailAST> baseClasses = this.getBaseClasses(curClassAST);
                for (DetailAST curBaseClass : baseClasses) {
                    this.mCurMethodDef = null;
                    this.mCurMethodDefCount = 0;
                    this.getMethodDef(curBaseClass, methodName);
                    if (this.mCurMethodDefCount != 1) continue;
                    result = this.mCurMethodDef;
                    break;
                }
            } else if (this.mCurMethodDefCount == 1) {
                result = this.mCurMethodDef;
            } else if (this.mMatchMethodsByArgCount) {
                int sameDefinitionCounter = 0;
                int curMethodParamCount = OverridableMethodInConstructorCheck.getMethodParamsCount(aMethodCallAST);
                for (DetailAST currentDefinition : this.getMethodDef(curClassAST, methodName)) {
                    if (OverridableMethodInConstructorCheck.getMethodParamsCount(currentDefinition) != curMethodParamCount) continue;
                    result = currentDefinition;
                    ++sameDefinitionCounter;
                }
                if (sameDefinitionCounter > 1) {
                    result = null;
                }
            }
        }
        return result;
    }

    private static String getVariableType(DetailAST aMethodCall) {
        DetailAST callsChild = aMethodCall.getFirstChild();
        String typeName = new String();
        if (callsChild.getType() == 59) {
            DetailAST dotChild = callsChild.getFirstChild();
            if (dotChild.getType() == 78) {
                typeName = "this";
            } else if (callsChild.getChildCount(23) > 0) {
                DetailAST typeCast = callsChild.findFirstToken(23);
                DetailAST type = typeCast.getFirstChild().getFirstChild();
                typeName = type.getText();
            }
        }
        return typeName;
    }

    private static boolean isItTypeOfCurrentClass(String aObjectTypeName, DetailAST aClassDefNode) {
        DetailAST className = aClassDefNode.findFirstToken(58);
        boolean result = false;
        if (aObjectTypeName.equals(className.getText())) {
            result = true;
        } else {
            DetailAST baseClass = aClassDefNode.findFirstToken(18);
            if (baseClass != null && aObjectTypeName.equals((baseClass = baseClass.getFirstChild()).getText())) {
                result = true;
            }
        }
        return result;
    }

    private List<DetailAST> getMethodDef(DetailAST aParentAST, String aMethodName) {
        List<DetailAST> definitionsList = new LinkedList<DetailAST>();
        for (DetailAST curNode : OverridableMethodInConstructorCheck.getChildren(aParentAST)) {
            int type;
            String curMethodName;
            if (curNode.getNumberOfChildren() <= 0) continue;
            if (curNode.getType() == 9 && aMethodName.equals(curMethodName = curNode.findFirstToken(58).getText())) {
                this.mCurMethodDef = curNode;
                definitionsList.add(0, curNode);
                ++this.mCurMethodDefCount;
            }
            if ((type = curNode.getType()) == 14 || type == 8 || type == 5 || type == 19 || type == 9) continue;
            definitionsList = this.getMethodDef(curNode, aMethodName);
        }
        return definitionsList;
    }

    private static int getMethodParamsCount(DetailAST aMethodDefOrCallAST) {
        int result = 0;
        DetailAST paramsParentAST = null;
        if (aMethodDefOrCallAST.getType() == 27) {
            paramsParentAST = aMethodDefOrCallAST.findFirstToken(34);
        } else if (aMethodDefOrCallAST.getType() == 9) {
            paramsParentAST = aMethodDefOrCallAST.findFirstToken(20);
        }
        if (paramsParentAST != null && paramsParentAST.getChildCount() != 0) {
            for (DetailAST curNode : OverridableMethodInConstructorCheck.getChildren(paramsParentAST)) {
                if (curNode.getType() != 74) continue;
                ++result;
            }
            ++result;
        }
        return result;
    }

    private static boolean hasModifier(DetailAST aMethodOrClassDefAST, int aModifierType) {
        boolean result = false;
        DetailAST modifiers = aMethodOrClassDefAST.findFirstToken(5);
        if (modifiers != null && modifiers.getChildCount() != 0) {
            for (DetailAST curNode : OverridableMethodInConstructorCheck.getChildren(modifiers)) {
                if (curNode.getType() != aModifierType) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private static DetailAST getClassDef(DetailAST aMethodNode) {
        DetailAST curNode;
        for (curNode = aMethodNode; curNode != null && curNode.getType() != 14; curNode = curNode.getParent()) {
        }
        return curNode;
    }

    private boolean realizesAnInterface(DetailAST aClassDefNode, String aInterfaceName) {
        boolean result = false;
        List<DetailAST> classWithBaseClasses = this.getBaseClasses(aClassDefNode);
        classWithBaseClasses.add(aClassDefNode);
        for (DetailAST classAST : classWithBaseClasses) {
            if (!OverridableMethodInConstructorCheck.implementsAnInterface(classAST, aInterfaceName)) continue;
            result = true;
            break;
        }
        return result;
    }

    private static boolean implementsAnInterface(DetailAST aClassDefAST, String aInterfaceName) {
        boolean result = false;
        DetailAST implClause = aClassDefAST.findFirstToken(19);
        if (implClause != null) {
            for (DetailAST ident : OverridableMethodInConstructorCheck.getChildren(implClause)) {
                if (!ident.getText().equals(aInterfaceName)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private List<DetailAST> getBaseClasses(DetailAST aClassDefNode) {
        LinkedList<DetailAST> result = new LinkedList<DetailAST>();
        String baseClassName = OverridableMethodInConstructorCheck.getBaseClassName(aClassDefNode);
        if (baseClassName != null) {
            DetailAST curClass = OverridableMethodInConstructorCheck.getClassDef(this.mTreeRootAST, baseClassName);
            while (curClass != null) {
                result.add(curClass);
                baseClassName = OverridableMethodInConstructorCheck.getBaseClassName(curClass);
                if (baseClassName == null) break;
                curClass = OverridableMethodInConstructorCheck.getClassDef(this.mTreeRootAST, baseClassName);
            }
        }
        return result;
    }

    private static DetailAST getClassDef(DetailAST aRootNode, String aClassName) {
        DetailAST curNode = aRootNode;
        while (curNode != null) {
            DetailAST toVisit = curNode.getFirstChild();
            while (curNode != null && toVisit == null) {
                toVisit = curNode.getNextSibling();
                if (toVisit != null) continue;
                curNode = curNode.getParent();
            }
            curNode = toVisit;
            if (curNode != null && (curNode.getType() != 14 || !curNode.findFirstToken(58).getText().equals(aClassName))) continue;
            break;
        }
        return curNode;
    }

    private static String getBaseClassName(DetailAST aClassDefNode) {
        String result = null;
        DetailAST extendsClause = aClassDefNode.findFirstToken(18);
        if (extendsClause != null) {
            DetailAST dot = extendsClause.findFirstToken(59);
            result = dot != null ? dot.findFirstToken(58).getText() : extendsClause.findFirstToken(58).getText();
        }
        return result;
    }

    private static List<DetailAST> getChildren(DetailAST aNode) {
        LinkedList<DetailAST> result = new LinkedList<DetailAST>();
        for (DetailAST curNode = aNode.getFirstChild(); curNode != null; curNode = curNode.getNextSibling()) {
            result.add(curNode);
        }
        return result;
    }

    private class OverridableMetCall {
        private DetailAST mMetCallAST;
        private String mOverridableMetName;

        public OverridableMetCall(DetailAST aMethodCallAST, String aOverridableMetName) {
            this.mMetCallAST = aMethodCallAST;
            this.mOverridableMetName = aOverridableMetName;
        }
    }
}

