/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.checks.CheckUtils;
import com.puppycrawl.tools.checkstyle.checks.coding.AbstractIllegalCheck;

public final class IllegalCatchExtendedCheck
extends AbstractIllegalCheck {
    private boolean mAllowThrow = true;
    private boolean mAllowRethrow = true;

    public void setAllowThrow(boolean aValue) {
        this.mAllowThrow = aValue;
    }

    public void setAllowRethrow(boolean aValue) {
        this.mAllowRethrow = aValue;
    }

    public IllegalCatchExtendedCheck() {
        super(new String[]{"Exception", "Error", "RuntimeException", "Throwable", "java.lang.Error", "java.lang.Exception", "java.lang.RuntimeException", "java.lang.Throwable"});
    }

    public int[] getDefaultTokens() {
        return new int[]{96};
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST aDetailAST) {
        DetailAST paramDef = aDetailAST.findFirstToken(21);
        DetailAST throwAST = this.getThrowAST(aDetailAST);
        DetailAST firstLvlChild = null;
        if (throwAST != null) {
            firstLvlChild = throwAST.getFirstChild();
        }
        DetailAST secondLvlChild = null;
        if (firstLvlChild != null) {
            secondLvlChild = firstLvlChild.getFirstChild();
        }
        boolean noWarning = throwAST != null && firstLvlChild != null && secondLvlChild != null && firstLvlChild.getType() == 28 && (this.mAllowThrow && secondLvlChild.getType() == 58 || this.mAllowRethrow && secondLvlChild.getType() == 136);
        DetailAST excType = paramDef.findFirstToken(13);
        FullIdent ident = CheckUtils.createFullType((DetailAST)excType);
        if (!noWarning && this.isIllegalClassName(ident.getText())) {
            this.log(aDetailAST, "illegal.catch", new Object[]{ident.getText()});
        }
    }

    public DetailAST getThrowAST(DetailAST aParentAST) {
        DetailAST[] asts;
        for (DetailAST currentNode : asts = IllegalCatchExtendedCheck.getChilds(aParentAST)) {
            DetailAST astResult;
            if (currentNode.getType() != 21 && currentNode.getNumberOfChildren() > 0 && (astResult = this.getThrowAST(currentNode)) != null) {
                return astResult;
            }
            if (currentNode.getType() == 90) {
                return currentNode;
            }
            if (currentNode.getNextSibling() == null) continue;
            currentNode = currentNode.getNextSibling();
        }
        return null;
    }

    public static DetailAST[] getChilds(DetailAST aNode) {
        DetailAST[] result = new DetailAST[aNode.getChildCount()];
        DetailAST currNode = aNode.getFirstChild();
        for (int i = 0; i < aNode.getNumberOfChildren(); ++i) {
            result[i] = currNode;
            currNode = currNode.getNextSibling();
        }
        return result;
    }
}

