/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ForbidInstantiationCheck
extends Check {
    private static final String WARNING_MSG_KEY = "forbid.instantiation";
    private Set<String> mForbiddenClasses = new HashSet<String>();
    private List<String> mImportsList = new LinkedList<String>();

    public ForbidInstantiationCheck() {
        this.mForbiddenClasses.add("java.lang.NullPointerException");
    }

    public void setForbiddenClasses(String[] aClassNames) {
        this.mForbiddenClasses.clear();
        if (aClassNames != null) {
            for (String name : aClassNames) {
                this.mForbiddenClasses.add(name);
            }
        }
    }

    public void beginTree(DetailAST aRootAST) {
        this.mImportsList.clear();
    }

    public int[] getDefaultTokens() {
        return new int[]{30, 136};
    }

    public void visitToken(DetailAST aAst) {
        switch (aAst.getType()) {
            case 30: {
                this.mImportsList.add(ForbidInstantiationCheck.getText(aAst));
                break;
            }
            case 136: {
                String instanceClass = ForbidInstantiationCheck.getText(aAst);
                if (instanceClass == null) break;
                String instanceClassName = ForbidInstantiationCheck.getClassName(instanceClass);
                for (String forbiddenClass : this.mForbiddenClasses) {
                    if (forbiddenClass.startsWith("java.lang.") && forbiddenClass.endsWith(instanceClassName)) {
                        this.log(aAst, WARNING_MSG_KEY, new Object[]{instanceClassName});
                        continue;
                    }
                    if (instanceClass.contains(".")) {
                        if (!instanceClass.equals(forbiddenClass)) continue;
                        this.log(aAst, WARNING_MSG_KEY, new Object[]{instanceClassName});
                        continue;
                    }
                    if (!this.addedUsingForbiddenImport(instanceClass, forbiddenClass)) continue;
                    this.log(aAst, WARNING_MSG_KEY, new Object[]{instanceClass});
                }
                break;
            }
            default: {
                String className = ((Object)((Object)this)).getClass().getSimpleName();
                String tokenType = TokenTypes.getTokenName((int)aAst.getType());
                String tokenDescription = aAst.toString();
                String message = String.format("%s got the wrong input token: %s (%s)", className, tokenType, tokenDescription);
                throw new IllegalArgumentException(message);
            }
        }
    }

    private boolean addedUsingForbiddenImport(String aClassName, String aForbiddenClassNameAndPath) {
        boolean result = false;
        for (String importText : this.mImportsList) {
            if (importText.endsWith("*")) {
                String importTextWithoutAsterisk = importText.substring(0, importText.length() - 1);
                if (!aForbiddenClassNameAndPath.equals(importTextWithoutAsterisk + aClassName)) continue;
                result = true;
                break;
            }
            if (!importText.equals(aForbiddenClassNameAndPath) || !importText.endsWith(aClassName)) continue;
            result = true;
            break;
        }
        return result;
    }

    private static String getClassName(String aClassNameAndPath) {
        return aClassNameAndPath.replaceAll(".+\\.", "");
    }

    private static String getText(DetailAST aAST) {
        String result = null;
        DetailAST textWithoutDots = aAST.findFirstToken(58);
        if (textWithoutDots == null) {
            DetailAST parentDotAST = aAST.findFirstToken(59);
            if (parentDotAST != null) {
                FullIdent dottedPathIdent = FullIdent.createFullIdentBelow((DetailAST)parentDotAST);
                DetailAST nameAST = parentDotAST.getLastChild();
                result = dottedPathIdent.getText() + "." + nameAST.getText();
            }
        } else {
            result = textWithoutDots.getText();
        }
        return result;
    }
}

