/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;
import java.util.regex.Pattern;

public class ForbidCertainImportsCheck
extends Check {
    protected static final String MSG_KEY = "forbid.certain.imports";
    private Pattern mPackageNamesRegexp;
    private Pattern mForbiddenImportsRegexp;
    private Pattern mForbiddenImportsExcludesRegexp;
    private boolean mPackageMatches;

    public void setPackageNameRegexp(String aPackageNameRegexp) {
        if (aPackageNameRegexp != null) {
            this.mPackageNamesRegexp = Pattern.compile(aPackageNameRegexp);
        }
    }

    public String getForbiddenImportRegexp() {
        return this.mForbiddenImportsRegexp.toString();
    }

    public void setForbiddenImportsRegexp(String aForbiddenImportsRegexp) {
        if (aForbiddenImportsRegexp != null) {
            this.mForbiddenImportsRegexp = Pattern.compile(aForbiddenImportsRegexp);
        }
    }

    public String getForbiddenImportsExcludesRegexp() {
        return this.mForbiddenImportsExcludesRegexp.toString();
    }

    public void setForbiddenImportsExcludesRegexp(String aForbiddenImportsExcludesRegexp) {
        if (aForbiddenImportsExcludesRegexp != null) {
            this.mForbiddenImportsExcludesRegexp = Pattern.compile(aForbiddenImportsExcludesRegexp);
        }
    }

    public int[] getDefaultTokens() {
        int[] defaultTokens = this.mPackageNamesRegexp == null || this.mForbiddenImportsRegexp == null || this.mForbiddenImportsExcludesRegexp == null ? new int[]{} : new int[]{16, 30, 136};
        return defaultTokens;
    }

    public void visitToken(DetailAST aAst) {
        switch (aAst.getType()) {
            case 16: {
                if (this.mPackageNamesRegexp == null) break;
                String packageQualifiedName = ForbidCertainImportsCheck.getText(aAst);
                this.mPackageMatches = this.mPackageNamesRegexp.matcher(packageQualifiedName).matches();
                break;
            }
            case 30: {
                String importQualifiedText;
                if (!this.mPackageMatches || this.mForbiddenImportsRegexp == null || this.mForbiddenImportsExcludesRegexp == null || !this.isImportForbidden(importQualifiedText = ForbidCertainImportsCheck.getText(aAst))) break;
                this.log(aAst, importQualifiedText);
                break;
            }
            case 136: {
                String importQualifiedText;
                if (this.mForbiddenImportsRegexp == null || this.mForbiddenImportsExcludesRegexp == null || aAst.findFirstToken(59) == null || !this.mPackageMatches || !this.isImportForbidden(importQualifiedText = ForbidCertainImportsCheck.getText(aAst))) break;
                this.log(aAst, importQualifiedText);
                break;
            }
            default: {
                String className = ((Object)((Object)this)).getClass().getSimpleName();
                String tokenType = TokenTypes.getTokenName((int)aAst.getType());
                String tokenDescription = aAst.toString();
                String message = String.format("%s got the wrong input token: %s (%s)", className, tokenType, tokenDescription);
                throw new IllegalArgumentException(message);
            }
        }
    }

    private boolean isImportForbidden(String aImportText) {
        return this.mForbiddenImportsRegexp.matcher(aImportText).matches() && !this.mForbiddenImportsExcludesRegexp.matcher(aImportText).matches();
    }

    private void log(DetailAST aNodeToWarn, String aImportText) {
        this.log(aNodeToWarn.getLineNo(), MSG_KEY, new Object[]{this.getForbiddenImportRegexp(), aImportText});
    }

    private static String getText(DetailAST aPackageDefOrImportNode) {
        String result = null;
        DetailAST identNode = aPackageDefOrImportNode.findFirstToken(58);
        if (identNode == null) {
            DetailAST parentDotAST = aPackageDefOrImportNode.findFirstToken(59);
            if (parentDotAST != null) {
                FullIdent dottedPathIdent = FullIdent.createFullIdentBelow((DetailAST)parentDotAST);
                DetailAST nameAST = parentDotAST.getLastChild();
                result = dottedPathIdent.getText() + "." + nameAST.getText();
            }
        } else {
            result = identNode.getText();
        }
        return result;
    }
}

