/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Set;

public class ForbidCCommentsInMethods
extends Check {
    private Set<Integer> mCComments;

    public int[] getDefaultTokens() {
        return new int[]{9};
    }

    public void beginTree(DetailAST aRootAST) {
        this.mCComments = this.getFileContents().getCComments().keySet();
    }

    public void visitToken(DetailAST aMethodNode) {
        DetailAST borders;
        if (!this.mCComments.isEmpty() && (borders = aMethodNode.findFirstToken(7)) != null) {
            int methodBodyBegin = borders.getLineNo();
            int methodBodyEnd = borders.getLastChild().getLineNo();
            for (int commentLineNo : this.mCComments) {
                if (commentLineNo <= methodBodyBegin || commentLineNo >= methodBodyEnd) continue;
                this.log(commentLineNo, "forbid.c.comments.in.the.method.body", new Object[0]);
            }
        }
    }
}

