/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FastStack;
import com.puppycrawl.tools.checkstyle.api.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.beanutils.ConversionException;

public class CustomDeclarationOrderCheck
extends Check {
    private static final String DEFAULT_DECLARATION = "Field(.*public.*)### Field(.*protected.*) ### Field(.*private.*) ### CTOR(.*)### Method(.*) ### InnerClass(.*)";
    private final ArrayList<FormatMatcher> mCustomOrderDeclaration = new ArrayList();
    private final FastStack<ClassStates> mClassStates = new FastStack();
    private static final int INITIAL_STATE = 0;
    private int mCompileFlags;
    private boolean mClassRoot = true;
    private boolean mInnerClass;

    public CustomDeclarationOrderCheck() {
        this.setCustomDeclarationOrder(DEFAULT_DECLARATION);
    }

    public void setCustomDeclarationOrder(String aInputOrderDeclaration) {
        if (!this.mCustomOrderDeclaration.isEmpty()) {
            this.mCustomOrderDeclaration.clear();
        }
        for (String currentState : aInputOrderDeclaration.split("\\s*###\\s*")) {
            this.mCustomOrderDeclaration.add(this.parseInputDeclarationRule(currentState));
        }
    }

    private FormatMatcher parseInputDeclarationRule(String aCurrentState) {
        String regExp;
        String classMember;
        try {
            classMember = aCurrentState.substring(0, aCurrentState.indexOf(40)).trim();
            String classMemberNormalized = CustomDeclarationOrderCheck.normalizeMembersNames(classMember.toLowerCase());
            if (classMember.toLowerCase().equals(classMemberNormalized)) {
                throw new ConversionException("unable to parse " + classMember);
            }
            classMember = classMemberNormalized;
            regExp = aCurrentState.substring(aCurrentState.indexOf(40) + 1, aCurrentState.lastIndexOf(41));
            if (regExp.isEmpty()) {
                regExp = "package";
            }
        }
        catch (StringIndexOutOfBoundsException exp) {
            throw new StringIndexOutOfBoundsException("unable to parse input rule: " + aCurrentState + " " + exp);
        }
        FormatMatcher matcher = new FormatMatcher(aCurrentState, classMember, this.mCompileFlags);
        matcher.updateRegexp(regExp, this.mCompileFlags);
        return matcher;
    }

    private static String normalizeMembersNames(String aInputMemberName) {
        String member = aInputMemberName;
        if ("field".equals(aInputMemberName)) {
            member = "VARIABLE_DEF";
        } else if ("method".equals(aInputMemberName)) {
            member = "METHOD_DEF";
        } else if ("ctor".equals(aInputMemberName)) {
            member = "CTOR_DEF";
        } else if ("innerclass".equals(aInputMemberName)) {
            member = "CLASS_DEF";
        }
        return member;
    }

    public void setIgnoreRegExCase(boolean aCaseInsensitive) {
        if (aCaseInsensitive) {
            if (!this.mCustomOrderDeclaration.isEmpty()) {
                for (FormatMatcher currentRule : this.mCustomOrderDeclaration) {
                    currentRule.setCompileFlags(2);
                }
            } else {
                this.mCompileFlags = 2;
            }
        }
    }

    public int[] getDefaultTokens() {
        HashSet<String> classMembers = new HashSet<String>();
        for (FormatMatcher currentRule : this.mCustomOrderDeclaration) {
            if ("CLASS_DEF".equals(currentRule.getClassMember())) {
                this.mInnerClass = true;
                continue;
            }
            classMembers.add(currentRule.mClassMember);
        }
        int[] defaultTokens = new int[classMembers.size() + 1];
        defaultTokens[0] = 14;
        int index = 1;
        for (String token : classMembers) {
            defaultTokens[index] = "VARIABLE_DEF".equals(token) ? 10 : ("METHOD_DEF".equals(token) ? 9 : ("CTOR_DEF".equals(token) ? 8 : defaultTokens[0]));
            ++index;
        }
        return defaultTokens;
    }

    public void visitToken(DetailAST aAST) {
        if (aAST.getType() == 14) {
            if (!CustomDeclarationOrderCheck.isClassDefInMethodDef(aAST)) {
                if (this.mClassRoot) {
                    this.mClassStates.push((Object)new ClassStates());
                    this.mClassRoot = false;
                } else {
                    if (this.mInnerClass) {
                        this.checkOrderLogic(aAST);
                    }
                    this.mClassStates.push((Object)new ClassStates());
                }
            }
        } else {
            DetailAST parentAst = aAST.getParent().getParent();
            if (parentAst.getType() == 14 && !CustomDeclarationOrderCheck.isClassDefInMethodDef(parentAst)) {
                this.checkOrderLogic(aAST);
            }
        }
    }

    private static boolean isClassDefInMethodDef(DetailAST aClassDef) {
        boolean result = false;
        for (DetailAST currentParentAst = aClassDef.getParent(); currentParentAst != null; currentParentAst = currentParentAst.getParent()) {
            if (currentParentAst.getType() != 9) continue;
            result = true;
            break;
        }
        return result;
    }

    private void checkOrderLogic(DetailAST aAST) {
        ClassStates previousState = (ClassStates)this.mClassStates.peek();
        int currentState = this.getPosition(aAST);
        if (currentState >= 0) {
            if (previousState.mClassStates > currentState) {
                this.writeLog(aAST, currentState, previousState.mClassStates);
            } else {
                previousState.mClassStates = currentState;
            }
        }
    }

    private int getPosition(DetailAST aAST) {
        int result = -1;
        String modifiers = this.getUniteModifiersList(aAST);
        for (int index = 0; index < this.mCustomOrderDeclaration.size(); ++index) {
            FormatMatcher currentRule = this.mCustomOrderDeclaration.get(index);
            if (!currentRule.getClassMember().equals(aAST.getText()) || !currentRule.getRegexp().matcher(modifiers).find()) continue;
            result = index;
            break;
        }
        return result;
    }

    private void writeLog(DetailAST aAST, int aExpectPosition, int aCurrentPosition) {
        String token;
        switch (aAST.getType()) {
            case 10: {
                token = "custom.declaration.order.field";
                break;
            }
            case 9: {
                token = "custom.declaration.order.method";
                break;
            }
            case 8: {
                token = "custom.declaration.order.constructor";
                break;
            }
            case 14: {
                token = "custom.declaration.order.class";
                break;
            }
            default: {
                token = "Unknown element: " + aAST.getType();
            }
        }
        this.log(aAST, token, new Object[]{this.mCustomOrderDeclaration.get(aExpectPosition).getRule(), this.mCustomOrderDeclaration.get(aCurrentPosition).getRule()});
    }

    public void leaveToken(DetailAST aAST) {
        if (aAST.getType() == 14 && !CustomDeclarationOrderCheck.isClassDefInMethodDef(aAST)) {
            this.mClassStates.pop();
            if (this.mClassStates.isEmpty()) {
                this.mClassRoot = true;
            }
        }
    }

    private String getUniteModifiersList(DetailAST aAST) {
        StringBuffer modifiers = new StringBuffer();
        DetailAST ast = aAST.findFirstToken(5);
        if (null == ast.getFirstChild()) {
            modifiers.append("package ");
        }
        while (ast.getType() != 58) {
            if (ast != null && ast.getFirstChild() != null) {
                modifiers.append(this.concatLogic(ast.getFirstChild()));
                modifiers.append(" ");
            }
            ast = ast.getNextSibling();
        }
        modifiers.append(ast.getText());
        return modifiers.toString();
    }

    private String concatLogic(DetailAST aAST) {
        DetailAST ast = aAST;
        String separator = "";
        StringBuffer modifiers = new StringBuffer();
        if (ast.getParent().getType() == 5) {
            separator = " ";
        }
        while (ast != null) {
            if (ast.getFirstChild() != null) {
                modifiers.append(this.concatLogic(ast.getFirstChild()));
            } else {
                if (ast.getType() == 48) {
                    modifiers.append("[");
                }
                modifiers.append(ast.getText());
            }
            modifiers.append(separator);
            ast = ast.getNextSibling();
        }
        return modifiers.toString().trim();
    }

    private static class FormatMatcher {
        private Pattern mRegExp;
        private final String mClassMember;
        private final String mRule;
        private String mFormat;

        public FormatMatcher(String aInputRule, String aClassMember, int aCompileFlags) {
            this.mClassMember = aClassMember;
            this.mRule = aInputRule;
        }

        public final Pattern getRegexp() {
            return this.mRegExp;
        }

        public final String getRule() {
            return this.mRule;
        }

        public final String getClassMember() {
            return this.mClassMember;
        }

        public final void setCompileFlags(int aCompileFlags) {
            this.updateRegexp(this.mFormat, aCompileFlags);
        }

        private void updateRegexp(String aFormat, int aCompileFlags) {
            try {
                this.mRegExp = Utils.getPattern((String)aFormat, (int)aCompileFlags);
                this.mFormat = aFormat;
            }
            catch (PatternSyntaxException e) {
                throw new ConversionException("unable to parse " + aFormat, (Throwable)e);
            }
        }
    }

    private static class ClassStates {
        private int mClassStates = 0;

        private ClassStates() {
        }
    }
}

