/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class ConfusingConditionCheck
extends Check {
    public static final String MSG_KEY = "confusing.condition.check";
    private static final int MULTIPLY_FACTOR_FOR_ELSE_BLOCK = 4;
    private static int multiplyFactorForElseBlocks = 4;
    private boolean ignoreInnerIf = true;
    private boolean ignoreSequentialIf = true;
    private boolean ignoreNullCaseInIf = true;
    private boolean ignoreThrowInElse = true;

    public void setIgnoreInnerIf(boolean aIgnoreInnerIf) {
        this.ignoreInnerIf = aIgnoreInnerIf;
    }

    public void setIgnoreSequentialIf(boolean aIgnoreSequentialIf) {
        this.ignoreSequentialIf = aIgnoreSequentialIf;
    }

    public void setIgnoreNullCaseInIf(boolean aIgnoreNullCaseInIf) {
        this.ignoreNullCaseInIf = aIgnoreNullCaseInIf;
    }

    public void setIgnoreThrowInElse(boolean aIgnoreThrowInElse) {
        this.ignoreThrowInElse = aIgnoreThrowInElse;
    }

    public void setMultiplyFactorForElseBlocks(int aMultiplyFactorForElseBlocks) {
        multiplyFactorForElseBlocks = aMultiplyFactorForElseBlocks;
    }

    public int[] getDefaultTokens() {
        return new int[]{83};
    }

    public void visitToken(DetailAST aIf) {
        if (!(!ConfusingConditionCheck.isIfEndsWithElse(aIf) || this.ignoreSequentialIf && ConfusingConditionCheck.isSequentialIf(aIf) || this.ignoreInnerIf && ConfusingConditionCheck.isInnerIf(aIf) || this.ignoreThrowInElse && ConfusingConditionCheck.isElseWithThrow(aIf) || !ConfusingConditionCheck.isRatioBetweenIfAndElseBlockSuitable(aIf) || this.ignoreNullCaseInIf && ConfusingConditionCheck.isIfWithNull(aIf) || !ConfusingConditionCheck.isConditionAllNegative(aIf))) {
            this.log(aIf.getLineNo(), MSG_KEY, new Object[0]);
        }
    }

    private static boolean isIfEndsWithElse(DetailAST aIf) {
        DetailAST aLastChildAfterIf = aIf.getLastChild();
        return aLastChildAfterIf.getType() == 92;
    }

    private static boolean isSequentialIf(DetailAST aIf) {
        DetailAST aLastChildAfterIf = aIf.getLastChild();
        boolean isSequentialIf = aLastChildAfterIf.getFirstChild().getType() == 83;
        return isSequentialIf;
    }

    private static boolean isInnerIf(DetailAST aIf) {
        DetailAST aChildIf = aIf.getFirstChild().getNextSibling().getNextSibling().getNextSibling();
        return aChildIf.branchContains(83);
    }

    private static boolean isElseWithThrow(DetailAST aIf) {
        DetailAST aLastChildAfterIf = aIf.getLastChild();
        return aLastChildAfterIf.getFirstChild().branchContains(90);
    }

    private static boolean isRatioBetweenIfAndElseBlockSuitable(DetailAST aIf) {
        boolean result = true;
        DetailAST aLastChildAfterIf = aIf.getLastChild();
        int linesOfCodeInIfBlock = ConfusingConditionCheck.getAmounOfCodeRowsInBlock(aIf);
        int linesOfCodeInElseBlock = ConfusingConditionCheck.getAmounOfCodeRowsInBlock(aLastChildAfterIf);
        if (linesOfCodeInElseBlock > 0) {
            result = linesOfCodeInIfBlock / linesOfCodeInElseBlock < multiplyFactorForElseBlocks;
        }
        return result;
    }

    private static int getAmounOfCodeRowsInBlock(DetailAST aDetailAST) {
        DetailAST firstBrace = null;
        if (aDetailAST.getType() == 92) {
            firstBrace = aDetailAST.getFirstChild();
        } else if (aDetailAST.getType() == 83) {
            firstBrace = aDetailAST.getFirstChild().getNextSibling().getNextSibling().getNextSibling();
        }
        DetailAST lastBrace = firstBrace.getLastChild();
        int linesOfCodeInIfBlock = lastBrace.getLineNo() - firstBrace.getLineNo();
        if (lastBrace.getLineNo() != lastBrace.getParent().getLineNo()) {
            --linesOfCodeInIfBlock;
        }
        return linesOfCodeInIfBlock;
    }

    private static boolean isConditionAllNegative(DetailAST aIf) {
        int countOfLor;
        int countOfLand;
        int countOfComparisonOperators;
        int countOfNotequal;
        boolean result = false;
        DetailAST aIfExpr = aIf.getFirstChild().getNextSibling();
        int countOfLnot = ConfusingConditionCheck.getCountOfToken(aIfExpr, 132);
        int countOfNegativeSymbolInIf = countOfLnot + (countOfNotequal = ConfusingConditionCheck.getCountOfToken(aIfExpr, 115));
        if (countOfNegativeSymbolInIf > 0 && countOfNegativeSymbolInIf - (countOfComparisonOperators = (countOfLand = ConfusingConditionCheck.getCountOfToken(aIfExpr, 111)) + (countOfLor = ConfusingConditionCheck.getCountOfToken(aIfExpr, 110))) == 1) {
            result = true;
        }
        return result;
    }

    private static boolean isIfWithNull(DetailAST aIf) {
        return aIf.getFirstChild().getNextSibling().branchContains(135);
    }

    private static int getCountOfToken(DetailAST detAst, int atype) {
        int count = 0;
        if (detAst.branchContains(atype)) {
            while (detAst != null) {
                count += detAst.getChildCount(atype);
                DetailAST detAstChild = detAst.getFirstChild();
                if (detAstChild == null) {
                    detAst = detAst.getNextSibling();
                    continue;
                }
                count += ConfusingConditionCheck.getCountOfToken(detAstChild, atype);
                detAst = detAst.getNextSibling();
            }
        }
        return count;
    }
}

