/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvoidModifiersForTypesCheck
extends Check {
    private static final String WARNING_MSG_KEY = "avoid.modifiers.for.types";
    private Pattern mForbiddenClassesRegexpFinal = Pattern.compile("");
    private Pattern mForbiddenClassesRegexpStatic = Pattern.compile("ULC.+");
    private Pattern mForbiddenClassesRegexpTransient = Pattern.compile("");
    private Pattern mForbiddenClassesRegexpVolatile = Pattern.compile("");

    public void setForbiddenClassesRegexpStatic(String aForbiddenClassesRegexpStatic) {
        String regexp = aForbiddenClassesRegexpStatic == null ? "" : aForbiddenClassesRegexpStatic;
        this.mForbiddenClassesRegexpStatic = Pattern.compile(regexp);
    }

    public void setForbiddenClassesRegexpFinal(String aForbiddenClassesRegexpFinal) {
        String regexp = aForbiddenClassesRegexpFinal == null ? "" : aForbiddenClassesRegexpFinal;
        this.mForbiddenClassesRegexpFinal = Pattern.compile(regexp);
    }

    public void setForbiddenClassesRegexpTransient(String aForbiddenClassesRegexpTransient) {
        String regexp = aForbiddenClassesRegexpTransient == null ? "" : aForbiddenClassesRegexpTransient;
        this.mForbiddenClassesRegexpTransient = Pattern.compile(regexp);
    }

    public void setForbiddenClassesRegexpVolatile(String aForbiddenClassesRegexpVolatile) {
        String regexp = aForbiddenClassesRegexpVolatile == null ? "" : aForbiddenClassesRegexpVolatile;
        this.mForbiddenClassesRegexpVolatile = Pattern.compile(regexp);
    }

    public int[] getDefaultTokens() {
        return new int[]{10};
    }

    public void visitToken(DetailAST aAst) {
        String classNameAndPath = AvoidModifiersForTypesCheck.getClassNameAndPath(aAst);
        if (classNameAndPath != null) {
            String className = AvoidModifiersForTypesCheck.getClassName(classNameAndPath);
            for (int modifierType : AvoidModifiersForTypesCheck.getModifiers(aAst)) {
                switch (modifierType) {
                    case 64: {
                        if (!this.mForbiddenClassesRegexpStatic.matcher(className).matches()) break;
                        this.log(aAst, WARNING_MSG_KEY, new Object[]{className, "static"});
                        break;
                    }
                    case 39: {
                        if (!this.mForbiddenClassesRegexpFinal.matcher(className).matches()) break;
                        this.log(aAst, WARNING_MSG_KEY, new Object[]{className, "final"});
                        break;
                    }
                    case 65: {
                        if (!this.mForbiddenClassesRegexpTransient.matcher(className).matches()) break;
                        this.log(aAst, WARNING_MSG_KEY, new Object[]{className, "transient"});
                        break;
                    }
                    case 68: {
                        if (!this.mForbiddenClassesRegexpVolatile.matcher(className).matches()) break;
                        this.log(aAst, WARNING_MSG_KEY, new Object[]{className, "volatile"});
                        break;
                    }
                }
            }
        }
    }

    private static String getClassNameAndPath(DetailAST aVariableDefNode) {
        String result = null;
        DetailAST type = aVariableDefNode.findFirstToken(13);
        DetailAST textWithoutDots = type.findFirstToken(58);
        if (textWithoutDots == null) {
            DetailAST parentDotAST = type.findFirstToken(59);
            if (parentDotAST != null) {
                FullIdent dottedPathIdent = FullIdent.createFullIdentBelow((DetailAST)parentDotAST);
                DetailAST nameAST = parentDotAST.getLastChild();
                result = dottedPathIdent.getText() + "." + nameAST.getText();
            }
        } else {
            result = textWithoutDots.getText();
        }
        return result;
    }

    private static String getClassName(String aClassNameAndPath) {
        return aClassNameAndPath.replaceAll(".+\\.", "");
    }

    private static List<Integer> getModifiers(DetailAST aVariableDefAst) {
        LinkedList<Integer> modifiersList = new LinkedList<Integer>();
        DetailAST modifiersAST = aVariableDefAst.findFirstToken(5);
        for (DetailAST modifier : AvoidModifiersForTypesCheck.getChildren(modifiersAST)) {
            modifiersList.add(modifier.getType());
        }
        return modifiersList;
    }

    private static List<DetailAST> getChildren(DetailAST aNode) {
        LinkedList<DetailAST> result = new LinkedList<DetailAST>();
        for (DetailAST curNode = aNode.getFirstChild(); curNode != null; curNode = curNode.getNextSibling()) {
            result.add(curNode);
        }
        return result;
    }
}

