/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import antlr.collections.AST;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvoidHidingCauseExceptionCheck
extends Check {
    public int[] getDefaultTokens() {
        return new int[]{96};
    }

    public void visitToken(DetailAST aDetailAST) {
        String originExcName = aDetailAST.findFirstToken(21).getLastChild().getText();
        LinkedList<DetailAST> throwList = this.makeThrowList(aDetailAST);
        LinkedList<String> wrapExcNames = new LinkedList<String>();
        wrapExcNames.add(originExcName);
        wrapExcNames.addAll(this.makeExceptionsList(aDetailAST, aDetailAST, originExcName));
        for (DetailAST throwAST : throwList) {
            if (throwAST.getType() != 90) continue;
            LinkedList<DetailAST> throwParamNamesList = new LinkedList<DetailAST>();
            this.getThrowParamNamesList(throwAST, throwParamNamesList);
            if (AvoidHidingCauseExceptionCheck.isContainsCaughtExc(throwParamNamesList, wrapExcNames)) continue;
            this.log(throwAST, "avoid.hiding.cause.exception", new Object[]{originExcName});
        }
    }

    private static boolean isContainsCaughtExc(List<DetailAST> aThrowParamNamesList, LinkedList<String> aWrapExcNames) {
        boolean result = false;
        for (DetailAST currentNode : aThrowParamNamesList) {
            if (currentNode == null || currentNode.getParent().getType() == 59 || !aWrapExcNames.contains(currentNode.getText())) continue;
            result = true;
            break;
        }
        return result;
    }

    private List<DetailAST> getThrowParamNamesList(DetailAST aStartNode, List<DetailAST> aParamNamesAST) {
        for (DetailAST currentNode : AvoidHidingCauseExceptionCheck.getChildNodes(aStartNode)) {
            if (currentNode.getType() == 58) {
                aParamNamesAST.add(currentNode);
            }
            if (currentNode.getType() == 21 || currentNode.getType() == 95 || currentNode.getNumberOfChildren() <= 0) continue;
            this.getThrowParamNamesList(currentNode, aParamNamesAST);
        }
        return aParamNamesAST;
    }

    private LinkedList<DetailAST> makeThrowList(DetailAST aParentAST) {
        LinkedList<DetailAST> throwList = new LinkedList<DetailAST>();
        for (DetailAST currentNode : AvoidHidingCauseExceptionCheck.getChildNodes(aParentAST)) {
            if (currentNode.getType() == 90) {
                throwList.add(currentNode);
            }
            if (currentNode.getType() == 21 || currentNode.getType() == 90 || currentNode.getType() == 95 || currentNode.getNumberOfChildren() <= 0) continue;
            throwList.addAll(this.makeThrowList(currentNode));
        }
        return throwList;
    }

    private LinkedList<String> makeExceptionsList(DetailAST aCurrentCatchAST, DetailAST aParentAST, String aCurrentExcName) {
        LinkedList<String> wrapExcNames = new LinkedList<String>();
        for (DetailAST currentNode : AvoidHidingCauseExceptionCheck.getChildNodes(aParentAST)) {
            if (currentNode.getType() == 58 && currentNode.getText().equals(aCurrentExcName) && currentNode.getParent() != null && currentNode.getParent().getType() != 59) {
                DetailAST temp = currentNode;
                while (!temp.equals((AST)aCurrentCatchAST) && temp.getType() != 80) {
                    temp = temp.getParent();
                }
                if (temp.getType() == 80) {
                    DetailAST convertedExc = null;
                    convertedExc = temp.getParent().getType() == 10 ? temp.getParent().findFirstToken(58) : temp.findFirstToken(58);
                    if (convertedExc != null && !convertedExc.getText().equals(aCurrentExcName) && !wrapExcNames.contains(convertedExc.getText())) {
                        wrapExcNames.add(convertedExc.getText());
                    }
                }
            }
            if (currentNode.getType() == 21 || currentNode.getNumberOfChildren() <= 0) continue;
            wrapExcNames.addAll(this.makeExceptionsList(aCurrentCatchAST, currentNode, aCurrentExcName));
        }
        return wrapExcNames;
    }

    private static LinkedList<DetailAST> getChildNodes(DetailAST aNode) {
        LinkedList<DetailAST> result = new LinkedList<DetailAST>();
        for (DetailAST currNode = aNode.getFirstChild(); currNode != null; currNode = currNode.getNextSibling()) {
            result.add(currNode);
        }
        return result;
    }
}

