/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Iterator;

public class AvoidDefaultSerializableInInnerClasses
extends Check {
    private boolean mAllowPartialImplementation;

    public void setAllowPartialImplementation(boolean aAllow) {
        this.mAllowPartialImplementation = aAllow;
    }

    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    public void visitToken(DetailAST aDetailAST) {
        boolean topLevelClass;
        boolean bl = topLevelClass = aDetailAST.getParent() == null;
        if (!topLevelClass && AvoidDefaultSerializableInInnerClasses.isSerializable(aDetailAST) && !AvoidDefaultSerializableInInnerClasses.isStatic(aDetailAST) && !this.hasSerialazableMethods(aDetailAST)) {
            DetailAST implementsBlock = aDetailAST.findFirstToken(19);
            this.log(implementsBlock.getLineNo(), "avoid.default.serializable.in.inner.classes", new Object[0]);
        }
    }

    private static boolean isStatic(DetailAST aClassNode) {
        boolean result = false;
        DetailAST modifiers = aClassNode.findFirstToken(5);
        if (modifiers != null) {
            for (modifiers = modifiers.getFirstChild(); !result && modifiers != null; modifiers = modifiers.getNextSibling()) {
                result = "static".equals(modifiers.getText());
            }
        }
        return result;
    }

    private boolean hasSerialazableMethods(DetailAST aClassNode) {
        DetailAST objectBody = aClassNode.findFirstToken(6);
        int numberOfSerializationMethods = 0;
        ChildrenIterator methodsIter = ChildrenIterator.methodsIterator(objectBody);
        while (methodsIter.hasNext()) {
            DetailAST methodNode = (DetailAST)methodsIter.next();
            if (AvoidDefaultSerializableInInnerClasses.isPrivateMethod(methodNode) && AvoidDefaultSerializableInInnerClasses.isVoidMethod(methodNode) && (AvoidDefaultSerializableInInnerClasses.hasCorrectParameter(methodNode, "ObjectInputStream") || AvoidDefaultSerializableInInnerClasses.hasCorrectParameter(methodNode, "ObjectOutputStream"))) {
                ++numberOfSerializationMethods;
            }
            if ((numberOfSerializationMethods != 1 || !this.mAllowPartialImplementation) && numberOfSerializationMethods != 2) continue;
            return true;
        }
        return false;
    }

    private static boolean isPrivateMethod(DetailAST aMethodNode) {
        DetailAST modifiers = aMethodNode.findFirstToken(5);
        boolean isPrivate = false;
        for (modifiers = modifiers.getFirstChild(); !isPrivate && modifiers != null; modifiers = modifiers.getNextSibling()) {
            isPrivate = "private".equals(modifiers.getText());
        }
        return isPrivate;
    }

    private static boolean isVoidMethod(DetailAST aMethodNode) {
        DetailAST type = aMethodNode.findFirstToken(13);
        return 49 == (type = type.getFirstChild()).getType();
    }

    private static boolean hasCorrectParameter(DetailAST aMethodNode, String aParameterText) {
        DetailAST parameters = aMethodNode.findFirstToken(20);
        boolean result = false;
        if (parameters.getChildCount(21) == 1) {
            parameters = parameters.findFirstToken(21);
            parameters = parameters.findFirstToken(13);
            parameters = parameters.getFirstChild();
            result = aParameterText.equals(parameters.getText());
        }
        return result;
    }

    private static boolean isSerializable(DetailAST aClassDefNode) {
        DetailAST implementationsDef = aClassDefNode.findFirstToken(19);
        boolean result = false;
        if (implementationsDef != null) {
            for (implementationsDef = implementationsDef.getFirstChild(); !result && implementationsDef != null; implementationsDef = implementationsDef.getNextSibling()) {
                if (implementationsDef.getType() == 59) {
                    implementationsDef = implementationsDef.getLastChild();
                }
                result = "Serializable".equals(implementationsDef.getText());
            }
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChildrenIterator
    implements Iterator<DetailAST> {
        private final int mChildType;
        private DetailAST mNext;

        public ChildrenIterator(DetailAST aParent, int aChildType) {
            this.mChildType = aChildType;
            this.mNext = aParent.findFirstToken(aChildType);
        }

        public static ChildrenIterator methodsIterator(DetailAST aParent) {
            return new ChildrenIterator(aParent, 9);
        }

        @Override
        public boolean hasNext() {
            return this.mNext != null;
        }

        @Override
        public DetailAST next() {
            DetailAST result = this.mNext;
            while (this.mNext != null) {
                this.mNext = this.mNext.getNextSibling();
                if (this.mNext == null || this.mNext.getType() != this.mChildType) continue;
                break;
            }
            return result;
        }

        @Override
        public void remove() {
            throw new IllegalStateException("Not implemented");
        }
    }
}

