/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.rename;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.ui.refactoring.util.BeansRefactoringChangeUtils;

public class RenameBeanIdRefsRefactoring
extends Refactoring {
    private final IMethod method;
    private final String newBeanId;
    private final String oldBeanId;

    public RenameBeanIdRefsRefactoring(IMethod method, String newBeanId) {
        this.method = method;
        this.newBeanId = newBeanId;
        this.oldBeanId = method.getElementName();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            monitor.beginTask("Creating change...", 1);
            CompositeChange compositeChange = new CompositeChange("Renaming Spring Bean id");
            IBeansProject beanProject = BeansCorePlugin.getModel().getProject(this.method.getResource().getProject());
            Set configs = beanProject.getConfigs();
            for (IBeansConfig config : configs) {
                IResource resource = config.getElementResource();
                if (!resource.isAccessible() || !(resource instanceof IFile)) continue;
                TextFileChange refsChange = BeansRefactoringChangeUtils.createRenameBeanRefsChange((IFile)((IFile)resource), (String)this.oldBeanId, (String)this.newBeanId, (IProgressMonitor)monitor);
                compositeChange.add((Change)refsChange);
            }
            CompositeChange compositeChange2 = compositeChange;
            return compositeChange2;
        }
        finally {
            monitor.done();
        }
    }

    public String getName() {
        return "Rename Bean";
    }
}

