/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.proposals;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLMultiPageEditorPart;
import org.springframework.ide.eclipse.config.core.IConfigEditor;
import org.springframework.ide.eclipse.quickfix.QuickfixUtils;
import org.springframework.ide.eclipse.quickfix.proposals.BeanAttributeQuickFixProposal;
import org.springframework.ide.eclipse.quickfix.proposals.QuickfixReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveDeprecatedQuickFixProposal
extends BeanAttributeQuickFixProposal
implements ICompletionProposal {
    private IMethod method;
    private final String className;
    private String methodName;
    private final ICompilationUnit cu;

    public RemoveDeprecatedQuickFixProposal(int offset, int length, boolean missingEndQuote, String className, IType type) {
        super(offset, length, missingEndQuote);
        this.className = className;
        this.cu = type.getCompilationUnit();
    }

    public RemoveDeprecatedQuickFixProposal(int offset, int length, boolean missingEndQuote, String className, String methodName, IMethod method) {
        super(offset, length, missingEndQuote);
        this.className = className;
        this.methodName = methodName;
        this.method = method;
        this.cu = method.getCompilationUnit();
    }

    @Override
    public void applyQuickFix(IDocument document) {
        BodyDeclaration decl = this.getDeclaration();
        this.removeDeprecatedAnnotation(document, this.cu, decl);
    }

    private Annotation findAnnotation(List modifiers) {
        int i = 0;
        while (i < modifiers.size()) {
            Annotation annot;
            ITypeBinding binding;
            Object curr = modifiers.get(i);
            if (curr instanceof Annotation && (binding = (annot = (Annotation)curr).getTypeName().resolveTypeBinding()) != null && "java.lang.Deprecated".equals(binding.getQualifiedName())) {
                return annot;
            }
            ++i;
        }
        return null;
    }

    private BodyDeclaration getDeclaration() {
        if (this.method != null) {
            return QuickfixUtils.getMethodDecl(this.method);
        }
        return QuickfixUtils.getTypeDecl(this.className, this.cu);
    }

    public String getDisplayString() {
        StringBuilder displayBuilder = new StringBuilder("Remove '@Deprecated' from ");
        displayBuilder.append(this.className);
        if (this.methodName != null) {
            displayBuilder.append(".");
            displayBuilder.append(this.methodName);
            displayBuilder.append("(..)");
        }
        return displayBuilder.toString();
    }

    public Image getImage() {
        return JavaPluginImages.get((String)"org.eclipse.jdt.ui.correction_change.gif");
    }

    private ITextViewer getViewer(IEditorPart editorPart) {
        if (editorPart instanceof IConfigEditor) {
            IConfigEditor configEditor = (IConfigEditor)editorPart;
            return configEditor.getTextViewer();
        }
        if (editorPart instanceof StructuredTextEditor) {
            return ((StructuredTextEditor)editorPart).getTextViewer();
        }
        if (editorPart instanceof XMLMultiPageEditorPart) {
            Object result = QuickfixReflectionUtils.callProtectedMethod(editorPart, "getTextEditor");
            return this.getViewer((IEditorPart)result);
        }
        if (editorPart instanceof JavaEditor) {
            return ((JavaEditor)editorPart).getViewer();
        }
        return null;
    }

    public void removeDeprecatedAnnotation(IDocument document, ICompilationUnit cu, BodyDeclaration decl) {
        Annotation annot = this.findAnnotation(decl.modifiers());
        if (annot != null) {
            ASTRewrite rewrite = ASTRewrite.create((AST)annot.getAST());
            rewrite.remove((ASTNode)annot, null);
            this.callASTRewriteCorrectionProposal(this.getDisplayString(), cu, rewrite, 6, this.getImage(), document);
            ITextViewer viewer = this.getViewer(JavaPlugin.getActivePage().getActiveEditor());
            ITrackedNodePosition trackPos = rewrite.track((ASTNode)decl);
            if (trackPos != null && viewer != null) {
                viewer.setSelectedRange(trackPos.getStartPosition(), 0);
            }
        }
    }

    private void callASTRewriteCorrectionProposal(String displayString, ICompilationUnit cu2, ASTRewrite rewrite, int i, Image image, IDocument document) {
        try {
            Class<?> astRewriteClass = this.getASTRewriteCorrectionProposalClass();
            Constructor<?> constructor = astRewriteClass.getConstructor(String.class, ICompilationUnit.class, ASTRewrite.class, Integer.TYPE, Image.class);
            Object astRewriteCorrectionProposal = constructor.newInstance(displayString, cu2, rewrite, i, image);
            Method applyMethod = astRewriteCorrectionProposal.getClass().getMethod("apply", IDocument.class);
            applyMethod.invoke(astRewriteCorrectionProposal, document);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Class<?> getASTRewriteCorrectionProposalClass() throws ClassNotFoundException {
        try {
            return this.getClass().getClassLoader().loadClass("org.eclipse.jdt.internal.ui.text.correction.proposals.ASTRewriteCorrectionProposal");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return this.getClass().getClassLoader().loadClass("org.eclipse.jdt.ui.text.java.correction.ASTRewriteCorrectionProposal");
        }
    }
}

