/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.jdt.proposals;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.springframework.ide.eclipse.quickfix.QuickfixImages;
import org.springframework.ide.eclipse.quickfix.jdt.proposals.MarkerResolutionProposal;
import org.springframework.ide.eclipse.quickfix.jdt.proposals.StringLiteralTrackedPosition;
import org.springframework.ide.eclipse.quickfix.jdt.util.ProposalCalculatorUtil;
import org.springframework.ide.eclipse.quickfix.jdt.util.UriTemplateVariable;
import org.springframework.web.bind.annotation.PathVariable;

public class AddPathVariableCompletionProposal
extends MarkerResolutionProposal {
    private final MethodDeclaration methodDecl;
    private final SingleVariableDeclaration param;
    private final UriTemplateVariable variable;

    public AddPathVariableCompletionProposal(UriTemplateVariable variable, SingleVariableDeclaration param, MethodDeclaration methodDecl, ICompilationUnit cu, boolean atTypeDecl) {
        super(AddPathVariableCompletionProposal.getDisplayName(variable, param, methodDecl, atTypeDecl), cu, QuickfixImages.getImage(QuickfixImages.ANNOTATION));
        this.variable = variable;
        this.param = param;
        this.methodDecl = methodDecl;
    }

    private static String getDisplayName(UriTemplateVariable variable, SingleVariableDeclaration param, MethodDeclaration methodDecl, boolean atTypeDecl) {
        StringBuilder result = new StringBuilder();
        result.append("Add @PathVariable(\"");
        result.append(variable.getVariableName());
        result.append("\") to ");
        result.append(param.getName().getFullyQualifiedName());
        if (atTypeDecl) {
            result.append(" to method ");
            result.append(methodDecl.getName().getFullyQualifiedName());
            result.append("(");
            List params = methodDecl.parameters();
            for (SingleVariableDeclaration p : params) {
                result.append(ProposalCalculatorUtil.getTypeName(p.getType()));
            }
            result.append(")");
        }
        return result.toString();
    }

    protected ASTRewrite getRewrite() throws CoreException {
        CompilationUnit astRoot = ASTResolving.findParentCompilationUnit((ASTNode)this.methodDecl);
        ASTRewrite astRewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRewrite.getAST();
        String importName = PathVariable.class.getCanonicalName();
        if (!ProposalCalculatorUtil.containsImport(this.getCompilationUnit(), importName)) {
            ImportRewrite importRewrite = this.createImportRewrite(astRoot);
            importRewrite.addImport(importName);
        }
        SingleMemberAnnotation annotation = ast.newSingleMemberAnnotation();
        annotation.setTypeName((Name)ast.newSimpleName("PathVariable"));
        StringLiteral pathVariableName = ast.newStringLiteral();
        pathVariableName.setLiteralValue(this.variable.getVariableName());
        annotation.setValue((Expression)pathVariableName);
        astRewrite.getListRewrite((ASTNode)this.param, SingleVariableDeclaration.MODIFIERS2_PROPERTY).insertFirst((ASTNode)annotation, null);
        final ITrackedNodePosition literalPosition = astRewrite.track(this.variable.getNode());
        this.addLinkedPosition(new ITrackedNodePosition(){

            public int getStartPosition() {
                return literalPosition.getStartPosition() + AddPathVariableCompletionProposal.this.variable.getOffsetFromNode();
            }

            public int getLength() {
                return AddPathVariableCompletionProposal.this.variable.getVariableName().length();
            }
        }, true, "PathVariable");
        this.addLinkedPosition(new StringLiteralTrackedPosition(astRewrite.track((ASTNode)pathVariableName)), false, "PathVariable");
        return astRewrite;
    }
}

