/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.jdt.proposals;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility2;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.osgi.util.NLS;
import org.springframework.ide.eclipse.quickfix.QuickfixImages;
import org.springframework.ide.eclipse.quickfix.jdt.proposals.AnnotationCompletionProposal;

public class AddAutowiredConstructorCompletionProposal
extends AnnotationCompletionProposal {
    private final TypeDeclaration typeDecl;
    private final ICompilationUnit compilationUnit;
    private final IVariableBinding[] variableBindings;

    public AddAutowiredConstructorCompletionProposal(TypeDeclaration typeDecl, ICompilationUnit cu, IVariableBinding[] myVariables) {
        super(NLS.bind((String)"Add {0} constructor", (Object)"@Autowired"), cu, QuickfixImages.getImage(QuickfixImages.ANNOTATION));
        this.typeDecl = typeDecl;
        this.compilationUnit = cu;
        this.variableBindings = myVariables;
    }

    protected ASTRewrite getRewrite() throws CoreException {
        CompilationUnit astRoot = ASTResolving.findParentCompilationUnit((ASTNode)this.typeDecl);
        AST ast = astRoot.getAST();
        ASTRewrite astRewrite = ASTRewrite.create((AST)ast);
        ImportRewrite importRewrite = StubUtility.createImportRewrite((CompilationUnit)astRoot, (boolean)true);
        ListRewrite listRewriter = astRewrite.getListRewrite((ASTNode)this.typeDecl, this.typeDecl.getBodyDeclarationsProperty());
        if (listRewriter != null) {
            IJavaProject javaProject = this.compilationUnit.getJavaProject();
            CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings((IJavaProject)javaProject);
            MethodDeclaration methodDecl = this.createNewConstructor(this.typeDecl, ast);
            IMethodBinding constructorBinding = ASTNodes.getMethodBinding((Name)methodDecl.getName());
            ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext((ASTNode)this.typeDecl, importRewrite);
            ITypeBinding typeBinding = ASTNodes.getTypeBinding((Name)this.typeDecl.getName());
            MethodDeclaration stub = StubUtility2.createConstructorStub((ICompilationUnit)this.compilationUnit, (ASTRewrite)astRewrite, (ImportRewrite)importRewrite, (ImportRewrite.ImportRewriteContext)context, (ITypeBinding)typeBinding, (IMethodBinding)constructorBinding, (IVariableBinding[])this.variableBindings, (int)1, (CodeGenerationSettings)settings);
            if (stub != null) {
                IType type = null;
                IType[] iTypeArray = this.compilationUnit.getAllTypes();
                int n = iTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IType type2 = iTypeArray[n2];
                    if (type2 instanceof IType) {
                        String typeName = this.typeDecl.getName().getFullyQualifiedName();
                        String type2Name = type2.getFullyQualifiedName();
                        if (type2Name.endsWith(typeName)) {
                            type = type2;
                            break;
                        }
                    }
                    ++n2;
                }
                if (type == null) {
                    return astRewrite;
                }
                IJavaElement[] fields = type.getChildren();
                IJavaElement firstField = fields.length == 0 ? null : fields[0];
                ASTNode insertion = StubUtility2.getNodeToInsertBefore((ListRewrite)listRewriter, (IJavaElement)firstField);
                if (insertion != null && insertion.getParent() == this.typeDecl) {
                    listRewriter.insertBefore((ASTNode)stub, insertion, null);
                } else {
                    listRewriter.insertLast((ASTNode)stub, null);
                }
                constructorBinding = ASTNodes.getMethodBinding((Name)stub.getName());
                this.addAutowiredAnnotation(javaProject, astRewrite, stub, constructorBinding);
            }
        }
        return astRewrite;
    }

    public void addAutowiredAnnotation(IJavaProject project, ASTRewrite rewrite, MethodDeclaration decl, IMethodBinding binding) {
        MarkerAnnotation marker = rewrite.getAST().newMarkerAnnotation();
        marker.setTypeName((Name)rewrite.getAST().newSimpleName("Autowired"));
        rewrite.getListRewrite((ASTNode)decl, MethodDeclaration.MODIFIERS2_PROPERTY).insertFirst((ASTNode)marker, null);
    }

    private MethodDeclaration createNewConstructor(TypeDeclaration typeDecl2, AST ast) {
        MethodDeclaration newConstructor = ast.newMethodDeclaration();
        newConstructor.setConstructor(true);
        newConstructor.setExtraDimensions(0);
        newConstructor.setJavadoc(null);
        int modifier = 1;
        newConstructor.modifiers().addAll(ASTNodeFactory.newModifiers((AST)ast, (int)modifier));
        newConstructor.setName(ast.newSimpleName(this.typeDecl.getName().toString()));
        return newConstructor;
    }
}

