/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.jdt.processors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.springframework.ide.eclipse.quickfix.jdt.processors.AbstractAnnotationQuickAssistProcessor;
import org.springframework.ide.eclipse.quickfix.jdt.proposals.AddResponseBodyCompletionProposal;
import org.springframework.ide.eclipse.quickfix.jdt.util.ProposalCalculatorUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseBodyAnnotationQuickAssistProcessor
extends AbstractAnnotationQuickAssistProcessor {
    @Override
    public String getAnnotationName() {
        return "ResponseBody";
    }

    @Override
    public boolean isQuickfixAvailable(FieldDeclaration fieldDecl, IInvocationContext context) {
        return false;
    }

    @Override
    public boolean isQuickfixAvailable(MethodDeclaration methodDecl, IInvocationContext context) {
        if (ProposalCalculatorUtil.hasAnnotation("RequestMapping", (ASTNode)methodDecl) && !ProposalCalculatorUtil.hasAnnotation("ResponseBody", (ASTNode)methodDecl)) {
            Type returnType = methodDecl.getReturnType2();
            return !returnType.isPrimitiveType() || !((PrimitiveType)returnType).getPrimitiveTypeCode().equals(PrimitiveType.VOID);
        }
        return false;
    }

    @Override
    public boolean isQuickfixAvailable(SingleVariableDeclaration param, IInvocationContext context) {
        return false;
    }

    @Override
    public boolean isQuickfixAvailable(TypeDeclaration typeDecl, IInvocationContext context) {
        return false;
    }

    @Override
    public List<IJavaCompletionProposal> getAssistsForMethod(MethodDeclaration methodDecl, SimpleName name, ICompilationUnit cu) {
        ArrayList<IJavaCompletionProposal> proposals = new ArrayList<IJavaCompletionProposal>();
        proposals.add((IJavaCompletionProposal)new AddResponseBodyCompletionProposal(methodDecl, cu));
        return proposals;
    }
}

