/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.jdt.processors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.springframework.ide.eclipse.quickfix.jdt.util.ProposalCalculatorUtil;
import org.springsource.ide.eclipse.commons.core.SpringCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnnotationQuickAssistProcessor {
    public abstract String getAnnotationName();

    protected TypeDeclaration getSurroundingTypeDecl(ASTNode node) {
        if (node == null || node instanceof TypeDeclaration) {
            return (TypeDeclaration)node;
        }
        return this.getSurroundingTypeDecl(node.getParent());
    }

    public boolean isQuickfixAvailable(FieldDeclaration fieldDecl, IInvocationContext context) {
        return !ProposalCalculatorUtil.hasAnnotation(this.getAnnotationName(), (ASTNode)fieldDecl);
    }

    public boolean isQuickfixAvailable(MethodDeclaration methodDecl, IInvocationContext context) {
        return !ProposalCalculatorUtil.hasAnnotation(this.getAnnotationName(), (ASTNode)methodDecl);
    }

    public boolean isQuickfixAvailable(SingleVariableDeclaration param, IInvocationContext context) {
        return !ProposalCalculatorUtil.hasAnnotation(this.getAnnotationName(), (ASTNode)param);
    }

    public boolean isQuickfixAvailable(TypeDeclaration typeDecl, IInvocationContext context) {
        return !ProposalCalculatorUtil.hasAnnotation(this.getAnnotationName(), (ASTNode)typeDecl);
    }

    public List<IJavaCompletionProposal> getAssistsForField(FieldDeclaration fieldDecl, SimpleName name, ICompilationUnit cu) {
        return new ArrayList<IJavaCompletionProposal>();
    }

    public List<IJavaCompletionProposal> getAssistsForMethod(MethodDeclaration methodDecl, SimpleName name, ICompilationUnit cu) {
        ArrayList<IJavaCompletionProposal> proposals = new ArrayList<IJavaCompletionProposal>();
        List params = methodDecl.parameters();
        for (SingleVariableDeclaration param : params) {
            proposals.addAll(this.getAssistsForMethodParam(param, param.getName(), cu));
        }
        return proposals;
    }

    public List<IJavaCompletionProposal> getAssistsForMethodParam(SingleVariableDeclaration param, SimpleName name, ICompilationUnit cu) {
        return new ArrayList<IJavaCompletionProposal>();
    }

    public List<IJavaCompletionProposal> getAssistsForType(TypeDeclaration typeDecl, SimpleName name, ICompilationUnit cu) {
        return new ArrayList<IJavaCompletionProposal>();
    }

    private ASTNode getSurroundingDecl(ASTNode node) {
        SingleVariableDeclaration decl;
        if (node == null || node instanceof BodyDeclaration) {
            return node;
        }
        if (node instanceof SingleVariableDeclaration && (decl = (SingleVariableDeclaration)node).getParent() instanceof MethodDeclaration) {
            return decl;
        }
        return this.getSurroundingDecl(node.getParent());
    }

    private Block getSurroundingBlock(ASTNode node) {
        if (node == null || node instanceof Block) {
            return (Block)node;
        }
        return this.getSurroundingBlock(node.getParent());
    }

    private VariableDeclarationFragment getSurroundingFragment(ASTNode node) {
        if (node == null || node instanceof VariableDeclarationFragment) {
            return (VariableDeclarationFragment)node;
        }
        return this.getSurroundingFragment(node.getParent());
    }

    public final List<IJavaCompletionProposal> getAssists(ASTNode coveringNode, IInvocationContext context) {
        if (!this.isSpringProject(context)) {
            return new ArrayList<IJavaCompletionProposal>();
        }
        ASTNode decl = this.getSurroundingDecl(coveringNode);
        if (decl != null) {
            if (decl instanceof FieldDeclaration) {
                FieldDeclaration fieldDecl = (FieldDeclaration)decl;
                VariableDeclarationFragment coveringFragment = this.getSurroundingFragment(coveringNode);
                if (coveringFragment != null) {
                    return this.checkAndReturnAssists(fieldDecl, coveringFragment.getName(), context);
                }
                List fragments = fieldDecl.fragments();
                ArrayList<IJavaCompletionProposal> proposals = new ArrayList<IJavaCompletionProposal>();
                for (VariableDeclarationFragment fragment : fragments) {
                    SimpleName name = fragment.getName();
                    proposals.addAll(this.checkAndReturnAssists(fieldDecl, name, context));
                }
                return proposals;
            }
            if (decl instanceof SingleVariableDeclaration) {
                SingleVariableDeclaration varDecl = (SingleVariableDeclaration)decl;
                return this.checkAndReturnAssists(varDecl, varDecl.getName(), context);
            }
            if (decl instanceof MethodDeclaration) {
                MethodDeclaration methodDecl = (MethodDeclaration)decl;
                Block body = methodDecl.getBody();
                if (this.getSurroundingBlock(coveringNode) != body) {
                    return this.checkAndReturnAssists(methodDecl, methodDecl.getName(), context);
                }
            } else if (decl instanceof TypeDeclaration && this.getSurroundingDecl(coveringNode) instanceof TypeDeclaration) {
                TypeDeclaration typeDecl = (TypeDeclaration)decl;
                return this.checkAndReturnAssists(typeDecl, typeDecl.getName(), context);
            }
        }
        return new ArrayList<IJavaCompletionProposal>();
    }

    private boolean isSpringProject(IInvocationContext context) {
        IJavaProject javaProject = context.getCompilationUnit().getJavaProject();
        return SpringCoreUtils.isSpringProject((IResource)javaProject.getProject());
    }

    private List<IJavaCompletionProposal> checkAndReturnAssists(FieldDeclaration fieldDecl, SimpleName name, IInvocationContext context) {
        this.setUpFields();
        if (this.isQuickfixAvailable(fieldDecl, context)) {
            return this.getAssistsForField(fieldDecl, name, context.getCompilationUnit());
        }
        return new ArrayList<IJavaCompletionProposal>();
    }

    private List<IJavaCompletionProposal> checkAndReturnAssists(MethodDeclaration methodDecl, SimpleName name, IInvocationContext context) {
        this.setUpFields();
        if (this.isQuickfixAvailable(methodDecl, context)) {
            return this.getAssistsForMethod(methodDecl, name, context.getCompilationUnit());
        }
        return new ArrayList<IJavaCompletionProposal>();
    }

    private List<IJavaCompletionProposal> checkAndReturnAssists(SingleVariableDeclaration param, SimpleName name, IInvocationContext context) {
        this.setUpFields();
        if (this.isQuickfixAvailable(param, context)) {
            return this.getAssistsForMethodParam(param, name, context.getCompilationUnit());
        }
        return new ArrayList<IJavaCompletionProposal>();
    }

    private List<IJavaCompletionProposal> checkAndReturnAssists(TypeDeclaration typeDecl, SimpleName name, IInvocationContext context) {
        this.setUpFields();
        if (this.isQuickfixAvailable(typeDecl, context)) {
            return this.getAssistsForType(typeDecl, name, context.getCompilationUnit());
        }
        return new ArrayList<IJavaCompletionProposal>();
    }

    protected void setUpFields() {
    }
}

