/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.jdt.computers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.internal.core.SourceRefElement;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.ui.text.correction.AssistContext;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.ui.model.BeansModelImages;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.quickfix.jdt.computers.AnnotationProposalComputer;
import org.springframework.ide.eclipse.quickfix.jdt.computers.LocationInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationLocationProposalComputer
extends AnnotationProposalComputer {
    final String ILLEGAL_STRING = ":!\t)";
    private static final int LINE_LOCATIONS_POSITION = 1;
    private static final int LINE_LEADING_BRACE_PATTERN_POSITION = 2;
    private static final int LINE_WHITESPACE1_PATTERN_POSITION = 3;
    private static final int LINE_CONFIG_FILEPATHS_PATTERN_POSITION = 4;
    private static final int LINE_CONFIG_LAST_FILEPATH_WITH_DELIMITING_SPACE_PATTERN_POSITION = 5;
    private static final int LINE_CONFIG_LAST_FILEPATH_PATTERN_POSITION = 6;
    private static final int LINE_CONFIG_FILEPATH_NO_SPACES_PATTERN_POSITION = 7;
    private static final int LINE_CONFIG_FILEPATH_SPACES_PATTERN_POSITION = 8;
    private static final int LINE_COMMA_POSITION = 9;
    private static final int LINE_WHITESPACE2_PATTERN_POSITION = 10;
    private static final int LINE_CLOSING_BRACE_PATTERN_POSITION = 11;
    private static final int LINE_WHITESPACE3_PATTERN_POSITION = 12;
    private static final int LINE_CLOSING_PAREN_PATTERN_POSITION = 13;
    private static final int CONFIG_AT_END = -1;
    private static final int CONFIG_WHITESPACE1_PATTERN_POSITION = 1;
    private static final int CONFIG_OPENING_QUOTE_PATTERN_POSITION = 2;
    private static final int CONFIG_UNQUOTED_FILENAME_PATTERN_POSITION = 3;
    private static final int CONFIG_TYPE_PREFIXES = 4;
    private static final int CONFIG_CLOSING_QUOTE_PATTERN_POSITION = 5;
    private static final int CONFIG_WHITESPACE2_PATTERN_POSITION = 6;
    private static final int CONFIG_COMMA_PATTERN_POSITION = 7;
    private static final int CONFIG_WHITESPACE3_PATTERN_POSITION = 8;

    private List<String> getPathPrefixes(IJavaProject project) {
        ArrayList<String> pathPrefixes = new ArrayList<String>();
        try {
            IClasspathEntry[] iClasspathEntryArray = project.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 3) {
                    pathPrefixes.add(String.valueOf(entry.getPath().removeFirstSegments(1).toOSString()) + "/");
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {}
        return pathPrefixes;
    }

    @Override
    protected List<ICompletionProposal> computeCompletionProposals(SourceType type, String value, IAnnotation a, JavaContentAssistInvocationContext javaContext) throws JavaModelException {
        ITextViewer viewer = javaContext.getViewer();
        if (viewer instanceof SourceViewer) {
            int invocationOffset;
            SourceViewer sourceViewer;
            ICompilationUnit cu = javaContext.getCompilationUnit();
            AssistContext assistContext = new AssistContext(cu, (ISourceViewer)(sourceViewer = (SourceViewer)javaContext.getViewer()), invocationOffset = javaContext.getInvocationOffset(), 0);
            ASTNode node = ((SourceRefElement)a).findNode(assistContext.getASTRoot());
            if (node == null) {
                node = assistContext.getCoveredNode();
            }
            if (!(a instanceof Annotation)) {
                return Collections.emptyList();
            }
            Annotation annotation = (Annotation)a;
            LocationInformation locationInfo = null;
            if (node instanceof NormalAnnotation) {
                NormalAnnotation normalAnnotation = (NormalAnnotation)node;
                List pairs = normalAnnotation.values();
                for (MemberValuePair pair : pairs) {
                    Expression expression = pair.getValue();
                    if (!(expression instanceof StringLiteral)) continue;
                    locationInfo = this.getLocationInformation((StringLiteral)expression, javaContext);
                }
            } else if (node instanceof SingleMemberAnnotation) {
                SingleMemberAnnotation singleMemberAnnotation = (SingleMemberAnnotation)node;
                Expression expression = singleMemberAnnotation.getValue();
                locationInfo = this.getLocationInformation((StringLiteral)expression, javaContext);
            }
            if (locationInfo == null) {
                return Collections.emptyList();
            }
            Name typeName = annotation.getTypeName();
            return this.getBeanProposals((ContentAssistInvocationContext)javaContext, type.getCompilationUnit(), javaContext.getInvocationOffset(), typeName.getFullyQualifiedName(), typeName.getStartPosition(), typeName.getLength());
        }
        return Collections.emptyList();
    }

    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        if (context instanceof JavaContentAssistInvocationContext) {
            JavaContentAssistInvocationContext javaContext = (JavaContentAssistInvocationContext)context;
            ICompilationUnit cu = javaContext.getCompilationUnit();
            try {
                int invocationOffset = context.getInvocationOffset();
                IJavaElement element = cu.getElementAt(invocationOffset);
                if (element instanceof IType) {
                    IAnnotation[] annotations;
                    IType type = (IType)element;
                    IAnnotation[] iAnnotationArray = annotations = type.getAnnotations();
                    int n = annotations.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IAnnotation annotation = iAnnotationArray[n2];
                        if ("ContextConfiguration".equals(annotation.getElementName())) {
                            IMemberValuePair[] memberValuePairs;
                            IMemberValuePair[] iMemberValuePairArray = memberValuePairs = annotation.getMemberValuePairs();
                            int n3 = memberValuePairs.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IMemberValuePair memberValuePair = iMemberValuePairArray[n4];
                                if ("locations".equals(memberValuePair.getMemberName()) || "value".equals(memberValuePair.getMemberName())) {
                                    return this.getBeanProposals(context, cu, invocationOffset, this.getAnnotationText(annotation, context.getViewer(), invocationOffset), annotation.getNameRange().getOffset(), annotation.getNameRange().getLength());
                                }
                                ++n4;
                            }
                        }
                        ++n2;
                    }
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return new ArrayList<ICompletionProposal>();
    }

    private List<ICompletionProposal> getBeanProposals(ContentAssistInvocationContext context, ICompilationUnit cu, int invocationOffset, String annotationText, int annotationOffset, int annotationLength) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        String prefix = "";
        String postfix = "";
        String filter = "";
        ProposalAssemblyInformation assemblyInfo = this.createProposalAssemblyInformation(annotationText, invocationOffset - annotationOffset - annotationLength);
        prefix = assemblyInfo.getPrefix();
        postfix = assemblyInfo.getPostfix();
        filter = assemblyInfo.getFilter();
        IBeansProject beansProject = BeansCorePlugin.getModel().getProject(cu.getJavaProject().getProject());
        List<String> classpathPrefixes = this.getPathPrefixes(cu.getJavaProject());
        if (beansProject != null) {
            Set configs = beansProject.getConfigs();
            String resourceTypePrefix = "";
            if (filter.startsWith("file:")) {
                resourceTypePrefix = "file:";
                filter = filter.replaceFirst(resourceTypePrefix, "");
            } else if (filter.startsWith("classpath:")) {
                resourceTypePrefix = "classpath:";
                filter = filter.replaceFirst(resourceTypePrefix, "");
            }
            for (IBeansConfig config : configs) {
                String fullConfigFilePathname;
                String displayText = "";
                String replacementText = "";
                String strippedConfigPath = fullConfigFilePathname = config.getElementName();
                String basename = config.getElementResource().getName();
                boolean isOnClasspath = false;
                boolean matchesFilter = false;
                for (String classpathPrefix : classpathPrefixes) {
                    if (!fullConfigFilePathname.startsWith(classpathPrefix)) continue;
                    isOnClasspath = true;
                    strippedConfigPath = fullConfigFilePathname.substring(classpathPrefix.length());
                    if (resourceTypePrefix.equals("classpath:")) {
                        replacementText = strippedConfigPath;
                        break;
                    }
                    replacementText = "classpath:" + strippedConfigPath;
                    break;
                }
                if (isOnClasspath && resourceTypePrefix.equals("file:") || !isOnClasspath && resourceTypePrefix.equals("classpath:")) continue;
                if (!isOnClasspath) {
                    replacementText = resourceTypePrefix.equals("file:") ? fullConfigFilePathname : "file:" + fullConfigFilePathname;
                }
                if (fullConfigFilePathname.length() > 0) {
                    if (isOnClasspath && strippedConfigPath.startsWith(filter)) {
                        displayText = strippedConfigPath;
                        matchesFilter = true;
                    } else if (fullConfigFilePathname.startsWith(filter)) {
                        displayText = fullConfigFilePathname;
                        matchesFilter = true;
                    } else if (basename.startsWith(filter)) {
                        displayText = basename;
                        matchesFilter = true;
                    }
                }
                replacementText = String.valueOf(prefix) + replacementText + postfix;
                if (!matchesFilter) continue;
                proposals.add((ICompletionProposal)new JavaCompletionProposal(replacementText, invocationOffset - filter.length(), filter.length(), BeansModelImages.getImage((IModelElement)config), displayText, 0));
            }
        }
        return proposals;
    }

    public static Pattern getLineCompiledPattern() {
        String locations = "(locations|value)\\s*=\\s*";
        String optionalLeadingBrace = "(\\{?)";
        String oneFileNameAllowingSpaces = "([\"'][^\"']*[\"'])";
        String oneFileNameDisallowingSpaces = "(['\"][^\\s\"'\\)\\}]*[\"']?)";
        String oneFileName = "(" + oneFileNameAllowingSpaces + "|" + oneFileNameDisallowingSpaces + ")";
        String configurationFiles = "((" + oneFileName + "\\s*(,?)\\s*)*)";
        String optionalClosingBrace = "(\\}?)";
        String optionalClosingParen = "(\\)?)";
        String whitespace = "(\\s*)";
        String validCompletion = String.valueOf(locations) + optionalLeadingBrace + whitespace + configurationFiles + whitespace + optionalClosingBrace + whitespace + optionalClosingParen;
        return Pattern.compile(validCompletion);
    }

    private int invocationOffsetIsInWhichGroupNumber(Matcher matcher, int invocationIndex) {
        int groupIndex = 1;
        while (groupIndex <= matcher.groupCount()) {
            if (invocationIndex < matcher.start(groupIndex)) {
                return -1;
            }
            try {
                if (invocationIndex >= matcher.start(groupIndex) && invocationIndex <= matcher.end(groupIndex)) {
                    return groupIndex;
                }
            }
            catch (IllegalStateException illegalStateException) {}
            ++groupIndex;
        }
        return -1;
    }

    private boolean hasSomethingInField(Matcher matcher, int patternPosition) {
        return matcher.start(patternPosition) != matcher.end(patternPosition);
    }

    private ProposalAssemblyInformation createProposalAssemblyInformation(String annotationText, int invocationIndex) {
        String prefix = "";
        String postfix = "";
        String filter = "";
        Matcher matcher = ConfigurationLocationProposalComputer.getLineCompiledPattern().matcher(annotationText);
        if (matcher.find()) {
            boolean hasOpeningBrace = this.hasSomethingInField(matcher, 2);
            boolean hasOtherConfigFiles = this.hasSomethingInField(matcher, 4);
            boolean hasComma = this.hasSomethingInField(matcher, 9);
            boolean hasClosingBrace = this.hasSomethingInField(matcher, 11);
            int groupIndex = this.invocationOffsetIsInWhichGroupNumber(matcher, invocationIndex);
            if (groupIndex < 0) {
                if (invocationIndex >= annotationText.length()) {
                    String comma = "";
                    if (hasOtherConfigFiles && !hasComma) {
                        comma = ",";
                    }
                    prefix = String.valueOf(comma) + "\"";
                    if (hasClosingBrace) {
                        postfix = "";
                        filter = ":!\t)";
                    } else {
                        filter = "";
                        postfix = "\"";
                    }
                    return new ProposalAssemblyInformation(prefix, postfix, filter);
                }
                prefix = "";
                postfix = "";
                filter = ":!\t)";
                return new ProposalAssemblyInformation(prefix, postfix, filter);
            }
            filter = "";
            switch (groupIndex) {
                case 2: {
                    String closingBrace = "";
                    if (!hasOpeningBrace) {
                        prefix = "{\"";
                        closingBrace = "}";
                    } else {
                        prefix = "\"";
                    }
                    if (hasOtherConfigFiles) {
                        postfix = "\", " + closingBrace;
                        break;
                    }
                    postfix = "\"" + closingBrace;
                    break;
                }
                case 3: {
                    prefix = "\"";
                    if (hasOtherConfigFiles) {
                        postfix = "\", ";
                        break;
                    }
                    postfix = "\"";
                    break;
                }
                case 4: {
                    String fileString = this.substringOfGroup(annotationText, matcher, 4);
                    if (fileString.length() == 0) {
                        prefix = "";
                        postfix = "";
                        break;
                    }
                    int newInvocationIndex = invocationIndex - matcher.end(groupIndex - 1);
                    ProposalAssemblyInformation configAssemblyInfo = this.proposalAssemblyInfoFromConfigFiles(fileString, newInvocationIndex, hasClosingBrace);
                    return configAssemblyInfo;
                }
                case 10: {
                    prefix = "\"";
                    postfix = "\"";
                    break;
                }
                case 11: 
                case 12: {
                    prefix = "\"";
                    if (!hasClosingBrace) {
                        postfix = "\"}";
                    }
                    filter = ":!\t)";
                    break;
                }
                case 13: {
                    prefix = "";
                    postfix = "";
                    filter = ":!\t)";
                }
            }
            ProposalAssemblyInformation assemblyInfo = new ProposalAssemblyInformation(prefix, postfix, filter);
            return assemblyInfo;
        }
        return new ProposalAssemblyInformation("", "", "");
    }

    private String substringOfGroup(String annotationText, Matcher matcher, int groupIndex) {
        int startLocation = matcher.start(groupIndex);
        int endLocation = matcher.end(groupIndex);
        return annotationText.substring(startLocation, endLocation);
    }

    private ProposalAssemblyInformation proposalAssemblyInfoFromConfigFiles(String fileString, int invocationIndex, boolean hasClosingBrace) {
        String postfix = "";
        String prefix = "";
        String filter = "";
        Pattern filePattern = ConfigurationLocationProposalComputer.getConfigFileCompiledPattern();
        Matcher fileMatcher = filePattern.matcher(fileString);
        int fileGroupIndex = 1;
        while (fileMatcher.find()) {
            if (invocationIndex >= fileMatcher.start() && invocationIndex <= fileMatcher.end()) {
                int fileSubgroupIndex = this.invocationOffsetIsInWhichGroupNumber(fileMatcher, invocationIndex);
                boolean hasClosingQuote = this.hasSomethingInField(fileMatcher, 5);
                boolean hasComma = this.hasSomethingInField(fileMatcher, 7);
                boolean hasFilePattern = this.hasSomethingInField(fileMatcher, 3) || this.hasSomethingInField(fileMatcher, 5);
                String comma = "";
                if (fileGroupIndex > 1 && !hasComma) {
                    comma = ", ";
                }
                switch (fileSubgroupIndex) {
                    case -1: {
                        prefix = String.valueOf(comma) + "\"";
                        postfix = "\" ,";
                        if (fileGroupIndex != fileMatcher.groupCount()) break;
                        return new ProposalAssemblyInformation(prefix, postfix, filter);
                    }
                    case 8: {
                        postfix = "\"";
                        prefix = "\"";
                        return new ProposalAssemblyInformation(prefix, postfix, filter);
                    }
                    case 1: {
                        prefix = "\"";
                        postfix = String.valueOf(comma) + "\"";
                        return new ProposalAssemblyInformation(prefix, postfix, filter);
                    }
                    case 6: {
                        boolean areThereMoreFiles = hasFilePattern;
                        prefix = areThereMoreFiles ? ", \"" : "\"";
                        postfix = "\"" + comma;
                        return new ProposalAssemblyInformation(prefix, postfix, filter);
                    }
                    case 7: {
                        prefix = "\"";
                        postfix = "\"";
                        return new ProposalAssemblyInformation(prefix, postfix, filter);
                    }
                    case 2: {
                        prefix = "";
                        postfix = !hasClosingQuote && hasClosingBrace ? "\"" : "";
                        return new ProposalAssemblyInformation(prefix, postfix, filter);
                    }
                    case 3: {
                        prefix = "";
                        postfix = hasClosingQuote ? "" : "\"";
                        filter = fileMatcher.group(3);
                        return new ProposalAssemblyInformation(prefix, postfix, filter);
                    }
                    case 5: {
                        prefix = ", \"";
                        postfix = "\"";
                        filter = "";
                        return new ProposalAssemblyInformation(prefix, postfix, filter);
                    }
                }
            }
            ++fileGroupIndex;
        }
        return new ProposalAssemblyInformation("", "", "");
    }

    public static Pattern getConfigFileCompiledPattern() {
        String whitespace = "(\\s*)";
        String openingQuotePatternString = "(\"?)";
        String allowedResourceTypePrefixes = "(file:|classpath:)?";
        String unquotedFileNamePatternString = "(" + allowedResourceTypePrefixes + "[\\w\\.\\-\\/]*)";
        String closingQuotePatternString = "(\"?)";
        String commaPatternString = "(,?)";
        String filePatternString = String.valueOf(whitespace) + openingQuotePatternString + unquotedFileNamePatternString + closingQuotePatternString + whitespace + commaPatternString + whitespace;
        Pattern filePattern = Pattern.compile(filePatternString);
        return filePattern;
    }

    private String getAnnotationText(IAnnotation annotation, ITextViewer viewer, int invocationOffset) {
        String text;
        ISourceRange sourceRange;
        ISourceRange nameRange;
        try {
            nameRange = annotation.getNameRange();
            sourceRange = annotation.getSourceRange();
        }
        catch (JavaModelException javaModelException) {
            return "";
        }
        int endPoint = sourceRange.getOffset() + sourceRange.getLength();
        if (invocationOffset > endPoint) {
            endPoint = invocationOffset;
        }
        try {
            text = viewer.getDocument().get(nameRange.getOffset() + nameRange.getLength(), endPoint - (nameRange.getOffset() + nameRange.getLength()));
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
        return text;
    }

    class ProposalAssemblyInformation {
        String prefix;
        String postfix;
        String filter;

        ProposalAssemblyInformation(String aPrefix, String aPostfix, String aFilter) {
            this.prefix = aPrefix;
            this.postfix = aPostfix;
            this.filter = aFilter;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getPostfix() {
            return this.postfix;
        }

        public String getFilter() {
            return this.filter;
        }
    }
}

