/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.graph.policies;

import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gef.requests.TargetRequest;
import org.eclipse.ui.texteditor.ITextEditor;
import org.springframework.ide.eclipse.config.graph.model.Activity;
import org.springframework.ide.eclipse.config.graph.model.Transition;
import org.springframework.ide.eclipse.config.graph.model.commands.FixedConnectionCreateCommand;
import org.springframework.ide.eclipse.config.graph.model.commands.ReconnectFixedSourceCommand;
import org.springframework.ide.eclipse.config.graph.model.commands.ReconnectFixedTargetCommand;
import org.springframework.ide.eclipse.config.graph.parts.BorderedActivityPart;
import org.springframework.ide.eclipse.config.graph.parts.FixedConnectionAnchor;
import org.springframework.ide.eclipse.config.graph.policies.ActivityNodeEditPolicy;

public abstract class FixedConnectionNodeEditPolicy
extends ActivityNodeEditPolicy {
    private void eraseConnectionLabel() {
        if (this.getActivityPart() instanceof BorderedActivityPart) {
            BorderedActivityPart part = (BorderedActivityPart)this.getActivityPart();
            part.setBorderLabel("");
            part.getFigure().repaint();
        }
    }

    protected void eraseTargetConnectionFeedback(DropRequest request) {
        this.eraseConnectionLabel();
    }

    public void eraseTargetFeedback(Request request) {
        this.eraseConnectionLabel();
        super.eraseTargetFeedback(request);
    }

    protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        if (request.getStartCommand() instanceof FixedConnectionCreateCommand) {
            FixedConnectionCreateCommand cmd = (FixedConnectionCreateCommand)request.getStartCommand();
            ConnectionAnchor anchor = this.getActivityPart().getTargetConnectionAnchor((Request)request);
            if (anchor instanceof FixedConnectionAnchor) {
                FixedConnectionAnchor fixedAnchor = (FixedConnectionAnchor)anchor;
                cmd.setTargetAnchor(fixedAnchor);
            } else {
                cmd.setTargetAnchor(null);
            }
            cmd.setTarget(this.getActivity());
            return cmd;
        }
        return super.getConnectionCompleteCommand(request);
    }

    protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
        int style = (Integer)request.getNewObjectType();
        Activity source = this.getActivity();
        FixedConnectionCreateCommand cmd = this.getConnectionCreateCommand((ITextEditor)source.getDiagram().getTextEditor(), style);
        if (cmd != null) {
            ConnectionAnchor anchor = this.getActivityPart().getSourceConnectionAnchor((Request)request);
            if (anchor instanceof FixedConnectionAnchor) {
                FixedConnectionAnchor fixedAnchor = (FixedConnectionAnchor)anchor;
                cmd.setSourceAnchor(fixedAnchor);
            }
            cmd.setSource(source);
            request.setStartCommand((Command)cmd);
        }
        return cmd;
    }

    protected abstract FixedConnectionCreateCommand getConnectionCreateCommand(ITextEditor var1, int var2);

    protected Command getReconnectSourceCommand(ReconnectRequest request) {
        Activity source = this.getActivity();
        ReconnectFixedSourceCommand cmd = new ReconnectFixedSourceCommand((ITextEditor)source.getDiagram().getTextEditor());
        ConnectionAnchor anchor = this.getActivityPart().getSourceConnectionAnchor((Request)request);
        if (anchor instanceof FixedConnectionAnchor) {
            FixedConnectionAnchor fixedAnchor = (FixedConnectionAnchor)anchor;
            cmd.setSourceAnchor(fixedAnchor);
        }
        cmd.setTransition((Transition)request.getConnectionEditPart().getModel());
        cmd.setSource(source);
        return cmd;
    }

    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        Activity target = this.getActivity();
        ReconnectFixedTargetCommand cmd = new ReconnectFixedTargetCommand((ITextEditor)target.getDiagram().getTextEditor());
        ConnectionAnchor anchor = this.getActivityPart().getTargetConnectionAnchor((Request)request);
        if (anchor instanceof FixedConnectionAnchor) {
            FixedConnectionAnchor fixedAnchor = (FixedConnectionAnchor)anchor;
            cmd.setTargetAnchor(fixedAnchor);
        }
        cmd.setTransition((Transition)request.getConnectionEditPart().getModel());
        cmd.setTarget(target);
        return cmd;
    }

    private void showConnectionLabel(BorderedActivityPart part, Point location) {
        ConnectionAnchor anchor = part.getConnectionAnchorAt(location);
        if (anchor instanceof FixedConnectionAnchor) {
            part.setBorderLabel(((FixedConnectionAnchor)anchor).getConnectionLabel());
        } else {
            part.setBorderLabel("");
        }
        part.getFigure().repaint();
    }

    protected void showTargetConnectionFeedback(DropRequest request) {
        if (this.getActivityPart() instanceof BorderedActivityPart) {
            BorderedActivityPart part = (BorderedActivityPart)this.getActivityPart();
            if (request instanceof TargetRequest) {
                Point location = request.getLocation();
                this.showConnectionLabel(part, location);
            }
        }
    }

    public void showTargetFeedback(Request request) {
        if (this.getActivityPart() instanceof BorderedActivityPart) {
            BorderedActivityPart part = (BorderedActivityPart)this.getActivityPart();
            if (request instanceof SelectionRequest) {
                SelectionRequest selection = (SelectionRequest)request;
                Point location = selection.getLocation();
                this.showConnectionLabel(part, location);
            }
        }
        super.showTargetFeedback(request);
    }
}

