/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.graph.parts;

import java.util.HashMap;
import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.CompoundDirectedGraph;
import org.eclipse.draw2d.graph.CompoundDirectedGraphLayout;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.springframework.ide.eclipse.config.graph.parts.ActivityDiagramPart;
import org.springframework.ide.eclipse.config.graph.parts.GraphAnimation;

class GraphLayoutManager
extends AbstractLayout {
    private final ActivityDiagramPart diagram;
    private final int direction;

    GraphLayoutManager(ActivityDiagramPart diagram, int direction) {
        this.diagram = diagram;
        this.direction = direction;
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        container.validate();
        List children = container.getChildren();
        Rectangle result = new Rectangle().setLocation(container.getClientArea().getLocation());
        int i = 0;
        while (i < children.size()) {
            result.union(((IFigure)children.get(i)).getBounds());
            ++i;
        }
        result.resize(container.getInsets().getWidth(), container.getInsets().getHeight());
        return result.getSize();
    }

    public void layout(IFigure container) {
        GraphAnimation.recordInitialState(container);
        if (GraphAnimation.playbackState(container)) {
            return;
        }
        CompoundDirectedGraph graph = new CompoundDirectedGraph();
        if (this.direction == 16) {
            graph.setDirection(this.direction);
        }
        HashMap<AbstractGraphicalEditPart, Object> partsToNodes = new HashMap<AbstractGraphicalEditPart, Object>();
        this.diagram.contributeNodesToGraph(graph, null, partsToNodes);
        this.diagram.contributeEdgesToGraph(graph, partsToNodes);
        new CompoundDirectedGraphLayout().visit((DirectedGraph)graph);
        this.diagram.applyGraphResults(graph, partsToNodes);
        this.diagram.setBoundsOnModel();
    }
}

