/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.graph.parts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.config.graph.figures.BorderedActivityLabel;
import org.springframework.ide.eclipse.config.graph.model.Activity;
import org.springframework.ide.eclipse.config.graph.model.Transition;
import org.springframework.ide.eclipse.config.graph.parts.ActivityDiagramPart;
import org.springframework.ide.eclipse.config.graph.parts.SimpleActivityPart;
import org.springframework.ide.eclipse.config.graph.parts.TransitionPart;
import org.springframework.ide.eclipse.config.graph.policies.ActivityNodeEditPolicy;
import org.springframework.ide.eclipse.config.graph.policies.FixedConnectionNodeEditPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BorderedActivityPart
extends SimpleActivityPart {
    protected BorderedActivityLabel figure;
    private boolean hasAnchors = true;

    public BorderedActivityPart(Activity activity) {
        super(activity);
    }

    protected BorderedActivityLabel createBorderedLabel(int direction, List<String> incomings, List<String> outgoings) {
        return new BorderedActivityLabel(direction, incomings, outgoings);
    }

    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        if (this.hasAnchors) {
            this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)this.getFixedConnectionNodeEditPolicy());
        } else {
            this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)this.getStandardConnectionNodeEditPolicy());
        }
    }

    @Override
    protected IFigure createFigure() {
        Activity activity = this.getModelElement();
        ArrayList<String> incomings = new ArrayList<String>();
        ArrayList<String> outgoings = new ArrayList<String>();
        if (this.hasAnchors) {
            incomings.addAll(activity.getPrimaryIncomingAttributes());
            incomings.addAll(activity.getSecondaryIncomingAttributes());
            outgoings.addAll(activity.getPrimaryOutgoingAttributes());
            outgoings.addAll(activity.getSecondaryOutgoingAttributes());
        }
        int direction = 4;
        EditPart part = this.getViewer().getContents();
        if (part instanceof ActivityDiagramPart) {
            ActivityDiagramPart diagramPart = (ActivityDiagramPart)part;
            direction = diagramPart.getDirection();
        }
        this.figure = this.createBorderedLabel(direction, incomings, outgoings);
        return this.figure;
    }

    @Override
    protected int getAnchorOffset() {
        return -1;
    }

    public ConnectionAnchor getConnectionAnchorAt(Point p) {
        return ((BorderedActivityLabel)this.getFigure()).getConnectionAnchorAt(p);
    }

    protected abstract FixedConnectionNodeEditPolicy getFixedConnectionNodeEditPolicy();

    protected abstract ActivityNodeEditPolicy getStandardConnectionNodeEditPolicy();

    @Override
    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        ConnectionAnchor anchor;
        TransitionPart part;
        Transition trans;
        IDOMNode input;
        if (connection instanceof TransitionPart && (input = (trans = (Transition)(part = (TransitionPart)connection).getModel()).getInput()) != null && (anchor = ((BorderedActivityLabel)this.getFigure()).getConnectionAnchor(trans.getInput().getLocalName())) != null) {
            return anchor;
        }
        return super.getSourceConnectionAnchor(connection);
    }

    @Override
    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        Point pt = new Point(((DropRequest)request).getLocation());
        ConnectionAnchor anchor = ((BorderedActivityLabel)this.getFigure()).getSourceConnectionAnchorAt(pt);
        if (anchor != null) {
            return anchor;
        }
        return super.getSourceConnectionAnchor(request);
    }

    @Override
    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        ConnectionAnchor anchor;
        TransitionPart part;
        Transition trans;
        IDOMNode input;
        if (connection instanceof TransitionPart && (input = (trans = (Transition)(part = (TransitionPart)connection).getModel()).getInput()) != null && (anchor = ((BorderedActivityLabel)this.getFigure()).getConnectionAnchor(trans.getInput().getLocalName())) != null) {
            return anchor;
        }
        return super.getTargetConnectionAnchor(connection);
    }

    @Override
    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        Point pt = new Point(((DropRequest)request).getLocation());
        ConnectionAnchor anchor = ((BorderedActivityLabel)this.getFigure()).getTargetConnectionAnchorAt(pt);
        if (anchor != null) {
            return anchor;
        }
        return super.getTargetConnectionAnchor(request);
    }

    public void setBorderLabel(String label) {
        if (this.figure != null) {
            this.figure.setBorderLabel(label);
        }
    }

    public void setHasAnchors(boolean hasAnchors) {
        this.hasAnchors = hasAnchors;
    }
}

