/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.graph.model.commands;

import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.springframework.ide.eclipse.config.core.schemas.BeansSchemaConstants;
import org.springframework.ide.eclipse.config.graph.model.Activity;
import org.springframework.ide.eclipse.config.graph.model.Transition;
import org.springframework.ide.eclipse.config.graph.model.commands.AbstractTextCommand;
import org.springframework.ide.eclipse.config.graph.parts.FixedConnectionAnchor;

public class ReconnectFixedSourceCommand
extends AbstractTextCommand {
    private String id;
    private String attr;
    private Activity source;
    private Activity target;
    private Transition transition;
    private IDOMElement sourceElement;
    private IDOMElement targetElement;
    private FixedConnectionAnchor sourceAnchor;
    private Activity oldSource;
    private IDOMElement oldSourceElement;
    private IDOMAttr transitionAttr;

    public ReconnectFixedSourceCommand(ITextEditor textEditor) {
        super(textEditor);
    }

    public boolean canExecute() {
        if (this.source == null || this.target == null || this.source.equals(this.target)) {
            return false;
        }
        this.sourceElement = this.source.getInput();
        this.targetElement = this.target.getInput();
        this.oldSourceElement = this.oldSource.getInput();
        if (this.sourceElement == null || this.targetElement == null || this.oldSourceElement == null) {
            return false;
        }
        if (!(this.transition.getInput() instanceof IDOMAttr)) {
            return false;
        }
        this.transitionAttr = (IDOMAttr)this.transition.getInput();
        if (this.sourceAnchor != null && this.transitionAttr.getOwnerElement().equals(this.targetElement)) {
            return false;
        }
        if (this.sourceAnchor == null && this.transitionAttr.getOwnerElement().equals(this.oldSourceElement)) {
            return false;
        }
        if (this.sourceAnchor != null) {
            this.attr = this.sourceAnchor.getConnectionLabel();
            this.id = this.transitionAttr.getValue();
        } else {
            this.attr = this.transitionAttr.getName();
            this.id = this.sourceElement.getAttribute(BeansSchemaConstants.ATTR_ID);
        }
        return this.id != null && this.id.trim().length() != 0;
    }

    public void execute() {
        if (this.sourceAnchor != null) {
            IDOMDocument document = (IDOMDocument)this.transitionAttr.getOwnerDocument();
            IDOMModel model = document.getModel();
            model.beginRecording((Object)this);
            this.oldSourceElement.removeAttribute(this.transitionAttr.getName());
            this.sourceElement.setAttribute(this.attr, this.id);
            model.endRecording((Object)this);
        } else {
            this.targetElement.setAttribute(this.attr, this.id);
        }
    }

    public void setSource(Activity activity) {
        this.source = activity;
    }

    public void setSourceAnchor(FixedConnectionAnchor anchor) {
        this.sourceAnchor = anchor;
    }

    public void setTransition(Transition trans) {
        this.transition = trans;
        this.target = trans.target;
        this.oldSource = trans.source;
    }
}

