/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.internal.configurator.operations;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.springsource.ide.eclipse.commons.internal.configurator.operations.AbstractInstallOperation;

public class CopyOperation
extends AbstractInstallOperation {
    private static final String ATTR_SOURCE = "source";
    private static final String ATTR_TARGET = "target";
    private final String targetName;
    private final String sourceName;

    private static void copy(File src, File dest) throws IOException {
        FileInputStream in = new FileInputStream(src);
        try {
            FileOutputStream out = new FileOutputStream(dest);
            try {
                int len;
                byte[] buf = new byte[8192];
                while ((len = ((InputStream)in).read(buf)) != -1) {
                    ((OutputStream)out).write(buf, 0, len);
                }
            }
            finally {
                ((OutputStream)out).close();
            }
        }
        finally {
            ((InputStream)in).close();
        }
    }

    private static int copyDirectory(File source, File target) throws IOException {
        File[] files;
        int fileCount = 0;
        if (!target.exists()) {
            target.mkdirs();
        }
        if ((files = source.listFiles()) != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File sourceChild = fileArray[n2];
                String name = sourceChild.getName();
                File targetChild = new File(target, name);
                if (sourceChild.isDirectory()) {
                    fileCount += CopyOperation.copyDirectory(sourceChild, targetChild);
                } else {
                    ++fileCount;
                    CopyOperation.copy(sourceChild, targetChild);
                }
                ++n2;
            }
        }
        return fileCount;
    }

    public CopyOperation(IConfigurationElement element) {
        this.sourceName = element.getAttribute(ATTR_SOURCE);
        this.targetName = element.getAttribute(ATTR_TARGET);
    }

    @Override
    public IStatus install(IProgressMonitor monitor) {
        try {
            File source = this.getSource();
            File target = this.getTarget();
            int count = CopyOperation.copyDirectory(source, target);
            return new Status(0, "org.springsource.ide.eclipse.commons.configurator", NLS.bind((String)"Copied {0} files from ''{1}'' to ''{2}''.", (Object[])new Object[]{count, source, target}));
        }
        catch (IOException e) {
            return new Status(4, "org.springsource.ide.eclipse.commons.configurator", "I/O error while copying files", (Throwable)e);
        }
    }

    private File getTarget() {
        return this.targetName != null ? new File(this.getTargetBase(), this.targetName) : this.getTargetBase();
    }

    private File getSource() {
        return this.sourceName != null ? new File(this.getSourceBase(), this.sourceName) : this.getSourceBase();
    }

    public String toString() {
        return "CopyOperation [target=" + this.targetName + ", source=" + this.sourceName + "]";
    }
}

