/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.core.internal.model.project;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowConfig;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowConfig;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebflowProjectDescription {
    private IWebflowProject project;
    private List<IWebflowConfig> configs;

    public WebflowProjectDescription(IWebflowProject project) {
        this.project = project;
        this.configs = new ArrayList<IWebflowConfig>();
    }

    public IWebflowConfig addConfig(IFile file) {
        WebflowConfig config = new WebflowConfig(this.project);
        config.setResource(file);
        this.configs.add(config);
        return config;
    }

    public void add(IWebflowConfig file) {
        this.configs.add(file);
    }

    public List<IWebflowConfig> getConfigs() {
        return this.configs;
    }

    public void removeConfig(IFile file) {
        IWebflowConfig config = null;
        for (IWebflowConfig c : this.configs) {
            if (!c.getResource().equals((Object)file)) continue;
            config = c;
        }
        if (config != null) {
            this.configs.remove(config);
        }
    }

    public void setConfigs(List<IWebflowConfig> configs) {
        this.configs = configs;
    }
}

