/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.core.internal.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.springframework.ide.eclipse.core.SpringCoreUtils;
import org.springframework.ide.eclipse.core.internal.model.resources.SpringResourceChangeEventsAdapter;
import org.springframework.ide.eclipse.webflow.core.Activator;
import org.springframework.ide.eclipse.webflow.core.internal.model.resources.IWebflowResourceChangeEvents;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowProject;

public class WebflowResourceChangeEvents
extends SpringResourceChangeEventsAdapter
implements IWebflowResourceChangeEvents {
    public boolean isSpringProject(IProject project, int eventType) {
        return !SpringCoreUtils.isSpringProject((IResource)project);
    }

    public void projectClosed(IProject project, int eventType) {
        this.clearProject(project);
    }

    private void clearProject(IProject project) {
        Activator.getModel().removeProject(project);
    }

    public void projectDeleted(IProject project, int eventType) {
        this.clearProject(project);
    }

    public void springNatureRemoved(IProject project, int eventType) {
        this.clearProject(project);
    }

    public void springNatureAdded(IProject project, int eventType) {
        this.clearProject(project);
    }

    public void configAdded(IFile file, int eventType) {
    }

    public void configChanged(IFile file, int eventType) {
        IProject project = file.getProject();
        IWebflowProject wfp = Activator.getModel().getProject(project);
        if (wfp != null) {
            Activator.getModel().fireModelChangedEvent(wfp);
        }
    }

    public void configRemoved(IFile file, int eventType) {
    }

    public void projectDescriptionChanged(IFile file, int eventType) {
        SpringCoreUtils.buildProject((IProject)file.getProject());
    }
}

