/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.core.internal.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelElementVisitor;
import org.springframework.ide.eclipse.webflow.core.internal.model.AbstractModelElement;
import org.springframework.ide.eclipse.webflow.core.internal.model.Mapping;
import org.springframework.ide.eclipse.webflow.core.internal.model.OutputAttribute;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelXmlUtils;
import org.springframework.ide.eclipse.webflow.core.model.IAttribute;
import org.springframework.ide.eclipse.webflow.core.model.IInputAttribute;
import org.springframework.ide.eclipse.webflow.core.model.IMapping;
import org.springframework.ide.eclipse.webflow.core.model.IOutputAttribute;
import org.springframework.ide.eclipse.webflow.core.model.IOutputMapper;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputMapper
extends AbstractModelElement
implements IOutputMapper {
    private List<IOutputAttribute> outputAttributes;
    private List<IMapping> mappings;

    @Override
    public void init(IDOMNode node, IWebflowModelElement parent) {
        super.init(node, parent);
        this.outputAttributes = new ArrayList<IOutputAttribute>();
        this.mappings = new ArrayList<IMapping>();
        NodeList children = node.getChildNodes();
        if (children != null && children.getLength() > 0) {
            int i = 0;
            while (i < children.getLength()) {
                OutputAttribute attr;
                IDOMNode child = (IDOMNode)children.item(i);
                if ("output-attribute".equals(child.getLocalName())) {
                    attr = new OutputAttribute();
                    attr.init(child, this);
                    this.outputAttributes.add(attr);
                } else if ("output".equals(child.getLocalName())) {
                    attr = new OutputAttribute();
                    attr.init(child, this);
                    this.outputAttributes.add(attr);
                } else if ("mapping".equals(child.getLocalName())) {
                    Mapping map = new Mapping();
                    map.init(child, this);
                    this.mappings.add(map);
                }
                ++i;
            }
        }
    }

    @Override
    public List<IOutputAttribute> getOutputAttributes() {
        return this.outputAttributes;
    }

    @Override
    public List<IMapping> getMapping() {
        return this.mappings;
    }

    @Override
    public void addOutputAttribute(IOutputAttribute action) {
        if (!this.outputAttributes.contains(action)) {
            WebflowModelXmlUtils.insertNode((Node)action.getNode(), (Node)this.node);
            this.outputAttributes.add(action);
            super.firePropertyChange("add_children", new Integer(this.outputAttributes.indexOf(action)), action);
        }
    }

    @Override
    public void addOutputAttribute(IOutputAttribute action, int i) {
        if (!this.outputAttributes.contains(action)) {
            WebflowModelXmlUtils.insertNode((Node)action.getNode(), (Node)this.node);
            this.outputAttributes.add(i, action);
            super.firePropertyChange("add_children", new Integer(this.outputAttributes.indexOf(action)), action);
        }
    }

    @Override
    public void removeAllOutputAttribute() {
        for (IInputAttribute iInputAttribute : this.outputAttributes) {
            this.getNode().removeChild((Node)iInputAttribute.getNode());
        }
        this.outputAttributes = new ArrayList<IOutputAttribute>();
    }

    @Override
    public void removeOutputAttribute(IOutputAttribute action) {
        if (this.outputAttributes.contains(action)) {
            this.outputAttributes.remove(action);
            this.getNode().removeChild((Node)action.getNode());
            super.fireStructureChange("remove_children", action);
        }
    }

    @Override
    public void createNew(IWebflowModelElement parent) {
        IDOMNode node = (IDOMNode)parent.getNode().getOwnerDocument().createElement("output-mapper");
        this.init(node, parent);
    }

    @Override
    public void addMapping(IMapping action) {
        if (!this.mappings.contains(action)) {
            WebflowModelXmlUtils.insertNode((Node)action.getNode(), (Node)this.node);
            this.mappings.add(action);
            super.firePropertyChange("add_children", new Integer(this.mappings.indexOf(action)), action);
        }
    }

    @Override
    public void addMapping(IMapping action, int i) {
        if (!this.mappings.contains(action)) {
            WebflowModelXmlUtils.insertNode((Node)action.getNode(), (Node)this.node);
            this.mappings.add(i, action);
            super.firePropertyChange("add_children", new Integer(this.mappings.indexOf(action)), action);
        }
    }

    @Override
    public void removeAllMapping() {
        for (IMapping action : this.mappings) {
            this.getNode().removeChild((Node)action.getNode());
        }
        this.mappings = new ArrayList<IMapping>();
    }

    @Override
    public void removeMapping(IMapping action) {
        if (this.mappings.contains(action)) {
            this.mappings.remove(action);
            this.getNode().removeChild((Node)action.getNode());
            super.fireStructureChange("remove_children", action);
        }
    }

    public void accept(IModelElementVisitor visitor, IProgressMonitor monitor) {
        if (!monitor.isCanceled() && visitor.visit((IModelElement)this, monitor)) {
            for (IAttribute iAttribute : this.getAttributes()) {
                if (monitor.isCanceled()) {
                    return;
                }
                iAttribute.accept(visitor, monitor);
            }
            for (IMapping iMapping : this.getMapping()) {
                if (monitor.isCanceled()) {
                    return;
                }
                iMapping.accept(visitor, monitor);
            }
            for (IOutputAttribute iOutputAttribute : this.getOutputAttributes()) {
                if (monitor.isCanceled()) {
                    return;
                }
                iOutputAttribute.accept(visitor, monitor);
            }
        }
    }

    public IModelElement[] getElementChildren() {
        ArrayList<IWebflowModelElement> children = new ArrayList<IWebflowModelElement>();
        children.addAll(this.getAttributes());
        children.addAll(this.getMapping());
        children.addAll(this.getOutputAttributes());
        return children.toArray(new IModelElement[children.size()]);
    }
}

