/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.core.internal.model;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelElementVisitor;
import org.springframework.ide.eclipse.webflow.core.internal.model.AbstractState;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowState;
import org.springframework.ide.eclipse.webflow.core.model.IInlineFlowState;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowConfig;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowState;
import org.w3c.dom.NodeList;

public class InlineFlowState
extends AbstractState
implements IInlineFlowState {
    private IWebflowState state;

    public void init(IDOMNode node, IWebflowModelElement parent) {
        super.init(node, parent);
        NodeList children = node.getChildNodes();
        if (children != null && children.getLength() > 0) {
            int i = 0;
            while (i < children.getLength()) {
                IDOMNode child = (IDOMNode)children.item(i);
                if ("flow".equals(child.getLocalName())) {
                    this.state = new WebflowState((IWebflowConfig)parent.getElementParent());
                    this.state.init(child, this);
                }
                ++i;
            }
        }
    }

    public IWebflowState getWebFlowState() {
        return this.state;
    }

    public void createNew(IWebflowState parent) {
        IDOMNode node = (IDOMNode)parent.getNode().getOwnerDocument().createElement("inline-flow");
        this.init(node, parent);
    }

    public void accept(IModelElementVisitor visitor, IProgressMonitor monitor) {
        if (!monitor.isCanceled() && visitor.visit((IModelElement)this, monitor)) {
            this.getWebFlowState().accept(visitor, monitor);
        }
    }

    public IModelElement[] getElementChildren() {
        ArrayList<IWebflowState> children = new ArrayList<IWebflowState>();
        children.add(this.getWebFlowState());
        return children.toArray(new IModelElement[children.size()]);
    }
}

