/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.core.internal.model;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelElementVisitor;
import org.springframework.ide.eclipse.webflow.core.internal.model.AbstractTransitionableTo;
import org.springframework.ide.eclipse.webflow.core.internal.model.OutputMapper;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelXmlUtils;
import org.springframework.ide.eclipse.webflow.core.model.IAttribute;
import org.springframework.ide.eclipse.webflow.core.model.ICloneableModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IEndState;
import org.springframework.ide.eclipse.webflow.core.model.IExceptionHandler;
import org.springframework.ide.eclipse.webflow.core.model.IOutputMapper;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowState;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndState
extends AbstractTransitionableTo
implements IEndState,
ICloneableModelElement<IEndState> {
    private IOutputMapper outputMapper;

    @Override
    public void init(IDOMNode node, IWebflowModelElement parent) {
        NodeList children;
        super.init(node, parent);
        if (node != null && (children = node.getChildNodes()) != null && children.getLength() > 0) {
            int i = 0;
            while (i < children.getLength()) {
                IDOMNode child = (IDOMNode)children.item(i);
                if ("output-mapper".equals(child.getLocalName())) {
                    this.outputMapper = new OutputMapper();
                    this.outputMapper.init(child, this);
                }
                ++i;
            }
        }
    }

    @Override
    public String getView() {
        return this.getAttribute("view");
    }

    @Override
    public void setView(String view) {
        this.setAttribute("view", view);
    }

    @Override
    public void createNew(IWebflowState parent) {
        IDOMNode node = (IDOMNode)parent.getNode().getOwnerDocument().createElement("end-state");
        this.init(node, parent);
    }

    @Override
    public IEndState cloneModelElement() {
        EndState state = new EndState();
        state.init((IDOMNode)this.node.cloneNode(true), this.parent);
        return state;
    }

    @Override
    public void applyCloneValues(IEndState element) {
        if (element != null) {
            if (this.node.getParentNode() != null) {
                this.parent.getNode().replaceChild((Node)element.getNode(), (Node)this.node);
            }
            this.setId(element.getId());
            this.init(element.getNode(), this.parent);
            super.fireStructureChange("move_children", new Integer(1));
        }
    }

    @Override
    public IOutputMapper getOutputMapper() {
        return this.outputMapper;
    }

    @Override
    public void setOutputMapper(IOutputMapper outputMapper) {
        if (this.outputMapper != null) {
            this.getNode().removeChild((Node)this.outputMapper.getNode());
        }
        this.outputMapper = outputMapper;
        if (outputMapper != null) {
            WebflowModelXmlUtils.insertNode((Node)outputMapper.getNode(), (Node)this.getNode());
        }
        super.fireStructureChange("add_children", outputMapper);
    }

    public void accept(IModelElementVisitor visitor, IProgressMonitor monitor) {
        if (!monitor.isCanceled() && visitor.visit((IModelElement)this, monitor)) {
            for (IAttribute iAttribute : this.getAttributes()) {
                if (monitor.isCanceled()) {
                    return;
                }
                iAttribute.accept(visitor, monitor);
            }
            if (this.getEntryActions() != null) {
                this.getEntryActions().accept(visitor, monitor);
            }
            if (monitor.isCanceled()) {
                return;
            }
            for (IExceptionHandler iExceptionHandler : this.getExceptionHandlers()) {
                if (monitor.isCanceled()) {
                    return;
                }
                iExceptionHandler.accept(visitor, monitor);
            }
        }
    }

    public IModelElement[] getElementChildren() {
        ArrayList<IWebflowModelElement> children = new ArrayList<IWebflowModelElement>();
        children.addAll(this.getAttributes());
        children.add(this.getEntryActions());
        children.addAll(this.getExceptionHandlers());
        return children.toArray(new IModelElement[children.size()]);
    }

    @Override
    public void setCommit(String commit) {
        this.setAttribute("commit", commit);
    }

    @Override
    public String getCommit() {
        return this.getAttribute("commit");
    }
}

