/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.core.internal.model;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelElementVisitor;
import org.springframework.ide.eclipse.webflow.core.internal.model.AbstractModelElement;
import org.springframework.ide.eclipse.webflow.core.internal.model.InputMapper;
import org.springframework.ide.eclipse.webflow.core.internal.model.OutputMapper;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelXmlUtils;
import org.springframework.ide.eclipse.webflow.core.model.IAttributeMapper;
import org.springframework.ide.eclipse.webflow.core.model.ICloneableModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IInputMapper;
import org.springframework.ide.eclipse.webflow.core.model.IOutputMapper;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeMapper
extends AbstractModelElement
implements IAttributeMapper,
ICloneableModelElement<IAttributeMapper> {
    private IInputMapper inputMapper;
    private IOutputMapper outputMapper;

    @Override
    public void init(IDOMNode node, IWebflowModelElement parent) {
        super.init(node, parent);
        NodeList children = node.getChildNodes();
        if (children != null && children.getLength() > 0) {
            int i = 0;
            while (i < children.getLength()) {
                IDOMNode child = (IDOMNode)children.item(i);
                if ("input-mapper".equals(child.getLocalName())) {
                    this.inputMapper = new InputMapper();
                    this.inputMapper.init(child, this);
                } else if ("output-mapper".equals(child.getLocalName())) {
                    this.outputMapper = new OutputMapper();
                    this.outputMapper.init(child, this);
                }
                ++i;
            }
        }
    }

    @Override
    public String getBean() {
        return this.getAttribute("bean");
    }

    @Override
    public IInputMapper getInputMapper() {
        return this.inputMapper;
    }

    @Override
    public void setBean(String bean) {
        this.setAttribute("bean", bean);
    }

    @Override
    public IOutputMapper getOutputMapper() {
        return this.outputMapper;
    }

    @Override
    public void setOutputMapper(IOutputMapper outputMapper) {
        if (this.outputMapper != null) {
            this.getNode().removeChild((Node)this.outputMapper.getNode());
        }
        this.outputMapper = outputMapper;
        if (outputMapper != null) {
            WebflowModelXmlUtils.insertNode((Node)outputMapper.getNode(), (Node)this.getNode());
        }
        super.fireStructureChange("add_children", outputMapper);
    }

    @Override
    public void setInputMapper(IInputMapper inputMapper) {
        if (this.inputMapper != null) {
            this.getNode().removeChild((Node)this.inputMapper.getNode());
        }
        this.inputMapper = inputMapper;
        if (inputMapper != null) {
            WebflowModelXmlUtils.insertNode((Node)inputMapper.getNode(), (Node)this.getNode());
        }
        super.fireStructureChange("add_children", inputMapper);
    }

    @Override
    public IAttributeMapper cloneModelElement() {
        AttributeMapper state = new AttributeMapper();
        state.init((IDOMNode)this.node.cloneNode(true), this.parent);
        return state;
    }

    @Override
    public void applyCloneValues(IAttributeMapper element) {
        if (element != null) {
            if (this.node.getParentNode() != null) {
                this.parent.getNode().replaceChild((Node)element.getNode(), (Node)this.node);
            }
            this.setBean(element.getBean());
            this.init(element.getNode(), this.parent);
        }
    }

    @Override
    public void createNew(IWebflowModelElement parent) {
        IDOMNode node = (IDOMNode)parent.getNode().getOwnerDocument().createElement("attribute-mapper");
        this.init(node, parent);
    }

    public void accept(IModelElementVisitor visitor, IProgressMonitor monitor) {
        if (!monitor.isCanceled() && visitor.visit((IModelElement)this, monitor)) {
            if (this.getInputMapper() != null) {
                this.getInputMapper().accept(visitor, monitor);
            }
            if (monitor.isCanceled()) {
                return;
            }
            if (this.getOutputMapper() != null) {
                this.getOutputMapper().accept(visitor, monitor);
            }
        }
    }

    public IModelElement[] getElementChildren() {
        ArrayList<IWebflowModelElement> children = new ArrayList<IWebflowModelElement>();
        children.add(this.getInputMapper());
        children.add(this.getOutputMapper());
        return children.toArray(new IModelElement[children.size()]);
    }
}

