/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.ui.tips;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.eclipse.core.runtime.Platform;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springsource.ide.eclipse.commons.internal.core.CorePlugin;
import org.springsource.ide.eclipse.commons.ui.tips.TipInfo;

public class TipProvider {
    private static final Random RAND = new Random();
    private TipInfo[] tips;
    private int pointer;
    private Exception error;

    public TipProvider() {
        this.refresh();
    }

    public void refresh() {
        this.error = null;
        InputStreamReader tipReader = new InputStreamReader(TipProvider.class.getClassLoader().getResourceAsStream("org/springsource/ide/eclipse/commons/ui/tips/spring_tool_tips.json"));
        JSONTokener tokener = new JSONTokener((Reader)tipReader);
        List<TipInfo> tipList = Collections.emptyList();
        try {
            JSONArray json = new JSONArray(tokener);
            int length = json.length();
            tipList = new ArrayList(length);
            int i = 0;
            while (i < length) {
                String requiredPlugin;
                JSONObject object = (JSONObject)json.get(i);
                if (!object.has("required") || Platform.getBundle((String)(requiredPlugin = object.getString("required"))) != null) {
                    tipList.add(new TipInfo(object.getString("infoText"), object.getString("linkText"), object.has("keyBindingId") ? object.getString("keyBindingId") : null));
                }
                ++i;
            }
        }
        catch (JSONException e) {
            CorePlugin.log((String)"Error parsing tips of the day file", (Throwable)e);
            this.error = e;
        }
        this.tips = tipList.size() == 0 ? new TipInfo[]{new TipInfo("There's a lot going on with Spring", "Read the latest <a href\"http://spring.io/blog\">Spring news</a>.")} : tipList.toArray(new TipInfo[tipList.size()]);
        this.pointer = RAND.nextInt(this.tips.length);
    }

    public TipInfo nextTip() {
        return this.tips[++this.pointer % this.tips.length];
    }

    public TipInfo previousTip() {
        if (this.pointer == 0) {
            this.pointer = this.tips.length;
        }
        return this.tips[--this.pointer % this.tips.length];
    }

    public Exception getError() {
        return this.error;
    }
}

