/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.ui.tips;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.keys.KeyBinding;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.keys.IBindingService;
import org.springsource.ide.eclipse.commons.ui.UiUtil;

class TipInfo {
    public static final String COMMAND = "command:";
    public static final String PREF = "pref:";
    final String linkText;
    final String infoText;
    final String keyBindingId;

    public TipInfo(String infoText, String linkText) {
        this.linkText = linkText;
        this.infoText = infoText;
        this.keyBindingId = null;
    }

    public TipInfo(String infoText, String linkText, String keyBindingId) {
        this.linkText = linkText;
        this.infoText = infoText;
        this.keyBindingId = keyBindingId;
    }

    public String getKeyBindingText(IWorkbenchWindow activeWindow) {
        if (this.keyBindingId != null) {
            IBindingService bindingService = (IBindingService)activeWindow.getService(IBindingService.class);
            Binding[] bindings = bindingService.getBindings();
            KeySequence keySequence = null;
            Binding[] bindingArray = bindings;
            int n = bindings.length;
            int n2 = 0;
            while (n2 < n) {
                Binding binding = bindingArray[n2];
                if (binding instanceof KeyBinding && binding.getParameterizedCommand() != null && binding.getParameterizedCommand().getId().equals(this.keyBindingId)) {
                    keySequence = ((KeyBinding)binding).getKeySequence();
                    break;
                }
                ++n2;
            }
            if (keySequence != null) {
                return " Key binding: " + keySequence;
            }
        }
        return null;
    }

    public void invokeAction(String text, IWorkbenchWindow activeWindow) {
        if (text.startsWith(PREF)) {
            PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)activeWindow.getShell(), (String)text.substring(PREF.length()), null, null);
            dialog.open();
        } else if (text.startsWith(COMMAND)) {
            String commandIdString = text.substring(COMMAND.length());
            if (activeWindow != null) {
                ICommandService commandService = (ICommandService)activeWindow.getService(ICommandService.class);
                try {
                    Command command = commandService.getCommand(commandIdString);
                    command.executeWithChecks(new ExecutionEvent());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            UiUtil.openUrl(text);
        }
    }
}

