/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.metadata.process;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.springframework.beans.BeanMetadataAttributeAccessor;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.parsing.ProblemReporter;
import org.springframework.beans.factory.parsing.SourceExtractor;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ConfigurationClassPostProcessor;
import org.springframework.core.env.Environment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.DelegatingSourceExtractor;
import org.springframework.ide.eclipse.beans.core.internal.model.ProfileAwareCompositeComponentDefinition;
import org.springframework.ide.eclipse.beans.core.internal.model.ToolingAwareEnvironment;
import org.springframework.ide.eclipse.beans.core.model.process.IBeansConfigPostProcessingContext;
import org.springframework.ide.eclipse.beans.core.model.process.IBeansConfigPostProcessor;
import org.springframework.ide.eclipse.beans.core.model.process.IBeansConfigRegistrationSupport;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.java.classreading.CachingJdtMetadataReaderFactory;
import org.springframework.ide.eclipse.core.java.classreading.JdtConnectedMetadata;
import org.springframework.ide.eclipse.core.model.java.JavaModelMethodSourceLocation;
import org.springframework.ide.eclipse.core.model.java.JavaModelSourceLocation;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblem;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;

public class JdtConfigurationClassPostProcessor
implements IBeansConfigPostProcessor {
    public void postProcess(IBeansConfigPostProcessingContext postProcessingContext) {
        IJavaProject project = JdtUtils.getJavaProject((IResource)postProcessingContext.getBeansConfig().getElementResource());
        if (project == null) {
            return;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ConfigurationClassPostProcessor processor = new ConfigurationClassPostProcessor();
        DelegatingSourceExtractor sourceExtractor = new DelegatingSourceExtractor(project.getProject());
        processor.setEnvironment((Environment)new ToolingAwareEnvironment());
        processor.setSourceExtractor((SourceExtractor)sourceExtractor);
        processor.setMetadataReaderFactory((MetadataReaderFactory)new CachingJdtMetadataReaderFactory(project, classLoader));
        processor.setProblemReporter((ProblemReporter)new JdtAnnotationMetadataProblemReporter(postProcessingContext));
        processor.setResourceLoader((ResourceLoader)new DefaultResourceLoader(classLoader));
        ReaderEventListenerForwardingBeanDefinitionRegistry registry = new ReaderEventListenerForwardingBeanDefinitionRegistry(postProcessingContext.getBeanDefinitionRegistry(), postProcessingContext.getBeansConfigRegistrySupport(), (SourceExtractor)sourceExtractor);
        registry.setBeanClassLoader(classLoader);
        processor.processConfigBeanDefinitions((BeanDefinitionRegistry)registry);
    }

    public boolean equals(Object obj) {
        return obj instanceof JdtConfigurationClassPostProcessor;
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    class JdtAnnotationBeanDefinition
    extends GenericBeanDefinition
    implements AnnotatedBeanDefinition {
        private final AnnotationMetadata annotationMetadata;

        public JdtAnnotationBeanDefinition(AnnotationMetadata annotationMetadata) {
            this.annotationMetadata = annotationMetadata;
        }

        public AnnotationMetadata getMetadata() {
            return this.annotationMetadata;
        }
    }

    class JdtAnnotationMetadataProblemReporter
    implements ProblemReporter {
        private final IBeansConfigPostProcessingContext postProcessingContext;

        public JdtAnnotationMetadataProblemReporter(IBeansConfigPostProcessingContext postProcessingContext) {
            this.postProcessingContext = postProcessingContext;
        }

        public void error(Problem problem) {
            this.createProblem(2, problem.getMessage(), problem.getLocation().getSource());
        }

        public void fatal(Problem problem) {
            this.error(problem);
        }

        public void warning(Problem problem) {
            this.createProblem(1, problem.getMessage(), problem.getLocation().getSource());
        }

        private void createProblem(int severity, String message, Object source) {
            if (source instanceof JdtConnectedMetadata) {
                IJavaElement je = ((JdtConnectedMetadata)source).getJavaElement();
                this.createProblem(severity, this.postProcessingContext, message, je);
            }
        }

        private void createProblem(int severity, IBeansConfigPostProcessingContext postProcessingContext, String message, IJavaElement je) {
            try {
                postProcessingContext.reportProblem(new ValidationProblem(severity, message, je.getUnderlyingResource(), JdtUtils.getLineNumber((IJavaElement)je), new ValidationProblemAttribute[0]));
            }
            catch (JavaModelException e) {
                BeansCorePlugin.log((Throwable)e);
            }
        }
    }

    class ReaderEventListenerForwardingBeanDefinitionRegistry
    extends DefaultListableBeanFactory
    implements BeanDefinitionRegistry {
        private final BeanDefinitionRegistry registry;
        private final IBeansConfigRegistrationSupport beansConfigRegistrationSupport;
        private final Set<String> profileDefinedBeans;
        private final SourceExtractor sourceExtractor;

        public ReaderEventListenerForwardingBeanDefinitionRegistry(BeanDefinitionRegistry registry, IBeansConfigRegistrationSupport beansConfigRegistrationSupport, SourceExtractor sourceExtractor) {
            this.registry = registry;
            this.beansConfigRegistrationSupport = beansConfigRegistrationSupport;
            this.sourceExtractor = sourceExtractor;
            this.profileDefinedBeans = new HashSet<String>();
        }

        public boolean containsBeanDefinition(String beanName) {
            return !this.profileDefinedBeans.contains(beanName) && this.registry.containsBeanDefinition(beanName);
        }

        public String[] getAliases(String name) {
            return this.registry.getAliases(name);
        }

        public BeanDefinition getBeanDefinition(String beanName) throws NoSuchBeanDefinitionException {
            return this.registry.getBeanDefinition(beanName);
        }

        public int getBeanDefinitionCount() {
            return this.registry.getBeanDefinitionCount();
        }

        public String[] getBeanDefinitionNames() {
            return this.registry.getBeanDefinitionNames();
        }

        public boolean isAlias(String beanName) {
            return this.registry.isAlias(beanName);
        }

        public boolean isBeanNameInUse(String beanName) {
            return this.registry.isBeanNameInUse(beanName);
        }

        public void registerAlias(String name, String alias) {
            this.registry.registerAlias(name, alias);
        }

        public void registerBeanDefinition(String beanName, BeanDefinition beanDefinition) throws BeanDefinitionStoreException {
            Object source = beanDefinition.getSource();
            if (!(source instanceof JavaModelSourceLocation)) {
                source = this.sourceExtractor.extractSource(beanDefinition.getSource(), null);
            }
            if (source instanceof JavaModelSourceLocation) {
                IJavaElement javaElement = JavaCore.create((String)((JavaModelSourceLocation)source).getHandleIdentifier(), (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
                if (javaElement instanceof IMethod && beanDefinition instanceof AnnotatedBeanDefinition && source instanceof JavaModelMethodSourceLocation) {
                    JdtAnnotationBeanDefinition newBeanDefinition = new JdtAnnotationBeanDefinition(((AnnotatedBeanDefinition)beanDefinition).getMetadata());
                    newBeanDefinition.setSource(source);
                    String className = ((JavaModelMethodSourceLocation)source).getReturnType();
                    newBeanDefinition.setBeanClassName(className);
                    this.registry.registerBeanDefinition(beanName, (BeanDefinition)newBeanDefinition);
                    Map profileAnnotationMetadata = newBeanDefinition.getMetadata().getAnnotationAttributes("org.springframework.context.annotation.Profile");
                    if (profileAnnotationMetadata != null && profileAnnotationMetadata.get("value") != null && profileAnnotationMetadata.get("value") instanceof String[]) {
                        String[] profiles = (String[])profileAnnotationMetadata.get("value");
                        ProfileAwareCompositeComponentDefinition profileAware = new ProfileAwareCompositeComponentDefinition(beanName, newBeanDefinition.getSource(), profiles);
                        profileAware.addNestedComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)newBeanDefinition, beanName));
                        this.beansConfigRegistrationSupport.registerComponent((ComponentDefinition)profileAware);
                        this.profileDefinedBeans.add(beanName);
                    } else {
                        this.beansConfigRegistrationSupport.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)newBeanDefinition, beanName));
                    }
                } else {
                    if (beanDefinition instanceof BeanMetadataAttributeAccessor && beanDefinition.getSource() != source) {
                        ((BeanMetadataAttributeAccessor)beanDefinition).setSource(source);
                    }
                    this.registry.registerBeanDefinition(beanName, beanDefinition);
                    this.beansConfigRegistrationSupport.registerComponent((ComponentDefinition)new BeanComponentDefinition(beanDefinition, beanName));
                }
            } else {
                if (beanDefinition instanceof BeanMetadataAttributeAccessor && beanDefinition.getSource() != source) {
                    ((BeanMetadataAttributeAccessor)beanDefinition).setSource(source);
                }
                this.registry.registerBeanDefinition(beanName, beanDefinition);
                this.beansConfigRegistrationSupport.registerComponent((ComponentDefinition)new BeanComponentDefinition(beanDefinition, beanName));
            }
        }

        public void removeAlias(String alias) {
            this.registry.removeAlias(alias);
        }

        public void removeBeanDefinition(String beanName) throws NoSuchBeanDefinitionException {
            this.registry.removeBeanDefinition(beanName);
        }
    }
}

