/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.metadata.core;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.ide.eclipse.beans.core.metadata.model.IAnnotationBeanMetadataProvider;
import org.springframework.ide.eclipse.beans.core.metadata.model.IBeanMetadata;
import org.springframework.ide.eclipse.beans.core.metadata.model.IMethodMetadata;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.core.java.annotation.Annotation;
import org.springframework.ide.eclipse.core.java.annotation.IAnnotationMetadata;
import org.springframework.ide.eclipse.core.model.IModelSourceLocation;
import org.springframework.ide.eclipse.core.model.java.JavaModelSourceLocation;
import org.springframework.ide.eclipse.metadata.core.TransactionalAnnotationMetadata;
import org.springframework.ide.eclipse.metadata.core.TransactionalMethodAnnotationMetadata;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionalAnnotationMetadataProvider
implements IAnnotationBeanMetadataProvider {
    private static final String TRANSACTIONAL_CLASS = Transactional.class.getName();

    public Set<IBeanMetadata> provideBeanMetadata(IBean bean, IType type, IAnnotationMetadata visitor) {
        LinkedHashSet<IBeanMetadata> beanMetaDataSet = new LinkedHashSet<IBeanMetadata>();
        try {
            if (visitor.hasTypeLevelAnnotations(new String[]{TRANSACTIONAL_CLASS}) || visitor.hasMethodLevelAnnotations(new String[]{TRANSACTIONAL_CLASS})) {
                HashSet<IMethodMetadata> methodMetaData = new HashSet<IMethodMetadata>();
                for (Map.Entry entry : visitor.getMethodLevelAnnotations(new String[]{TRANSACTIONAL_CLASS}).entrySet()) {
                    methodMetaData.add((IMethodMetadata)new TransactionalMethodAnnotationMetadata(TRANSACTIONAL_CLASS, ((IMethod)entry.getKey()).getHandleIdentifier(), ((Annotation)entry.getValue()).getMembers(), (IModelSourceLocation)new JavaModelSourceLocation((IJavaElement)entry.getKey())));
                }
                beanMetaDataSet.add((IBeanMetadata)new TransactionalAnnotationMetadata(bean, TRANSACTIONAL_CLASS, visitor.hasTypeLevelAnnotations(new String[]{TRANSACTIONAL_CLASS}) ? visitor.getTypeLevelAnnotation(TRANSACTIONAL_CLASS).getMembers() : null, (IModelSourceLocation)new JavaModelSourceLocation((IJavaElement)type), methodMetaData));
            }
        }
        catch (JavaModelException javaModelException) {}
        return beanMetaDataSet;
    }
}

