/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.search.internal.queries;

import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.LookupOverride;
import org.springframework.beans.factory.support.MethodOverride;
import org.springframework.beans.factory.support.ReplaceOverride;
import org.springframework.ide.eclipse.beans.core.internal.model.Bean;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeanAlias;
import org.springframework.ide.eclipse.beans.core.model.IBeanProperty;
import org.springframework.ide.eclipse.beans.core.model.IBeanReference;
import org.springframework.ide.eclipse.beans.core.model.IBeansList;
import org.springframework.ide.eclipse.beans.core.model.IBeansMap;
import org.springframework.ide.eclipse.beans.core.model.IBeansMapEntry;
import org.springframework.ide.eclipse.beans.core.model.IBeansSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansTypedString;
import org.springframework.ide.eclipse.beans.core.model.IBeansValueHolder;
import org.springframework.ide.eclipse.beans.ui.search.internal.BeansSearchMessages;
import org.springframework.ide.eclipse.beans.ui.search.internal.BeansSearchScope;
import org.springframework.ide.eclipse.beans.ui.search.internal.queries.AbstractBeansQuery;
import org.springframework.ide.eclipse.core.MessageUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;

public class BeanReferenceQuery
extends AbstractBeansQuery {
    public static final String PROXY_FACTORY_CLASS_NAME = "org.springframework.aop.framework.ProxyFactoryBean";

    public BeanReferenceQuery(BeansSearchScope scope, String pattern, boolean isCaseSensitive, boolean isRegexSearch) {
        super(scope, pattern, isCaseSensitive, isRegexSearch);
    }

    public String getLabel() {
        Object[] args = new Object[]{this.getPattern(), this.getScope().getDescription()};
        return MessageUtils.format((String)BeansSearchMessages.SearchQuery_searchFor_reference, (Object[])args);
    }

    protected boolean doesMatch(IModelElement element, Pattern pattern, IProgressMonitor monitor) {
        if (element instanceof IBeanAlias) {
            IBeanAlias alias = (IBeanAlias)element;
            if (pattern.matcher(alias.getBeanName()).matches()) {
                return true;
            }
        } else if (element instanceof IBean) {
            IBean bean = (IBean)element;
            if (bean.isChildBean() && pattern.matcher(bean.getParentName()).matches()) {
                return true;
            }
            AbstractBeanDefinition bd = (AbstractBeanDefinition)((Bean)element).getBeanDefinition();
            String factoryBeanName = bd.getFactoryBeanName();
            if (factoryBeanName != null && pattern.matcher(factoryBeanName).matches()) {
                return true;
            }
            String[] dependsOnBeanNames = bd.getDependsOn();
            if (dependsOnBeanNames != null) {
                String[] stringArray = dependsOnBeanNames;
                int n = dependsOnBeanNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    if (pattern.matcher(name).matches()) {
                        return true;
                    }
                    ++n2;
                }
            }
            if (!bd.getMethodOverrides().isEmpty()) {
                for (MethodOverride methodOverride : bd.getMethodOverrides().getOverrides()) {
                    String name;
                    if (!(methodOverride instanceof LookupOverride ? pattern.matcher(name = ((LookupOverride)methodOverride).getBeanName()).matches() : methodOverride instanceof ReplaceOverride && pattern.matcher(name = ((ReplaceOverride)methodOverride).getMethodReplacerBeanName()).matches())) continue;
                    return true;
                }
            }
        } else if (element instanceof IBeansValueHolder) {
            return this.doesValueMatch(element, ((IBeansValueHolder)element).getValue(), pattern);
        }
        return false;
    }

    private boolean doesValueMatch(IModelElement element, Object value, Pattern pattern) {
        block13: {
            block14: {
                block15: {
                    block12: {
                        if (!(value instanceof IBeanReference)) break block12;
                        String name = ((IBeanReference)value).getBeanName();
                        if (pattern.matcher(name).matches()) {
                            return true;
                        }
                        break block13;
                    }
                    if (!(value instanceof IBeansList)) break block14;
                    if (!(element instanceof IBeanProperty) || !element.getElementName().equals("interceptorNames")) break block15;
                    String beanClass = BeansModelUtils.getBeanClass((IBean)((IBean)element.getElementParent()), null);
                    if (!PROXY_FACTORY_CLASS_NAME.equals(beanClass)) break block13;
                    IModelElement[] iModelElementArray = ((IBeansList)value).getElementChildren();
                    int n = iModelElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IModelElement child = iModelElementArray[n2];
                        if (child instanceof IBeansTypedString && pattern.matcher(((IBeansTypedString)child).getString()).matches()) {
                            return true;
                        }
                        ++n2;
                    }
                    break block13;
                }
                IModelElement[] iModelElementArray = ((IBeansList)value).getElementChildren();
                int n = iModelElementArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IModelElement child = iModelElementArray[n3];
                    if (this.doesValueMatch(element, child, pattern)) {
                        return true;
                    }
                    ++n3;
                }
                break block13;
            }
            if (value instanceof IBeansSet) {
                IModelElement[] iModelElementArray = ((IBeansSet)value).getElementChildren();
                int n = iModelElementArray.length;
                int n4 = 0;
                while (n4 < n) {
                    IModelElement child = iModelElementArray[n4];
                    if (this.doesValueMatch(element, child, pattern)) {
                        return true;
                    }
                    ++n4;
                }
            } else if (value instanceof IBeansMap) {
                IModelElement[] iModelElementArray = ((IBeansMap)value).getElementChildren();
                int n = iModelElementArray.length;
                int n5 = 0;
                while (n5 < n) {
                    IModelElement child = iModelElementArray[n5];
                    if (child instanceof IBeansMapEntry && (this.doesValueMatch(element, ((IBeansMapEntry)child).getKey(), pattern) || this.doesValueMatch(element, ((IBeansMapEntry)child).getValue(), pattern))) {
                        return true;
                    }
                    ++n5;
                }
            }
        }
        return false;
    }
}

