/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.search.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkingSet;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.model.IBeansModel;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.ui.search.internal.BeansSearchMessages;
import org.springframework.ide.eclipse.core.MessageUtils;
import org.springframework.ide.eclipse.core.SpringCoreUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeansSearchScope {
    private String description;
    private final IModelElement[] modelElements;

    public static BeansSearchScope newSearchScope() {
        return new BeansSearchScope(BeansSearchMessages.SearchScope_workspace, new IModelElement[]{BeansCorePlugin.getModel()});
    }

    public static BeansSearchScope newSearchScope(ISelection selection, boolean isProjectsSelection) {
        String description;
        IModelElement[] elements = BeansSearchScope.convertToElements(selection, isProjectsSelection);
        if (isProjectsSelection) {
            StringBuffer text = new StringBuffer();
            int i = 0;
            while (i < elements.length) {
                IModelElement element = elements[i];
                text.append("'");
                text.append(element.getElementName());
                text.append("'");
                if (i < elements.length - 1) {
                    text.append(", ");
                }
                ++i;
            }
            Object[] args = new Object[]{text.toString()};
            description = MessageUtils.format((String)BeansSearchMessages.SearchScope_selectedProjects, (Object[])args);
        } else {
            description = BeansSearchMessages.SearchScope_selection;
        }
        return new BeansSearchScope(description, elements);
    }

    public static BeansSearchScope newSearchScope(IWorkingSet[] workingSets) {
        StringBuffer text = new StringBuffer();
        int i = 0;
        while (i < workingSets.length) {
            IWorkingSet ws = workingSets[i];
            text.append("'");
            text.append(ws.getName());
            text.append("'");
            if (i < workingSets.length - 1) {
                text.append(", ");
            }
            ++i;
        }
        Object[] args = new Object[]{text.toString()};
        return new BeansSearchScope(MessageUtils.format((String)BeansSearchMessages.SearchScope_workingSets, (Object[])args), BeansSearchScope.convertToElements(workingSets));
    }

    private BeansSearchScope(String description, IModelElement[] elements) {
        Assert.isNotNull((Object)description);
        this.description = description;
        this.modelElements = elements;
    }

    public String getDescription() {
        return this.description;
    }

    public IModelElement[] getModelElements() {
        return this.modelElements;
    }

    private static IModelElement[] convertToElements(IWorkingSet[] workingSets) {
        ArrayList<IModelElement> elements = new ArrayList<IModelElement>();
        IWorkingSet[] iWorkingSetArray = workingSets;
        int n = workingSets.length;
        int n2 = 0;
        while (n2 < n) {
            IAdaptable[] wsElements;
            IWorkingSet element = iWorkingSetArray[n2];
            IAdaptable[] iAdaptableArray = wsElements = element.getElements();
            int n3 = wsElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IAdaptable element0 = iAdaptableArray[n4];
                BeansSearchScope.addToList(element0, elements, true);
                ++n4;
            }
            ++n2;
        }
        return elements.toArray(new IModelElement[elements.size()]);
    }

    private static IModelElement[] convertToElements(ISelection selection, boolean isProjectsSelection) {
        ArrayList<IModelElement> elements = new ArrayList<IModelElement>();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object selectedElement : structuredSelection) {
                if (!(selectedElement instanceof IAdaptable)) continue;
                BeansSearchScope.addToList((IAdaptable)selectedElement, elements, isProjectsSelection);
            }
        }
        return elements.toArray(new IModelElement[elements.size()]);
    }

    private static void addToList(IAdaptable adaptable, List<IModelElement> elements, boolean isProjectsList) {
        IModelElement element = (IModelElement)adaptable.getAdapter(IModelElement.class);
        if (element == null) {
            IResource resource = (IResource)adaptable.getAdapter(IResource.class);
            if (resource instanceof IProject) {
                if (SpringCoreUtils.isSpringProject((IResource)resource)) {
                    IBeansModel model = BeansCorePlugin.getModel();
                    element = model.getProject((IProject)resource);
                }
            } else if (resource instanceof IFile) {
                IBeansModel model = BeansCorePlugin.getModel();
                element = model.getConfig((IFile)resource);
            }
        }
        if (!(element == null || elements.contains(element) || isProjectsList && !(element instanceof IBeansProject))) {
            elements.add(element);
        }
    }

    public String toString() {
        StringBuffer text = new StringBuffer(this.description);
        text.append(" [");
        int i = 0;
        while (i < this.modelElements.length) {
            IModelElement element = this.modelElements[i];
            text.append(element);
            if (i < this.modelElements.length - 1) {
                text.append(", ");
            }
            ++i;
        }
        text.append(']');
        return text.toString();
    }
}

