/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.core.widgets.internal;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;

public class PolylineArcConnection
extends PolylineConnection {
    private int depth = 0;
    private boolean inverse = false;
    private static final float PI = 3.14159f;
    private RectangleFigure center = new RectangleFigure();

    public void setPoints(PointList points) {
        this.updateArc(points);
    }

    public void addPoint(Point pt) {
    }

    public void setDepth(int depth) {
        this.inverse = depth < 0;
        this.depth = depth;
        this.updateArc(this.getPoints());
    }

    protected void updateArc(PointList pointList) {
        float step;
        if (pointList.size() < 2) {
            return;
        }
        if (this.center.getParent() == this) {
            this.remove((IFigure)this.center);
        }
        Point start = pointList.getFirstPoint();
        Point end = pointList.getLastPoint();
        if (this.depth == 0) {
            super.setPoints(pointList);
            return;
        }
        PointList points = new PointList();
        float arcStart = 0.0f;
        float arcEnd = 0.0f;
        float arcLength = 0.0f;
        float cartCenterX = 0.0f;
        float cartCenterY = 0.0f;
        float r = 0.0f;
        float x1 = start.x;
        float y1 = -start.y;
        float x2 = end.x;
        float y2 = -end.y;
        float depth = this.depth;
        if (start.equals((Object)end)) {
            arcStart = -1.570795f;
            arcLength = 6.28318f;
            cartCenterX = x1;
            cartCenterY = y1 + depth / 2.0f;
            r = depth / 2.0f;
        } else {
            float th1;
            if (x1 >= x2) {
                depth = -depth;
            }
            float cartChordX = (x2 + x1) / 2.0f;
            float cartChordY = (y2 + y1) / 2.0f;
            float chordLength = (float)Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
            if (Math.abs(depth) >= chordLength / 2.0f) {
                depth = chordLength / 3.0f * (depth / Math.abs(depth));
            }
            r = (chordLength / 2.0f * (chordLength / 2.0f) + depth * depth) / (2.0f * depth);
            float chordNormal = 0.0f;
            chordNormal = (double)Math.abs(x1 - x2) <= 1.0E-6 ? Float.NaN : ((double)Math.abs(y1 - y2) <= 1.0E-6 ? Float.POSITIVE_INFINITY : -1.0f * (y2 - y1) / (x2 - x1));
            if (Float.isNaN(chordNormal)) {
                cartCenterX = y1 > y2 ? cartChordX - r + depth : cartChordX + r - depth;
                cartCenterY = cartChordY;
                th1 = 1.570795f;
            } else if (Float.isInfinite(chordNormal)) {
                cartCenterX = cartChordX;
                cartCenterY = cartChordY + r - depth;
                th1 = 0.0f;
            } else {
                th1 = (float)Math.atan(chordNormal);
                cartCenterX = (r - depth) * (float)Math.sin(th1) + cartChordX;
                cartCenterY = (r - depth) * (float)Math.cos(th1) + cartChordY;
            }
            float cartArcX1 = x1 - cartCenterX;
            float cartArcY1 = y1 - cartCenterY;
            float cartArcX2 = x2 - cartCenterX;
            float cartArcY2 = y2 - cartCenterY;
            arcStart = this.angleRadians(cartArcX1, cartArcY1);
            arcEnd = this.angleRadians(cartArcX2, cartArcY2);
            if (arcEnd < arcStart) {
                arcEnd = arcEnd + 3.14159f + 3.14159f;
            }
            arcLength = arcEnd - arcStart;
            float pad = 3.14159f / Math.abs(r);
            arcLength = (arcEnd -= pad) - (arcStart += pad);
            if (this.inverse) {
                arcLength = 6.28318f - arcLength;
            }
        }
        r = Math.abs(r);
        float x = 0.0f;
        float y = 0.0f;
        Point p = null;
        points.addPoint(start);
        float length = arcLength * r;
        int steps = (int)length / 16;
        if (steps < 10 && length > 10.0f) {
            steps = 10;
        }
        if (arcLength < 0.7853975f && steps > 6) {
            steps = 6;
        }
        if (steps < 4 && length > 4.0f) {
            steps = 4;
        }
        float stepSize = arcLength / (float)steps;
        if (this.inverse) {
            step = arcStart - stepSize;
            int i = 1;
            while (i < steps) {
                x = r * (float)Math.cos(step) + cartCenterX;
                y = r * (float)Math.sin(step) + cartCenterY;
                p = new Point(Math.round(x), Math.round(-y));
                points.addPoint(p);
                ++i;
                step -= stepSize;
            }
        } else {
            step = stepSize + arcStart;
            int i = 1;
            while (i < steps) {
                x = r * (float)Math.cos(step) + cartCenterX;
                y = r * (float)Math.sin(step) + cartCenterY;
                p = new Point(Math.round(x), Math.round(-y));
                points.addPoint(p);
                ++i;
                step += stepSize;
            }
        }
        points.addPoint(end);
        super.setPoints(points);
    }

    float angleRadians(float x, float y) {
        float theta = (float)Math.atan(y / x);
        switch (this.findQuadrant(x, y)) {
            case 1: {
                return theta;
            }
            case 2: {
                return theta + 3.14159f;
            }
            case 4: {
                theta += 3.14159f;
            }
            case 3: {
                return theta + 3.14159f;
            }
        }
        return theta;
    }

    protected int findQuadrant(float x, float y) {
        if (y > 0.0f) {
            if (x > 0.0f) {
                return 1;
            }
            return 2;
        }
        if (x > 0.0f) {
            return 4;
        }
        return 3;
    }
}

